/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.telephony.TelephonyManager;
import java.util.HashMap;
import org.apache.cordova.BuildHelper;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginResult;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CoreAndroid
extends CordovaPlugin {
    public static final String PLUGIN_NAME = "CoreAndroid";
    protected static final String TAG = "CordovaApp";
    private BroadcastReceiver telephonyReceiver;
    private CallbackContext messageChannel;
    private PluginResult pendingResume;
    private PluginResult pendingPause;
    private final Object messageChannelLock = new Object();

    public void fireJavascriptEvent(String action) {
        this.sendEventMessage(action);
    }

    @Override
    public void pluginInitialize() {
        this.initTelephonyReceiver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(String action, JSONArray args, CallbackContext callbackContext) throws JSONException {
        PluginResult.Status status = PluginResult.Status.OK;
        String result = "";
        try {
            if (action.equals("clearCache")) {
                this.clearCache();
            } else if (action.equals("show")) {
                this.cordova.getActivity().runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        CoreAndroid.this.webView.getPluginManager().postMessage("spinner", "stop");
                    }
                });
            } else if (action.equals("loadUrl")) {
                this.loadUrl(args.getString(0), args.optJSONObject(1));
            } else if (!action.equals("cancelLoadUrl")) {
                if (action.equals("clearHistory")) {
                    this.clearHistory();
                } else if (action.equals("backHistory")) {
                    this.backHistory();
                } else if (action.equals("overrideButton")) {
                    this.overrideButton(args.getString(0), args.getBoolean(1));
                } else if (action.equals("overrideBackbutton")) {
                    this.overrideBackbutton(args.getBoolean(0));
                } else if (action.equals("exitApp")) {
                    this.exitApp();
                } else if (action.equals("messageChannel")) {
                    Object object = this.messageChannelLock;
                    synchronized (object) {
                        this.messageChannel = callbackContext;
                        if (this.pendingPause != null) {
                            this.sendEventMessage(this.pendingPause);
                            this.pendingPause = null;
                        }
                        if (this.pendingResume != null) {
                            this.sendEventMessage(this.pendingResume);
                            this.pendingResume = null;
                        }
                    }
                    return true;
                }
            }
            callbackContext.sendPluginResult(new PluginResult(status, result));
            return true;
        }
        catch (JSONException e) {
            callbackContext.sendPluginResult(new PluginResult(PluginResult.Status.JSON_EXCEPTION));
            return false;
        }
    }

    public void clearCache() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CoreAndroid.this.webView.clearCache();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadUrl(String url, JSONObject props) throws JSONException {
        Object keys;
        LOG.d("App", "App.loadUrl(" + url + "," + props + ")");
        int wait = 0;
        boolean openExternal = false;
        boolean clearHistory = false;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (props != null) {
            keys = props.names();
            for (int i = 0; i < keys.length(); ++i) {
                String key = keys.getString(i);
                if (key.equals("wait")) {
                    wait = props.getInt(key);
                    continue;
                }
                if (key.equalsIgnoreCase("openexternal")) {
                    openExternal = props.getBoolean(key);
                    continue;
                }
                if (key.equalsIgnoreCase("clearhistory")) {
                    clearHistory = props.getBoolean(key);
                    continue;
                }
                Object value = props.get(key);
                if (value == null) continue;
                if (value.getClass().equals(String.class)) {
                    params.put(key, (String)value);
                    continue;
                }
                if (value.getClass().equals(Boolean.class)) {
                    params.put(key, (Boolean)value);
                    continue;
                }
                if (!value.getClass().equals(Integer.class)) continue;
                params.put(key, (Integer)value);
            }
        }
        if (wait > 0) {
            try {
                keys = this;
                synchronized (keys) {
                    this.wait(wait);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.webView.showWebPage(url, openExternal, clearHistory, params);
    }

    public void clearHistory() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CoreAndroid.this.webView.clearHistory();
            }
        });
    }

    public void backHistory() {
        this.cordova.getActivity().runOnUiThread(new Runnable(){

            @Override
            public void run() {
                CoreAndroid.this.webView.backHistory();
            }
        });
    }

    public void overrideBackbutton(boolean override) {
        LOG.i("App", "WARNING: Back Button Default Behavior will be overridden.  The backbutton event will be fired!");
        this.webView.setButtonPlumbedToJs(4, override);
    }

    public void overrideButton(String button, boolean override) {
        LOG.i("App", "WARNING: Volume Button Default Behavior will be overridden.  The volume event will be fired!");
        if (button.equals("volumeup")) {
            this.webView.setButtonPlumbedToJs(24, override);
        } else if (button.equals("volumedown")) {
            this.webView.setButtonPlumbedToJs(25, override);
        } else if (button.equals("menubutton")) {
            this.webView.setButtonPlumbedToJs(82, override);
        }
    }

    public boolean isBackbuttonOverridden() {
        return this.webView.isButtonPlumbedToJs(4);
    }

    public void exitApp() {
        this.webView.getPluginManager().postMessage("exit", null);
    }

    private void initTelephonyReceiver() {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PHONE_STATE");
        this.telephonyReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                if (intent != null && intent.getAction().equals("android.intent.action.PHONE_STATE") && intent.hasExtra("state")) {
                    String extraData = intent.getStringExtra("state");
                    if (extraData.equals(TelephonyManager.EXTRA_STATE_RINGING)) {
                        LOG.i(CoreAndroid.TAG, "Telephone RINGING");
                        CoreAndroid.this.webView.getPluginManager().postMessage("telephone", "ringing");
                    } else if (extraData.equals(TelephonyManager.EXTRA_STATE_OFFHOOK)) {
                        LOG.i(CoreAndroid.TAG, "Telephone OFFHOOK");
                        CoreAndroid.this.webView.getPluginManager().postMessage("telephone", "offhook");
                    } else if (extraData.equals(TelephonyManager.EXTRA_STATE_IDLE)) {
                        LOG.i(CoreAndroid.TAG, "Telephone IDLE");
                        CoreAndroid.this.webView.getPluginManager().postMessage("telephone", "idle");
                    }
                }
            }
        };
        this.webView.getContext().registerReceiver(this.telephonyReceiver, intentFilter);
    }

    private void sendEventMessage(String action) {
        JSONObject obj = new JSONObject();
        try {
            obj.put("action", (Object)action);
        }
        catch (JSONException e) {
            LOG.e(TAG, "Failed to create event message", e);
        }
        PluginResult result = new PluginResult(PluginResult.Status.OK, obj);
        if (this.messageChannel == null) {
            LOG.i(TAG, "Request to send event before messageChannel initialised: " + action);
            if ("pause".equals(action)) {
                this.pendingPause = result;
            } else if ("resume".equals(action)) {
                this.pendingPause = null;
            }
        } else {
            this.sendEventMessage(result);
        }
    }

    private void sendEventMessage(PluginResult payload) {
        payload.setKeepCallback(true);
        if (this.messageChannel != null) {
            this.messageChannel.sendPluginResult(payload);
        }
    }

    @Override
    public void onDestroy() {
        this.webView.getContext().unregisterReceiver(this.telephonyReceiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResumeEvent(PluginResult resumeEvent) {
        Object object = this.messageChannelLock;
        synchronized (object) {
            if (this.messageChannel != null) {
                this.sendEventMessage(resumeEvent);
            } else {
                this.pendingResume = resumeEvent;
            }
        }
    }

    @Deprecated
    public static Object getBuildConfigValue(Context ctx, String key) {
        LOG.w(TAG, "CoreAndroid.getBuildConfigValue is deprecated and will be removed in a future release. Use BuildHelper.getBuildConfigValue instead.");
        return BuildHelper.getBuildConfigValue(ctx, key);
    }
}

