<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Validator;
use Mail;
class Delivery extends Authenticatable
{
    protected $table = "delivery_boys";

    /*
    |----------------------------------------------------------------
    |   Validation Rules and Validate data for add & Update Records
    |----------------------------------------------------------------
    */
    
    public function rules($type)
    {
        if($type === 'add')
        {
            return [

            'phone' => 'required|unique:delivery_boys',

            ];
        }
        else
        {
            return [

            'phone'     => 'required|unique:delivery_boys,phone,'.$type,

            ];
        }
    }
    
    public function validate($data,$type)
    {

        $validator = Validator::make($data,$this->rules($type));       
        if($validator->fails())
        {
            return $validator;
        }
    }

    /*
    |--------------------------------
    |Create/Update city
    |--------------------------------
    */

    public function addNew($data,$type)
    {
        $a                      = isset($data['lid']) ? array_combine($data['lid'], $data['l_name']) : [];
        $add                    = $type === 'add' ? new Delivery : Delivery::find($type);
        $add->store_id          = isset($data['user_id']) ? $data['user_id'] : 0;
        $add->name              = isset($data['name']) ? $data['name'] : null;
        $add->charge            = isset($data['charge']) ? $data['charge'] : 0;
        $add->phone             = isset($data['phone']) ? $data['phone'] : null;
        $add->status            = isset($data['status']) ? $data['status'] : 0;
        $add->per_km            = isset($data['per_km']) ? $data['per_km'] : 0;
        $add->v_type            = isset($data['v_type']) ? $data['v_type'] : null;
        $add->email             = isset($data['email']) ? $data['email'] : null;
        $add->s_data            = serialize($a);

        if(isset($data['password']))
        {
            $add->password      = bcrypt($data['password']);
            $add->shw_password  = $data['password'];
        }

        if(isset($data['img']))
        {
            $filename   = time().rand(111,699).'.' .$data['img']->getClientOriginalExtension(); 
            $data['img']->move("upload/delivery/", $filename);   
            $add->profile_img = $filename;  
        }

        if(isset($data['lic']))
        {
            $filename2   = time().rand(111,699).'.' .$data['lic']->getClientOriginalExtension(); 
            $data['lic']->move("upload/delivery/", $filename2);   
            $add->lic = $filename2; 
        }

        if(isset($data['vimg']))
        {
            $filename3   = time().rand(111,699).'.' .$data['vimg']->getClientOriginalExtension(); 
            $data['vimg']->move("upload/delivery/", $filename3);   
            $add->vimg = $filename3; 
        }

        $add->save();
    }

    /*
    |--------------------------------------
    |Get all data from db
    |--------------------------------------
    */
    public function getAll($store = "all")
    {
        return Delivery::where(function($query) use($store) {

            if($store !== "all")
            {
                $query->where('store_id',$store);
            }

        })->leftjoin('users','delivery_boys.store_id','=','users.id')
          ->select('users.name as store','delivery_boys.*')
          ->orderBy('delivery_boys.id','DESC')->get();
    }

   public function login($data)
   {
     $chk = Delivery::where('status',0)->where('email',$data['email'])->where('shw_password',$data['password'])->first();

     if(isset($chk->id))
     {
        return ['msg' => 'done','user' => $chk];
     }
     else
     {
        return ['msg' => 'Opps! Invalid login details'];
     }
   }

   public function getSData($data,$id,$field)
    {
        $data = unserialize($data);

        return isset($data[$id]) ? $data[$id] : null;
    }

   public function getAllAssign($id)
   {
        $order  = Order::find($id);
        
        return Delivery::where('status',0)->where('store_id',$order->store_id)->get();

   }

   public function earn()
   {
        $total    = Order::where('dboy',$_GET['id'])->where('status',5)->count();
        $month    = Order::where('dboy',$_GET['id'])->where('status',5)
                         ->where('created_at','LIKE',date('Y-m').'%')
                         ->count();

        $dboy     = Delivery::find($_GET['id']);

        return [

        'total'         => $total,
        'month'         => $month,
        'total_earn'    => round($total * $dboy->charge),
        'month_earn'    => round($month * $dboy->charge),
        'currency'      => User::find(1)->currency

        ];
    }

    public function forgot($data)
   {
        $res = Delivery::where('email',$data['email'])->first();

        if(isset($res->id))
        {
            $otp            = rand(1111,9999);
            $res->vcode     = $otp;
            $res->save();

            Mail::send('email',['res' => $res,'otp' => $otp], function($message) use($res)
            {     
               $message->to($res->email)->subject("Verify Your Email");
                        
            });

            $return = ['msg' => 'done','user_id' => $res->id,'message' => 'OTP sent successfully on your email. Verify it.','otp' => $otp];
        }
        else
        {
            $return = ['msg' => 'error','error' => 'Sorry! This email is not registered with us.'];
        }

        return $return;
   }

   public function updatePassword($data)
    {
        $res = Delivery::where('id',$_GET['user_id'])->first();

        if(isset($res->id))
        {
            $res->password         = bcrypt($data['password']);
            $res->shw_password     = $data['password'];
            $res->save();

            $return = ['msg' => 'done','user_id' => $res->id];
        }
        else
        {
            $return = ['msg' => 'error','error' => 'Sorry! Something went wrong.'];
        }

        return $return;
    }

    public function updateAccount($data)
    {
		$img  = isset($data['profile_img']) ? $data['profile_img'] : null;
		$lic  = isset($data['lic']) ? $data['lic'] : null;
		$vimg = isset($data['vimg']) ? $data['vimg'] : null;
      	$data = json_decode($data['data']);

        $count = Delivery::where('id','!=',$_GET['user_id'])->where('email',$data->email)->count();

        if($count > 0)
        {
            return response()->json(['msg' => 'error','error' => 'This email is already exists.']);
            exit;
        }

        $res                = Delivery::find($_GET['user_id']);
        $res->name          = $data->name;
        $res->phone         = $data->phone;
        $res->email         = $data->email;
        $res->v_type        = $data->v_type;

        if($res->password)
        {
            $res->shw_password = $data->password;
        }

        if($img)
        {
            $filename   = time().rand(111,699).'.' .$img->getClientOriginalExtension(); 
            $img->move("upload/delivery/", $filename);   
            $res->profile_img = $filename;  
        }

        if($lic)
        {
            $filename2   = time().rand(111,699).'.' .$lic->getClientOriginalExtension(); 
            $lic->move("upload/delivery/", $filename2);   
            $res->lic = $filename2; 
        }

        if($vimg)
        {
            $filename3   = time().rand(111,699).'.' .$vimg->getClientOriginalExtension(); 
            $vimg->move("upload/delivery/", $filename3);   
            $res->vimg = $filename3; 
        }

        $res->Save();

        return ['msg' => 'done'];
    }
}
