<?php
if(Session::has('locale') && Session::get('locale') == "ae")
{
  $dir = "rtl";
  $css = "css-rtl";
}
else
{
  $dir = "ltr";
  $css = "css";
}
?>

<!doctype html>
<html lang="en" class=" layout-wide  customizer-hide" dir="{{ $dir }}" data-skin="default" data-assets-path="{{ Asset('assets') }}" data-template="vertical-menu-template" data-bs-theme="light">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />

<title>@yield('title') | @lang('app.app_name')</title>

<link rel="icon" type="image/x-icon" href="{{ Asset('assets/img/favicon.png') }}" />

<link rel="preconnect" href="https://fonts.googleapis.com/" />
<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin />
<link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&amp;ampdisplay=swap" rel="stylesheet" />

<link rel="stylesheet" href="{{ Asset('assets/vendor/fonts/iconify-icons.css') }}" />

<link rel="stylesheet" href="{{ Asset('assets/vendor/libs/node-waves/node-waves.css') }}" />


<link rel="stylesheet" href="{{ Asset('assets/vendor/libs/pickr/pickr-themes.css') }}" />

<link rel="stylesheet" href="{{ Asset('assets/vendor/css/core.css') }}" />
<link rel="stylesheet" href="{{ Asset('assets/css/demo.css') }}" />    
<link rel="stylesheet" href="{{ Asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css') }}" />

<link rel="stylesheet" href="{{ Asset('assets/vendor/libs/apex-charts/apex-charts.css') }}" />
<link rel="stylesheet" href="{{ Asset('assets/vendor/fonts/flag-icons.css') }}" />

@yield('css')

</head>

<body>

<div class="layout-wrapper layout-content-navbar  ">
<div class="layout-container">

@include('layout.menu')

<div class="layout-page">

@include('layout.header')

@yield('content')

<div class="content-backdrop fade"></div>
</div>
</div>
</div>

<div class="layout-overlay layout-menu-toggle"></div>

<div class="drag-target"></div>

</div>

<script src="{{ Asset('assets/vendor/libs/jquery/jquery.js') }}"></script>

<script src="{{ Asset('assets/vendor/libs/popper/popper.js') }}"></script>
<script src="{{ Asset('assets/vendor/js/bootstrap.js') }}"></script>
<script src="{{ Asset('assets/vendor/libs/node-waves/node-waves.js') }}"></script>

<script src="{{ Asset('assets/vendor/libs/%40algolia/autocomplete-js.js') }}"></script>

<script src="{{ Asset('assets/vendor/libs/pickr/pickr.js') }}"></script>

<script src="{{ Asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js') }}"></script>

<script src="{{ Asset('assets/vendor/libs/hammer/hammer.js') }}"></script>

<script src="{{ Asset('assets/vendor/libs/i18n/i18n.js') }}"></script>

<script src="{{ Asset('assets/vendor/js/menu.js') }}"></script>


<script src="{{ Asset('assets/js/main.js') }}"></script>


@yield('js')

</body>

</html>


