@extends('layout.main')

@section('title') {{ $title }} @endsection

@section('content')

<form action="{{ Asset('order') }}" method="GET">
<div class="row">
<div class="col-md-12">
<div class="card">
<div class="card-content" style="padding: 20px 20px;">

<input type="hidden" name="status" value="{{ $_GET['status'] }}">

<div class="row">
<div class="form-group col-md-4">
<input type="text" class="form-control" name="order_q" placeholder="Search with Order ID,User Name or Phone..." value="{{ $q }}">
</div>

<div class="form-group col-md-4">
<select name="store_id" class="form-control select2">
<option value="">All Store</option>
@foreach($stores as $store)
<option value="{{ $store->id }}" @if($sid == $store->id) selected @endif>{{ $store->name }}</option>
@endforeach
</select>
</div>

<div class="form-group col-md-4">
<button type="submit" class="btn btn-primary">Filter</button>
</div>

</div>

</div>
</div>
</div>
</div>
</form>
<br>

<section id="basic-input">
<div class="row">
<div class="col-md-12">
<div class="card">

<div class="row" id="table-head">
<div class="col-12">
<div class="card">
<div class="card-content">

<div class="card-body"><h4 class="card-title">{{ $title }}</h4> </div>
<div class="table-responsive">
@include('order.table')
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</section>

@endsection

@section('css')
<link rel="stylesheet" href="{{ Asset('assets/vendor/libs/select2/select2.css') }}" />
@endsection

@section('js')
<script src="{{ Asset('assets/vendor/libs/select2/select2.js') }}"></script>
<script src="{{ Asset('assets/js/forms-selects.js') }}"></script>
<script src="{{ Asset('assets/js/forms-tagify.js') }}"></script>
<script src="{{ Asset('assets/js/forms-typeahead.js') }}"></script>

@endsection