<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<title>@lang('app.view_order_detail')</title>
</head>
<body onload="window.print()">

<style type="text/css">
td
{
  padding:10px 10px;
}
</style>

<h1 align="center">@lang('app.view_order_no') #{{ $data->id }}</h1>
<table width="100%" cellpadding="0" cellspacing="0" border="1" align="center">
<tr>
<td width="40%"><b>@lang('app.view_store')</b></td>
<td width="60%">{{ $data->store }}</td>
</tr>

<tr>
<td width="40%"><b>@lang('app.view_user')</b></td>
<td width="60%">{{ $data->name }}</td>
</tr>

<tr>
<td width="40%"><b>@lang('app.view_phone')</b></td>
<td width="60%">{{ $data->name }}</td>
</tr>

<tr>
<td width="40%"><b>@lang('app.view_address')</b></td>
<td width="60%">{{ $data->address }}</td>
</tr>

<tr>
<td width="40%"><b>@lang('app.view_order_date')</b></td>
<td width="60%">{{ date('d-M-Y h:i:A',strtotime($data->created_at)) }}</td>
</tr>

@if($data->odate == 2)

<tr>
<td width="40%"><b>Delivery Date</b></td>
<td width="60%">{{ date('d-M-Y',strtotime($data->order_date)) }} | {{ $data->order_time }}</td>
</tr>

@endif

</table>

<br><br>
<b style="margin-left: 20%;">@lang('app.view_order_items')</b>
<br><br>
<table width="100%" cellpadding="0" cellspacing="0" border="1" align="center">
<tr>
<td width="15%"><b>@lang('app.view_s_no')</b></td>
<td width="30%"><b>@lang('app.view_item')</b></td>
<td width="15%"><b>@lang('app.view_price')</b></td>
<td width="20%"><b>@lang('app.view_qty')</b></td>
<td width="20%"><b>@lang('app.view_total')</b></td>
</tr>
@php($i = 0)
@php($total = [])
@foreach($item->getItem($data->id) as $row)
@php($i++)
@php($total[] = $row['price'] * $row['qty'])
<tr>
<td width="15%">{{ $i }}</td>
<td width="30%">{{ $row['item'] }}</td>
<td width="15%">{{ $c.number_format($row['price'],2) }}</td>
<td width="20%">{{ $row['qty'] }}</td>
<td width="20%">{{ $c.number_format($row['price'] * $row['qty'],2) }}</td>
</tr>
@php($a = 0)
@foreach($row['addon'] as $addon)
@php($a++)
@php($total[] = $addon->price * 1)
<tr>
<td width="15%">+ {{ $a }}</td>
<td width="30%">{{ $addon->addon }}</td>
<td width="15%">{{ $c.number_format($addon->price,2) }}</td>
<td width="20%">1</td>
<td width="20%">{{ $c.number_format($addon->price * 1,2) }}</td>
</tr>
@endforeach

@endforeach

<tr>
<td width="15%">&nbsp;</td>
<td width="30%">&nbsp;</td>
<td width="20%" colspan="2"><b>@lang('app.view_sub_total')</b></td>
<td width="20%">{{ $c.number_format(array_sum($total),2) }}</td>
</tr>

@if($data->discount > 0)
<tr>
<td width="15%">&nbsp;</td>
<td width="30%">&nbsp;</td>
<td width="20%" colspan="2"><b>@lang('app.view_discount')</b></td>
<td width="20%">{{ $c.number_format($data->discount,2) }}</td>
</tr>
@endif

@if($data->tax_value > 0)
<tr>
<td width="15%">&nbsp;</td>
<td width="30%">&nbsp;</td>
<td width="20%" colspan="2"><b>{{ $data->tax_name }}</b></td>
<td width="20%">{{ $c.number_format($data->tax_value,2) }}</td>
</tr>
@endif

@if($data->d_charges > 0)
<tr>
<td width="15%">&nbsp;</td>
<td width="30%">&nbsp;</td>
<td width="20%" colspan="2"><b>@lang('app.view_delivery')</b></td>
<td width="20%">{{ $c.number_format($data->d_charges,2) }}</td>
</tr>
@endif

@if($data->tip > 0)
<tr>
<td width="15%">&nbsp;</td>
<td width="30%">&nbsp;</td>
<td width="20%" colspan="2"><b>Tip For Rider</b></td>
<td width="20%">{{ $c.number_format($data->tip,2) }}</td>
</tr>
@endif

<tr>
<td width="15%">Payment</td>
<td width="30%">

@if($data->payment_method == 1)

Cash on Delivery

@elseif($data->payment_method == 2 || $data->payment_method == 3)

Online Paid

@endif

@if($data->ecash > 0)

@if($data->total == $data->ecash)
Paid with eCash
@else
<p>eCash Paid {{ $data->ecash }}</p>
<p>Payable Balance {{ ($data->total - $data->ecash) + $data->tip }}</p>
@endif

@endif

</td>
<td width="20%" colspan="2"><b>@lang('app.view_grand_total')</b></td>
<td width="20%"><b>{{ $c.number_format($data->total,2) }}</b></td>
</tr>

</table>

</body>
</html>