@extends('layout.main')

@section('title') @lang('app.manage_store') @endsection

@section('content')

<form action="{{ Asset('store') }}" method="GET">
<div class="row">
<div class="col-md-12">
<div class="card">
<div class="card-content" style="padding: 20px 20px;">

<div class="row">
<div class="form-group col-md-4">
<input type="text" class="form-control" name="q" placeholder="Search with Store Name, Phone or Email..." value="{{ $q }}">
</div>

<div class="form-group col-md-4">
<select name="type" class="form-control">
<option value="">All Store</option>
<option value="1" @if($type == 1) selected @endif>Trending Store</option>
<option value="2" @if($type == 2) selected @endif>Non Trending Store</option>
<option value="3" @if($type == 3) selected @endif>Closed Store</option>
<option value="4" @if($type == 4) selected @endif>Open Store</option>
</select>
</div>

<div class="form-group col-md-4">
<button type="submit" class="btn btn-primary">Filter</button>
</div>

</div>

</div>
</div>
</div>
</div>
</form>
<br>
<section id="basic-input">
<div class="row">
<div class="col-md-12">
<div class="card">

<div class="row" id="table-head">
<div class="col-12">
<div class="card">
<div class="card-content">

<div class="card-body"><h4 class="card-title">@lang('app.manage_store') <a href="{{ Asset($link.'add') }}" class="btn btn-primary" style="float: right">@lang('app.add_new')</a></h4> </div>
<div class="table-responsive">
<table class="table mb-0">
<thead >
<tr>
<th>ID</th>
<th>@lang('app.store_image')</th>
<th>@lang('app.store_name')</th>
<th>@lang('app.email')</th>
<th>@lang('app.phone')</th>
<th>@lang('app.status')</th>
<th>Subscription</th>
<th class="text-right">@lang('app.store_option')</th>
</tr>
</thead>
<tbody>

@foreach($data as $row)
<tr>
<td width="5%">{{ $row->id }}</td>
<td width="5%">@if($row->img) <img src="{{ Asset('upload/store/'.$row->img) }}" style="height: 50px;border-radius: 2px;"> @endif</td>
<td width="17%">{{ $row->name }}

@if($row->signup_by)
<br><small style="color:red">@lang('app.from_app')</small>
@endif

</td>
<td width="17%">{{ $row->email }}</td>
<td width="17%">{{ $row->phone }}</td>
<td width="17%">
<a href="{{ Asset('storeAction?action=status&id='.$row->id) }}" onclick="return confirm('Are you sure?')">
@if($row->status == 0)
<span class="badge bg-label-primary me-1">@lang('app.active')</span>
@else
<span class="badge bg-label-danger me-1">@lang('app.disbale')</span>
@endif
</a>

@if($row->open == 1)

<p class="text-danger mt-2">Store is closed</p>

@endif

</td>

<td width="17%">
@php($checkPlan = $row->checkPlan($row->id))
<a data-bs-toggle="modal" href="javascript::void()" data-bs-target="#assign{{ $row->id }}">
@if($checkPlan == 0)

<span class="badge bg-label-danger me-1">@lang('app.assign')</span>


@elseif($checkPlan == 1)

<span class="badge bg-label-success me-1">{{ $row->plan }}</span>


@elseif($checkPlan == 2)

<span class="badge bg-label-danger me-1">@lang('app.plan_expir')</span>

@elseif($checkPlan == 3)

<span class="badge bg-label-warning me-1">@lang('app.payment_pending')</span>

@endif
</a>
</td>

<td width="5%">

<div class="dropdown">
<button type="button" class="btn p-0 dropdown-toggle hide-arrow" data-bs-toggle="dropdown">
<i class="icon-base ti tabler-dots-vertical"></i>
</button>
<div class="dropdown-menu">
<a class="dropdown-item" href="{{ Asset('loginAsStore?id='.$row->id) }}" target="_blank"><i class="icon-base ti tabler-login me-1"></i> @lang('app.login_store')</a>
<a class="dropdown-item" data-bs-toggle="modal" href="javascript::void()" data-bs-target="#login_{{ $row->id }}" ><i class="icon-base ti tabler-copy me-1"></i> View Login info</a>
<a class="dropdown-item" href="{{ Asset('qr?id='.$row->id) }}" target="_blank"><i class="icon-base ti tabler-qrcode me-1"></i> @lang('app.gen_qr')</a>
<a class="dropdown-item @if($row->trend == 1) text-danger @endif" href="{{ Asset('storeAction?action=trend&id='.$row->id) }}" onclick="return confirm('Are you sure?')"><i class="icon-base ti tabler-trending-up me-1"></i> @if($row->trend == 1) @lang('app.in_trend') @else @lang('app.make_trend')@endif</a>

<a class="dropdown-item @if($row->open == 1) text-danger @endif" href="{{ Asset('storeAction?action=open&id='.$row->id) }}" onclick="return confirm('Are you sure?')"><i class="icon-base ti tabler-clock me-1"></i> @if($row->open == 0) Store is Open Now @else Store is Closed Now @endif</a>

<a class="dropdown-item" href="{{ Asset($link.$row->id.'/edit') }}"><i class="icon-base ti tabler-edit me-1"></i> @lang('app.edit')</a>
<a class="dropdown-item" href="{{ Asset($link.'delete/'.$row->id) }}" onclick="return confirm('Are you sure?')"><i class="icon-base ti tabler-trash me-1"></i> @lang('app.delete')</a>


</div>

</td>
</tr>


@include('store.login')

@include('store.plan')


@endforeach

</tbody>
</table>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</section>

<script type="text/javascript">

function paid(pay,id)
{
	if(pay > 0)
	{
		window.location.href = "{{ Asset('pay?pay=') }}"+pay+"&id="+id;
	}
}

</script>

@endsection