<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>QR Code | {{ $data->name }}</title>
    <style>
        @media print {
            body * {
                visibility: hidden;
            }
            #print-area, #print-area * {
                visibility: visible;
            }
            #print-area {
                position: absolute;
                left: 0;
                top: 0;
                width: 100%;
            }
        }
    </style>
    <script>
        window.onload = function () {
            window.print();
        };
    </script>
</head>
<body>
    <div id="print-area" style="text-align: center;">
        <h1>{{ $data->name }}</h1>
        <p>{!! QrCode::size(200)->generate($url) !!}</p>
        <p>Scan QR Code for Quick Order from Web</p>
    </div>
</body>
</html>
