@extends('store_end.layout.main')

@section('title') @lang('app.category') @endsection

@section('content')

<section id="basic-input">
<div class="row">
<div class="col-md-12">
<div class="card">

<div class="row" id="table-head">
<div class="col-12">
<div class="card">
<div class="card-content">

<div class="card-body"><h4 class="card-title">@lang('app.category') <a href="{{ Asset($link.'add') }}" class="btn btn-primary" style="float: right">@lang('app.add_new')</a></h4> </div>
<div class="table-responsive">
<table class="table mb-0">
<thead >
<tr>
<th>@lang('app.category_title')</th>
<th>@lang('app.status')</th>
<th class="text-right">@lang('app.option')</th>
</tr>
</thead>
<tbody>

@foreach($data as $row)
<tr>
<td width="40%">{{ $row->name }}</td>
<td width="40%">

@if($row->status == 0)
<span class="badge bg-label-primary me-1">@lang('app.active')</span>
@else
<span class="badge bg-label-danger me-1">@lang('app.disbale')</span>
@endif	

</td>
<td width="20%" class="text-right">

<a class="btn btn-icon btn-primary mr-1 mb-1 waves-effect waves-light" data-toggle="tooltip" data-placement="top" data-original-title="@lang('app.edit')" href="{{ Asset($link.$row->id.'/edit') }}"><i class="fa fa-edit"></i></a>

<a href="{{ Asset($link.'delete/'.$row->id) }}" class="btn btn-icon btn-danger mr-1 mb-1 waves-effect waves-light" data-toggle="tooltip" data-placement="top" data-original-title="@lang('app.delete')" onclick="return confirm('Are you sure?')"><i class="fa fa-trash"></i></a>

</td>
</tr>
@endforeach

</tbody>
</table>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</div>
</section>

@endsection