@extends('store_end.layout.main')

@section('title') @lang('app.sd_dashboard') @endsection

@section('content')

@include('store_end.dashboard.overview')<br>

@include('store_end.dashboard.chart')<br>


<h5 class="card-title mb-0 text-dark">Latest Orders <a class="btn btn-primary btn-sm" style="float:right" href="{{ Asset(env('store').'/order?status=0') }}">View All</a></h5>
<p style="font-size: 13px;">Showing last 15 orders</p>
<div class="row">
<div class="col-md-12">
<div class="card">
@include('store_end.order.table',['data' => $order,'c' => $c])

</div>
</div>
</div>

@endsection

@section('js')
<script src="{{ Asset('assets/vendor/libs/chartjs/chartjs.js') }}"></script>
<script src="{{ Asset('assets/js/charts-chartjs-legend.js') }}"></script>
<script src="{{ Asset('assets/js/charts-chartjs.js') }}"></script>
<script src="{{ Asset('assets/vendor/libs/apex-charts/apexcharts.js') }}"></script>
<script src="{{ Asset('assets/js/charts-apex.js') }}"></script>

<script>
   

    //BarChart
    document.addEventListener("DOMContentLoaded", function () {
        const barChart = document.getElementById('monthOrder');
        if (barChart) {
            new Chart(barChart, {
                type: 'bar',
                data: {
                    labels: @json($barChart['label']),
                    datasets: [{
                        data: @json($barChart['value']),
                        backgroundColor: '#28dac6',
                        borderColor: 'transparent',
                        maxBarThickness: 15,
                        borderRadius: { topRight: 15, topLeft: 15 }
                    }]
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    animation: { duration: 500 },
                    plugins: {
                        tooltip: {
                            rtl: false,
                            backgroundColor: '#EDF1F4',
                            titleColor: '#5f6e7b',
                            bodyColor: '#5f6e7b',
                            borderWidth: 1,
                            borderColor: '#d9dee3'
                        },
                        legend: { display: false }
                    },
                    scales: {
                        x: {
                            grid: { color: '#d9dee3', drawBorder: false },
                            ticks: { color: '#a1acb8' }
                        },
                        y: {
                            min: 0,
                            max: {{ $barChart['max'] }},
                            grid: { color: '#d9dee3', drawBorder: false },
                            ticks: { stepSize: 100, color: '#a1acb8' }
                        }
                    }
                }
            });
        }
    });
    
  </script>


@endsection

@section('css')

<link rel="stylesheet" href="{{ Asset('assets/vendor/libs/apex-charts/apex-charts.css') }}" />
<link rel="stylesheet" href="{{ Asset('assets/vendor/libs/datatables-bs5/datatables.bootstrap5.css') }}" />
<link rel="stylesheet" href="{{ Asset('assets/vendor/libs/datatables-responsive-bs5/responsive.bootstrap5.css') }}" />
<link rel="stylesheet" href="{{ Asset('assets/vendor/libs/datatables-buttons-bs5/buttons.bootstrap5.css') }}" />

@endsection