@extends('store_end.layout.main')

@section('title') @lang('app.report') @endsection

@section('content')

<section id="basic-input">
<div class="row">
<div class="col-md-12">
<div class="card">
<div class="card-header">
<h4 class="card-title">Reporting</h4>
</div>

{!! Form::open(['url' => [Asset('getReport')],'method' => 'GET','target' => '_blank']) !!}

<div class="card-content">
<div class="card-body">

<div class="row">
<div class="form-group col-md-4">
<label for="flatpickr-date" class="form-label">From Date</label>
<input type="text" class="form-control" placeholder="YYYY-MM-DD" id="flatpickr-date" required name="from"/>
</div>

<div class="form-group col-md-4">
    <label for="flatpickr-date2" class="form-label">To Date</label>
    <input type="text" class="form-control" placeholder="YYYY-MM-DD" id="flatpickr-date2" required name="to"/>
</div>

<div class="form-group col-md-4">
<label for="inputEmail6" class="form-label">@lang('app.dboy')</label>
<select name="dboy" class="form-control">
<option value="">@lang('app.all')</option>
@foreach($dboy as $db)
<option value="{{ $db->id }}">{{ $db->name }}</option>
@endforeach
</select>
</div>
</div>

<br>
<button type="submit" class="btn btn-primary mr-1 mb-1 waves-effect waves-light">@lang('app.get_report')</button>


</div>
</div>

</form>
</div>
</div>
</div>
</section>

@endsection

@section('css')

<link rel="stylesheet" href="{{ Asset('assets/vendor/libs/flatpickr/flatpickr.css') }}" />
<link rel="stylesheet" href="{{ Asset('assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.css') }}" />
<link rel="stylesheet" href="{{ Asset('assets/vendor/libs/jquery-timepicker/jquery-timepicker.css') }}" />
<link rel="stylesheet" href="{{ Asset('assets/vendor/libs/pickr/pickr-themes.css') }}" />

@endsection

@section('js')

<script src="{{ Asset('assets/vendor/libs/moment/moment.js') }}"></script>
<script src="{{ Asset('assets/vendor/libs/flatpickr/flatpickr.js') }}"></script>
<script src="{{ Asset('assets/vendor/libs/bootstrap-daterangepicker/bootstrap-daterangepicker.js') }}"></script>
<script src="{{ Asset('assets/vendor/libs/jquery-timepicker/jquery-timepicker.js') }}"></script>
<script src="{{ Asset('assets/vendor/libs/pickr/pickr.js') }}"></script>
<script src="{{ Asset('assets/js/forms-pickers.js') }}"></script>
<script>
    flatpickr("#flatpickr-date", {
        dateFormat: "Y-m-d"
    });

    flatpickr("#flatpickr-date2", {
        dateFormat: "Y-m-d"
    });
</script>
@endsection