<!doctype html>
<html lang="en" class=" layout-wide  customizer-hide" dir="ltr" data-skin="default" data-assets-path="<?php echo e(Asset('assets')); ?>" data-template="vertical-menu-template" data-bs-theme="light">
<head>
<meta charset="utf-8" />
<meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
<title>Welcome | <?php echo app('translator')->get('app.app_name'); ?></title>
<link rel="icon" type="image/x-icon" href="<?php echo e(Asset('assets/img/favicon.png')); ?>" />

<link rel="preconnect" href="https://fonts.googleapis.com/" />
<link rel="preconnect" href="https://fonts.gstatic.com/" crossorigin />
<link href="https://fonts.googleapis.com/css2?family=Public+Sans:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&amp;ampdisplay=swap" rel="stylesheet" />

<link rel="stylesheet" href="<?php echo e(Asset('assets/vendor/fonts/iconify-icons.css')); ?>" />    
<link rel="stylesheet" href="<?php echo e(Asset('assets/vendor/libs/node-waves/node-waves.css')); ?>" />
<link rel="stylesheet" href="<?php echo e(Asset('assets/vendor/libs/pickr/pickr-themes.css')); ?>" />
<link rel="stylesheet" href="<?php echo e(Asset('assets/vendor/css/core.css')); ?>" />
<link rel="stylesheet" href="<?php echo e(Asset('assets/css/demo.css')); ?>" />    
<link rel="stylesheet" href="<?php echo e(Asset('assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css')); ?>" />
<link rel="stylesheet" href="<?php echo e(Asset('assets/vendor/libs/form-validation/form-validation.css')); ?>" />
<link rel="stylesheet" href="<?php echo e(Asset('assets/vendor/css/pages/page-auth.css')); ?>" />    
</head>

<body>



<div class="container-xxl">
<div class="authentication-wrapper authentication-basic container-p-y">
<div class="authentication-inner py-6">
<div class="card">
<div class="card-body">
<div class="app-brand justify-content-center mb-6">
<a href="<?php echo e(Asset('login')); ?>" class="app-brand-link">
<span class="app-brand-logo demo">
<span class="text-primary">
<img src="<?php echo e(Asset('assets/img/favicon.png')); ?>" style="width: 80px;">
</svg>
</span>
</span>
</a>
</div>
<h4 class="mb-1">Welcome to Admin Panel</h4>
<p class="mb-6">Please sign-in to your account and start the adventure</p>

<form id="formAuthentication" class="mb-4" action="<?php echo e(Asset('login')); ?>" method="post">

<?php echo csrf_field(); ?>


<?php if(Session::has('message')): ?>
<div class="alert alert-success mt-1 alert-validation-msg" role="alert">
<i class="feather icon-check-circle mr-1 align-middle"></i>
<span><?php echo e(Session::get('message')); ?></span>
</div>
<?php endif; ?>

<?php if(Session::has('error')): ?>
<div class="alert alert-danger mt-1 alert-validation-msg" role="alert">
<i class="feather icon-info mr-1 align-middle"></i>
<span><?php echo e(Session::get('error')); ?></span>
</div>
<?php endif; ?>

<div class="mb-6 form-control-validation">
<label for="email" class="form-label">Username</label>
<input type="text" class="form-control" id="email" name="username" placeholder="Enter your username" autofocus required/>
</div>
<div class="mb-6 form-password-toggle form-control-validation">
<label class="form-label" for="password">Password</label>
<div class="input-group input-group-merge">
<input type="password" id="password" class="form-control" name="password" aria-describedby="password" required />
<span class="input-group-text cursor-pointer" onclick="changePass()"><i class="icon-base ti tabler-eye-off"></i></span>
</div>
</div>
<div class="my-8">
<div class="d-flex justify-content-between">
<div class="form-check mb-0 ms-2">
<input class="form-check-input" type="checkbox" id="remember-me" />
<label class="form-check-label" for="remember-me"> Remember Me </label>
</div>

</div>
</div>
<div class="mb-6">
<button class="btn btn-primary d-grid w-100" type="submit">Login</button>
</div>
</form>



</div>
</div>
</div>
</div>
</div>

<script>
function changePass()
{
var pass = document.getElementById("password");

pass.type = pass.type == "text" ? "password" : "text";
}
</script>


</body>

</html>


<?php /**PATH /Applications/XAMPP/xamppfiles/htdocs/new_pos/local/resources/views/index.blade.php ENDPATH**/ ?>