import { Component, OnInit,ViewChild,ElementRef } from '@angular/core';
import { ServerService } from '../service/server.service';
import { NavController,Platform,LoadingController,IonSlides,AlertController,ToastController } from '@ionic/angular';
import { ActivatedRoute } from '@angular/router';
import { Geolocation } from '@ionic-native/geolocation/ngx';
declare var google;

@Component({
  selector: 'app-home',
  templateUrl: 'home.page.html',
  styleUrls: ['home.page.scss'],
})
export class HomePage {
@ViewChild('map',{static:false}) mapElement: ElementRef;
  
  data:any;
  text:any;
intr:any;
userData:any;
online = false;
type:any = 0;
title:any;
map: any;
markers:any;


  constructor(public geolocation: Geolocation,private activatedRoute: ActivatedRoute,public toastController: ToastController,public alertController: AlertController,public server : ServerService,private nav: NavController,public loadingController : LoadingController,public platform : Platform)
  {
    this.userData = JSON.parse(localStorage.getItem('user_data'));
    this.type     = this.activatedRoute.snapshot.paramMap.get('type');
    this.title    = this.type == 0 ? "New Orders" : "Pre Orders";
  }

  ionViewWillEnter()
  {
    if(localStorage.getItem('app_text') && localStorage.getItem('app_text') != undefined)
    {
      this.text = JSON.parse(localStorage.getItem('app_text'));
    }

    this.loadData();
  }

  ngOnInit()
  {
    
  }

  async loadData()
  {
    const loading = await this.loadingController.create({
      spinner: 'bubbles',
    });
    await loading.present();

    this.server.homepage(localStorage.getItem('user_id'),3,this.type).subscribe((response:any) => {
    this.data = response.data;
    this.markers = response.location;
    this.text = response.text;
    this.online = response.dboy.online == 1 ? true : false;
    localStorage.setItem('app_text', JSON.stringify(response.text));

    if(response.data.length == 0)
    {
       this.platform.ready().then(() => {

      this.loadMap();

      });
    }

    loading.dismiss();

    });
  }

  async loadMap() {
    
    var gmarkers = [[31.3212962,75.5831602],[31.30740,75.58371]];

    this.geolocation.getCurrentPosition().then((resp) => {
      
      let latLng = new google.maps.LatLng(resp.coords.latitude, resp.coords.longitude);
      let mapOptions = {
        center: latLng,
        zoom: 16,
        mapTypeId: google.maps.MapTypeId.ROADMAP,
        mapTypeControl: false,
      }
    
      this.map = new google.maps.Map(this.mapElement.nativeElement, mapOptions);
      
      this.map.addListener('tilesloaded', () => {
        
      });

      const styles =  this.map.MapTypeStyle = {
      default: [],
      hide: [
        {
          featureType: "poi.business",
          stylers: [{ visibility: "off" }],
        },
        {
          featureType: "transit",
          elementType: "labels.icon",
          stylers: [{ visibility: "off" }],
        },
      ],
    };

    this.map.setOptions({ styles: styles["hide"] });

  
  for(var i =0;i<this.markers.length;i++)
  {
     const icon = {
      url: 'assets/app.png',
       scaledSize: new google.maps.Size(30, 30), 
      };

      const pos = {
        lat: parseFloat(this.markers[i][0]),
        lng: parseFloat(this.markers[i][1])
      };

      const marker = new google.maps.Marker({
      position: pos, //marker position
      map: this.map, //map already created
      title: 'Hello World!',
      icon: icon //custom image
      });

      marker.addListener('click', function() {
      this.map.infowindow.open(this.map, marker);
    });
  }
 
    }).catch((error) => {
      console.log('Error getting location', error);
    });
  }

  async presentToast(txt) {
    const toast = await this.toastController.create({
      message: txt,
      duration: 3000,
      position : 'top',
      mode:'ios',
      color:'dark'
    });
    toast.present();
  }

  detail(odata)
  {
    
    localStorage.setItem('odata', JSON.stringify(odata));
    
    this.nav.navigateForward('/detail');
  }

  doRefresh(event) {
    console.log('Begin async operation');

    setTimeout(() => {
      this.loadData();
      event.target.complete();
    }, 1000);
  }

  setStatus(s)
  {
    var online = this.online == true ? 1 : 0;

    this.server.setStatus(localStorage.getItem('user_id'),online).subscribe((response:any) => {

    });
  }

  async accept(odata)
  {
    const loading = await this.loadingController.create({
      spinner: 'bubbles',
    });
    await loading.present();

    this.server.accept(localStorage.getItem('user_id'),odata.id).subscribe((response:any) => {
    
    if(response.data != "error")
    {
      this.data = response.data; 
    }
    else
    {
      this.presentToast("Opps! this order is already assigned to somebody else.");
      this.loadData();
    }

    loading.dismiss();

    });
  }

  async declineAlert(id) {
    const alert = await this.alertController.create({
      header: this.text.d_confirm,
      message: this.text.cancel_order_confirm,
      buttons: [
        {
          text: 'Cancel',
          role: 'cancel',
          cssClass: 'secondary',
          handler: (blah) => {
            console.log('Confirm Cancel: blah');
          }
        }, {
          text: 'Yes',
          handler: () => {
            
            this.decline(id);

          }
        }
      ]
    });

    await alert.present();
  }

  async decline(id)
  {
    const loading = await this.loadingController.create({
      spinner: 'bubbles',
    });
    await loading.present();

    this.server.decline(id,localStorage.getItem('user_id')).subscribe((response:any) => {
    
    this.data = response.data;

    this.presentToast("Order declined successfully");

    loading.dismiss();

    });
  }
}
