(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["plan-plan-module"],{

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/plan/plan.page.html":
/*!***************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/plan/plan.page.html ***!
  \***************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<ion-content class=\"ion-padding\" *ngIf=\"text && data\" #content>\n\n<ion-icon name=\"arrow-back-outline\" style=\"font-size: 26px\" routerLink=\"/home\" routerDirection=\"backword\"></ion-icon>\n\n<br><br><br>\n\n<h1 align=\"center\">{{ text.my_plan }}</h1>\n<p align=\"center\">{{ text.my_plan_text }}</p>\n<br>\n\n<ion-row class=\"activeCard plan\">\n\n<ion-col size=\"12\"><b>{{ data.my.name }} <span style=\"float: right\">{{ data.my.price }}</span></b></ion-col>\n\n<ion-col size=\"12\"><b style=\"color:black\">{{ text.valid_till }} : {{ data.my.valid }}</b></ion-col>\n\n<ion-col size=\"12\" style=\"font-size: 12px\">{{ data.my.desc }}</ion-col>\n\n<ion-col size=\"12\" style=\"font-size: 12px\">\n\n<p *ngFor=\"let fet of data.my.feat\"><ion-icon name=\"checkmark-outline\"></ion-icon> {{ fet }}</p>\n\n</ion-col>\n</ion-row>\n\n<p style=\"margin-right: 10px;\" align=\"right\"><a (click)=\"showPlan()\">{{ text.change_plan }}</a></p>\n\n<form #form=\"ngForm\" (ngSubmit)=\"makeOrder(form.value)\" *ngIf=\"changePlan\">\n\n<br><h3>{{ text.change_plan }}</h3><br>\n\n<ion-row *ngFor=\"let plan of data.plan\" class=\"plan\" (click)=\"selectPlan(plan)\" [class]=\"plan.id == plan_id ? 'activeCard' : 'non'\">\n\n<ion-col size=\"12\"><b>{{ plan.name }} <ion-chip style=\"float: right\" color=\"primary\">{{ plan.currency }}{{ plan.price }}</ion-chip></b></ion-col>\n\n<ion-col size=\"12\" style=\"font-size: 12px\">{{ plan.desc }}</ion-col>\n\n<ion-col size=\"12\" style=\"font-size: 12px\">\n<p><ion-icon name=\"checkmark-outline\"></ion-icon> {{ text.time_period }} : {{ plan.time }}</p>\n<p *ngFor=\"let fet of plan.feat\"><ion-icon name=\"checkmark-outline\"></ion-icon> {{ fet }}</p>\n\n</ion-col>\n\n</ion-row>\n\n<h3>{{ text.select_plan }}</h3>\n\n<ion-card mode=\"ios\" (click)=\"setPayment(2)\" [class]=\"payment == 2 ? 'activeCard' : 'non'\" *ngIf=\"data.setting.stripe_key\">\n\n<ion-card-header>\n<ion-card-subtitle [class]=\"payment == 2 ? 'activeHeader' : 'non'\">{{ text.stripe }} <ion-icon [name]=\"payment == 2 ? 'card' : 'card-outline'\" class=\"paymentIcon\"></ion-icon></ion-card-subtitle>\n</ion-card-header>\n\n</ion-card>\n\n\n<ion-card mode=\"ios\" (click)=\"setPayment(4)\" [class]=\"payment == 4 ? 'activeCard' : 'non'\" *ngIf=\"data.setting.razor_key\">\n\n<ion-card-header>\n<ion-card-subtitle [class]=\"payment == 4 ? 'activeHeader' : 'non'\">{{ text.razor }} <ion-icon [name]=\"payment == 4 ? 'wallet' : 'wallet-outline'\" class=\"paymentIcon\"></ion-icon></ion-card-subtitle>\n</ion-card-header>\n\n</ion-card>\n\n<div *ngIf=\"stripeView\">\n\n<p style=\"margin-top: 15%\">{{ text.stripe_title }}</p>\n<ion-row>\n\n<ion-col size=\"12\">\n<ion-item>\n  <ion-label position=\"floating\">{{ text.card_no }}</ion-label>\n  <ion-input type=\"tel\" [(ngModel)]=\"card_no\" name=\"card_no\"></ion-input>\n</ion-item>\n</ion-col>\n\n<ion-col size=\"6\">\n<ion-item>\n  <ion-label position=\"floating\">{{ text.exp_month }}</ion-label>\n  <ion-input type=\"tel\" [(ngModel)]=\"exp_month\" name=\"exp_month\"></ion-input>\n</ion-item>\n</ion-col>\n\n<ion-col size=\"6\">\n<ion-item>\n  <ion-label position=\"floating\">{{ text.exp_year }}</ion-label>\n  <ion-input type=\"tel\" [(ngModel)]=\"exp_year\" name=\"exp_year\"></ion-input>\n</ion-item>\n</ion-col>\n\n<ion-col size=\"6\">\n<ion-item>\n  <ion-label position=\"floating\">{{ text.cvv }}</ion-label>\n  <ion-input type=\"tel\" [(ngModel)]=\"cvv\" name=\"cvv\"></ion-input>\n</ion-item>\n</ion-col>\n</ion-row>\n</div>\n\n<br>\n<ion-button expand=\"block\" mode=\"ios\" type=\"submit\" [disabled]=\"!payment || !plan_id\">{{ text.submit_btn }}</ion-button>\n\n</form>\n\n</ion-content>\n");

/***/ }),

/***/ "./src/app/plan/plan-routing.module.ts":
/*!*********************************************!*\
  !*** ./src/app/plan/plan-routing.module.ts ***!
  \*********************************************/
/*! exports provided: PlanPageRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PlanPageRoutingModule", function() { return PlanPageRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/__ivy_ngcc__/fesm2015/router.js");
/* harmony import */ var _plan_page__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./plan.page */ "./src/app/plan/plan.page.ts");




const routes = [
    {
        path: '',
        component: _plan_page__WEBPACK_IMPORTED_MODULE_3__["PlanPage"]
    }
];
let PlanPageRoutingModule = class PlanPageRoutingModule {
};
PlanPageRoutingModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]],
    })
], PlanPageRoutingModule);



/***/ }),

/***/ "./src/app/plan/plan.module.ts":
/*!*************************************!*\
  !*** ./src/app/plan/plan.module.ts ***!
  \*************************************/
/*! exports provided: PlanPageModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PlanPageModule", function() { return PlanPageModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/__ivy_ngcc__/fesm2015/common.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/__ivy_ngcc__/fesm2015/forms.js");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ "./node_modules/@ionic/angular/__ivy_ngcc__/fesm2015/ionic-angular.js");
/* harmony import */ var _plan_routing_module__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./plan-routing.module */ "./src/app/plan/plan-routing.module.ts");
/* harmony import */ var _plan_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./plan.page */ "./src/app/plan/plan.page.ts");







let PlanPageModule = class PlanPageModule {
};
PlanPageModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_2__["CommonModule"],
            _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormsModule"],
            _ionic_angular__WEBPACK_IMPORTED_MODULE_4__["IonicModule"],
            _plan_routing_module__WEBPACK_IMPORTED_MODULE_5__["PlanPageRoutingModule"]
        ],
        declarations: [_plan_page__WEBPACK_IMPORTED_MODULE_6__["PlanPage"]]
    })
], PlanPageModule);



/***/ }),

/***/ "./src/app/plan/plan.page.scss":
/*!*************************************!*\
  !*** ./src/app/plan/plan.page.scss ***!
  \*************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (".paymentIcon {\n  float: right;\n  font-size: 28px;\n  margin-top: -3%;\n}\n\n.activeCard {\n  background-color: var(--ion-color-primary);\n  color: white;\n}\n\n.activeHeader {\n  color: white;\n}\n\n.plan {\n  border: 1px solid #e3e3e3;\n  padding: 10px 10px;\n  margin-bottom: 5%;\n  border-radius: 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvcGxhbi9wbGFuLnBhZ2Uuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUVDLFlBQUE7RUFBYSxlQUFBO0VBQWdCLGVBQUE7QUFFOUI7O0FBQ0E7RUFFQywwQ0FBQTtFQUNBLFlBQUE7QUFDRDs7QUFPQTtFQUVDLFlBQUE7QUFMRDs7QUFRQTtFQUVDLHlCQUFBO0VBQ0Esa0JBQUE7RUFDQSxpQkFBQTtFQUNBLG1CQUFBO0FBTkQiLCJmaWxlIjoic3JjL2FwcC9wbGFuL3BsYW4ucGFnZS5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLnBheW1lbnRJY29uXG57XG5cdGZsb2F0OiByaWdodDtmb250LXNpemU6IDI4cHg7bWFyZ2luLXRvcDogLTMlO1xufVxuXG4uYWN0aXZlQ2FyZFxue1xuXHRiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1pb24tY29sb3ItcHJpbWFyeSk7XG5cdGNvbG9yOndoaXRlO1xufVxuXG4ubm9uXG57XG5cdFxufVxuXG4uYWN0aXZlSGVhZGVyXG57XG5cdGNvbG9yOndoaXRlO1xufVxuXG4ucGxhblxue1xuXHRib3JkZXI6MXB4IHNvbGlkICNlM2UzZTM7XG5cdHBhZGRpbmc6MTBweCAxMHB4O1xuXHRtYXJnaW4tYm90dG9tOjUlO1xuXHRib3JkZXItcmFkaXVzOiAxMHB4O1xufSJdfQ== */");

/***/ }),

/***/ "./src/app/plan/plan.page.ts":
/*!***********************************!*\
  !*** ./src/app/plan/plan.page.ts ***!
  \***********************************/
/*! exports provided: PlanPage */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PlanPage", function() { return PlanPage; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/__ivy_ngcc__/fesm2015/router.js");
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../service/server.service */ "./src/app/service/server.service.ts");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ "./node_modules/@ionic/angular/__ivy_ngcc__/fesm2015/ionic-angular.js");
/* harmony import */ var _ionic_native_stripe_ngx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic-native/stripe/ngx */ "./node_modules/@ionic-native/stripe/__ivy_ngcc__/ngx/index.js");






let PlanPage = class PlanPage {
    constructor(route, server, toastController, nav, loadingController, stripe) {
        this.route = route;
        this.server = server;
        this.toastController = toastController;
        this.nav = nav;
        this.loadingController = loadingController;
        this.stripe = stripe;
        this.stripeView = false;
        this.changePlan = false;
        this.text = JSON.parse(localStorage.getItem('app_text'));
    }
    ngOnInit() {
        this.loadData();
    }
    showPlan() {
        this.changePlan = this.changePlan == true ? false : true;
    }
    selectPlan(plan) {
        this.plan_id = plan.id;
        this.amount = plan.price;
    }
    setPayment(id) {
        this.payment = id;
        setTimeout(() => {
            this.content.scrollToBottom(300);
        }, 100);
        if (id == 2) {
            this.stripeView = true;
        }
        else {
            this.stripeView = false;
        }
    }
    loadData() {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                message: '',
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.myPlan().subscribe((response) => {
                this.data = response.data;
                loading.dismiss();
            });
        });
    }
    signup(data) {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                message: '',
                spinner: 'bubbles',
                duration: 3000
            });
            yield loading.present();
            var allData = {
                payment_id: this.payment_id,
                payment_method: this.payment,
                plan_id: this.plan_id,
                user_id: localStorage.getItem('user_id')
            };
            console.log(allData);
            this.server.renew(allData).subscribe((response) => {
                this.presentToast("Success! Your plan has been changed successfully.");
                this.nav.navigateRoot('/home');
                loading.dismiss();
            });
        });
    }
    presentToast(txt) {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            const toast = yield this.toastController.create({
                message: txt,
                duration: 3000,
                position: 'top',
                mode: 'ios',
                color: 'dark'
            });
            toast.present();
        });
    }
    makeOrder(formData) {
        if (this.payment == 2) {
            this.payWithStripe(formData);
        }
        else if (this.payment == 4) {
            this.payWithRazor(formData);
        }
    }
    payWithStripe(formData) {
        var cNo = this.card_no;
        if (cNo && cNo.length == 16 && this.exp_month.length == 2 && this.exp_year.length == 4 && this.cvv.length == 3) {
            this.stripe.setPublishableKey(this.data.setting.stripe_key);
            let card = {
                number: cNo,
                expMonth: this.exp_month,
                expYear: this.exp_year,
                cvc: this.cvv
            };
            var cardNo = false;
            var cvvCorrect = false;
            //validate card no
            this.stripe.validateCardNumber(cNo)
                .then(res => {
                this.stripe.createCardToken(card)
                    .then(token => {
                    if (token.id) {
                        this.makePayment(token.id, cNo, formData);
                    }
                    else {
                        this.presentToast(this.text.card_no_validation);
                    }
                })
                    .catch(error => {
                    this.presentToast(this.text.stripe_config);
                });
            })
                .catch(error => {
                this.presentToast(this.text.card_no_validation);
            });
        }
        else {
            this.presentToast(this.text.stripe_validation);
        }
    }
    makePayment(token, cNo, formData) {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.makeStripePayment("?token=" + token + "&amount=" + this.amount).subscribe((response) => {
                if (response.data == "done") {
                    this.payment_id = response.id;
                    if (this.payment_id) {
                        this.signup(formData);
                    }
                }
                else {
                    this.presentToast(response.error);
                }
                loading.dismiss();
            });
        });
    }
    payWithRazor(formData) {
        var options = {
            description: 'Pay Now',
            image: 'https://cdn.iconscout.com/icon/free/png-512/bhim-3-69845.png',
            currency: this.data.setting.currency_code,
            key: this.data.setting.razor_key,
            amount: this.amount * 100,
            name: 'Signup Your Store',
            prefill: {
                email: "signup@google.com",
                contact: formData.phone,
                name: formData.name
            },
            theme: {
                color: '#2196f3'
            },
            modal: {
                ondismiss: function () {
                    alert('dismissed');
                }
            }
        };
        var successCallback = (success) => {
            this.payment_id = success;
            if (this.payment_id) {
                this.signup(formData);
            }
        };
        var cancelCallback = function (error) {
            alert(error.description + ' (Error ' + error.code + ')');
        };
        RazorpayCheckout.open(options, successCallback, cancelCallback);
    }
};
PlanPage.ctorParameters = () => [
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_2__["ActivatedRoute"] },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_3__["ServerService"] },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__["ToastController"] },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__["NavController"] },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__["LoadingController"] },
    { type: _ionic_native_stripe_ngx__WEBPACK_IMPORTED_MODULE_5__["Stripe"] }
];
PlanPage.propDecorators = {
    content: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"], args: ['content', { static: false },] }]
};
PlanPage = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
        selector: 'app-plan',
        template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./plan.page.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/plan/plan.page.html")).default,
        styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./plan.page.scss */ "./src/app/plan/plan.page.scss")).default]
    })
], PlanPage);



/***/ })

}]);
//# sourceMappingURL=plan-plan-module-es2015.js.map