"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_address_address_module_ts"],{

/***/ 96060:
/*!***************************************************!*\
  !*** ./src/app/address/address-routing.module.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddressPageRoutingModule": () => (/* binding */ AddressPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _address_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./address.page */ 78206);




const routes = [
    {
        path: '',
        component: _address_page__WEBPACK_IMPORTED_MODULE_0__.AddressPage
    }
];
let AddressPageRoutingModule = class AddressPageRoutingModule {
};
AddressPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], AddressPageRoutingModule);



/***/ }),

/***/ 83384:
/*!*******************************************!*\
  !*** ./src/app/address/address.module.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddressPageModule": () => (/* binding */ AddressPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _address_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./address-routing.module */ 96060);
/* harmony import */ var _address_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./address.page */ 78206);







let AddressPageModule = class AddressPageModule {
};
AddressPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _address_routing_module__WEBPACK_IMPORTED_MODULE_0__.AddressPageRoutingModule
        ],
        declarations: [_address_page__WEBPACK_IMPORTED_MODULE_1__.AddressPage]
    })
], AddressPageModule);



/***/ }),

/***/ 78206:
/*!*****************************************!*\
  !*** ./src/app/address/address.page.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AddressPage": () => (/* binding */ AddressPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _address_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./address.page.html?ngResource */ 77468);
/* harmony import */ var _address_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./address.page.scss?ngResource */ 2524);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _awesome_cordova_plugins_native_geocoder_ngx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @awesome-cordova-plugins/native-geocoder/ngx */ 79683);
/* harmony import */ var _awesome_cordova_plugins_geolocation_ngx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @awesome-cordova-plugins/geolocation/ngx */ 36457);









let AddressPage = class AddressPage {
    constructor(route, server, toastController, nav, loadingController, geolocation, nativeGeocoder, platform, zone) {
        this.route = route;
        this.server = server;
        this.toastController = toastController;
        this.nav = nav;
        this.loadingController = loadingController;
        this.geolocation = geolocation;
        this.nativeGeocoder = nativeGeocoder;
        this.platform = platform;
        this.zone = zone;
        this.text = JSON.parse(localStorage.getItem('app_text'));
        this.type = this.route.snapshot.paramMap.get('id');
        this.GoogleAutocomplete = new google.maps.places.AutocompleteService();
        this.autocomplete = { input: '' };
        this.autocompleteItems = [];
    }
    ngOnInit() {
    }
    ionViewWillEnter() {
        this.platform.ready().then(() => {
            this.loadMap();
        });
    }
    loadMap() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            console.log("hey");
            this.geolocation.getCurrentPosition().then((resp) => {
                let latLng = new google.maps.LatLng(resp.coords.latitude, resp.coords.longitude);
                let mapOptions = {
                    center: latLng,
                    zoom: 16,
                    mapTypeId: google.maps.MapTypeId.ROADMAP
                };
                this.getAddressFromCoords(resp.coords.latitude, resp.coords.longitude);
                this.map = new google.maps.Map(this.mapElement.nativeElement, mapOptions);
                this.map.addListener('tilesloaded', () => {
                    this.getAddressFromCoords(this.map.center.lat(), this.map.center.lng());
                });
            }).catch((error) => {
                console.log('Error getting location', error);
            });
        });
    }
    getAddressFromCoords(lattitude, longitude) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            console.log("getAddressFromCoords " + lattitude + " " + longitude);
            let options = {
                useLocale: true,
                maxResults: 5
            };
            this.nativeGeocoder.reverseGeocode(lattitude, longitude, options)
                .then((result) => {
                this.address = "";
                let responseAddress = [];
                for (let [key, value] of Object.entries(result[0])) {
                    if (value.length > 0)
                        responseAddress.push(value);
                }
                responseAddress.reverse();
                for (let value of responseAddress) {
                    this.address += value + ", ";
                }
                this.address = this.address.slice(0, -2);
            })
                .catch((error) => {
            });
        });
    }
    saveAddress(data) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                message: '',
                spinner: 'bubbles'
            });
            yield loading.present();
            var allData = { user_id: localStorage.getItem('user_id'), lat: this.map.center.lat(), lng: this.map.center.lng(), address: data.address, landmark: data.landmark };
            this.server.saveAddress(allData).subscribe((response) => {
                this.nav.navigateBack('/checkout');
                loading.dismiss();
            });
        });
    }
    presentToast(txt) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            const toast = yield this.toastController.create({
                message: txt,
                duration: 3000,
                position: 'top',
                mode: 'ios',
                color: 'dark'
            });
            toast.present();
        });
    }
    //AUTOCOMPLETE, SIMPLY LOAD THE PLACE USING GOOGLE PREDICTIONS AND RETURNING THE ARRAY.
    UpdateSearchResults() {
        if (this.autocomplete.input == '') {
            this.autocompleteItems = [];
            return;
        }
        this.GoogleAutocomplete.getPlacePredictions({ input: this.autocomplete.input }, (predictions, status) => {
            this.autocompleteItems = [];
            this.zone.run(() => {
                predictions.forEach((prediction) => {
                    this.autocompleteItems.push(prediction);
                });
            });
        });
    }
    //wE CALL THIS FROM EACH ITEM.
    SelectSearchResult(item) {
        ///WE CAN CONFIGURE MORE COMPLEX FUNCTIONS SUCH AS UPLOAD DATA TO FIRESTORE OR LINK IT TO SOMETHING
        const geocoder = new google.maps.Geocoder();
        const infowindow = new google.maps.InfoWindow();
        this.placeid = item.place_id;
        this.geocodePlaceId(geocoder, this.map, infowindow);
        this.ClearAutocomplete();
    }
    geocodePlaceId(geocoder, map, infowindow) {
        geocoder.geocode({
            placeId: this.placeid
        }, (results, status) => {
            if (status === "OK") {
                if (results[0]) {
                    this.map.setZoom(16);
                    this.map.setCenter(results[0].geometry.location);
                }
                else {
                    window.alert("No results found");
                }
            }
            else {
                window.alert("Geocoder failed due to: " + status);
            }
        });
    }
    //lET'S BE CLEAN! THIS WILL JUST CLEAN THE LIST WHEN WE CLOSE THE SEARCH BAR.
    ClearAutocomplete() {
        this.autocompleteItems = [];
        this.autocomplete.input = '';
    }
};
AddressPage.ctorParameters = () => [
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_6__.ActivatedRoute },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.LoadingController },
    { type: _awesome_cordova_plugins_geolocation_ngx__WEBPACK_IMPORTED_MODULE_4__.Geolocation },
    { type: _awesome_cordova_plugins_native_geocoder_ngx__WEBPACK_IMPORTED_MODULE_3__.NativeGeocoder },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.Platform },
    { type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.NgZone }
];
AddressPage.propDecorators = {
    mapElement: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.ViewChild, args: ['map', { static: false },] }]
};
AddressPage = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Component)({
        selector: 'app-address',
        template: _address_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_address_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], AddressPage);



/***/ }),

/***/ 2524:
/*!******************************************************!*\
  !*** ./src/app/address/address.page.scss?ngResource ***!
  \******************************************************/
/***/ ((module) => {

module.exports = "#map_canvas {\n  width: 90%;\n  height: 60%;\n  border: 1px solid red;\n}\n\n#address {\n  padding: 10px;\n  font-size: 18px;\n  font-weight: bold;\n}\n\n#map {\n  width: 100%;\n  height: 40vh;\n}\n\n.map-wrapper {\n  position: relative;\n}\n\n.map-wrapper #map_center {\n  position: absolute;\n  z-index: 99;\n  height: 40px;\n  width: 40px;\n  top: 50%;\n  left: 50%;\n  margin-left: -21px;\n  margin-top: -41px;\n}\n\nion-content {\n  --background:#efeff4 ;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFkZHJlc3MucGFnZS5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBQ0UsVUFBQTtFQUNBLFdBQUE7RUFDQSxxQkFBQTtBQUNGOztBQUdBO0VBQ0UsYUFBQTtFQUNBLGVBQUE7RUFDQSxpQkFBQTtBQUFGOztBQUdBO0VBQ0UsV0FBQTtFQUNBLFlBQUE7QUFBRjs7QUFHQTtFQUNFLGtCQUFBO0FBQUY7O0FBRUU7RUFDRSxrQkFBQTtFQUNBLFdBQUE7RUFDQSxZQUFBO0VBQ0EsV0FBQTtFQUNBLFFBQUE7RUFDQSxTQUFBO0VBQ0Esa0JBQUE7RUFDQSxpQkFBQTtBQUFKOztBQUlBO0VBRUUscUJBQUE7QUFGRiIsImZpbGUiOiJhZGRyZXNzLnBhZ2Uuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbIiNtYXBfY2FudmFzIHtcbiAgd2lkdGg6IDkwJTtcbiAgaGVpZ2h0OiA2MCU7XG4gIGJvcmRlcjogMXB4IHNvbGlkIHJlZDtcbn1cbiBcbiBcbiNhZGRyZXNzIHtcbiAgcGFkZGluZzogMTBweDtcbiAgZm9udC1zaXplOiAxOHB4O1xuICBmb250LXdlaWdodDogYm9sZDtcbn1cbiBcbiNtYXAge1xuICB3aWR0aDogMTAwJTtcbiAgaGVpZ2h0OiA0MHZoO1xufVxuIFxuLm1hcC13cmFwcGVyIHtcbiAgcG9zaXRpb246IHJlbGF0aXZlO1xuIFxuICAjbWFwX2NlbnRlciB7XG4gICAgcG9zaXRpb246IGFic29sdXRlO1xuICAgIHotaW5kZXg6IDk5O1xuICAgIGhlaWdodDogNDBweDtcbiAgICB3aWR0aDogNDBweDtcbiAgICB0b3A6IDUwJTtcbiAgICBsZWZ0OiA1MCU7XG4gICAgbWFyZ2luLWxlZnQ6IC0yMXB4O1xuICAgIG1hcmdpbi10b3A6IC00MXB4O1xuICB9XG59XG5cbmlvbi1jb250ZW50XG57XG4gIC0tYmFja2dyb3VuZDojZWZlZmY0XG59Il19 */";

/***/ }),

/***/ 77468:
/*!******************************************************!*\
  !*** ./src/app/address/address.page.html?ngResource ***!
  \******************************************************/
/***/ ((module) => {

module.exports = "<ion-header class=\"ion-no-border\">\n<ion-toolbar color=\"light\">\n<ion-buttons slot=\"start\">\n<ion-back-button></ion-back-button>\n</ion-buttons>\n<ion-title>Add New Address</ion-title>\n</ion-toolbar>\n</ion-header>\n \n<ion-content *ngIf=\"text\">\n\n<ion-searchbar [(ngModel)]=\"autocomplete.input\" (ionInput)=\"UpdateSearchResults()\" placeholder=\"Search for a place\"  (ionClear)=\"ClearAutocomplete()\" mode=\"ios\"></ion-searchbar>\n\n<ion-list [hidden]=\"autocompleteItems.length == 0\">\n    <ion-item *ngFor=\"let item of autocompleteItems\" tappable (click)=\"SelectSearchResult(item)\">\n      {{ item.description }}\n    </ion-item>\n  </ion-list>\n\n<div class=\"map-wrapper\">\n<div id=\"map_center\">\n<ion-icon name=\"pin\" color=\"primary\" style=\"font-size: 30px;\"></ion-icon>\n</div>\n<div #map id=\"map\"></div>\n</div>\n\n<form #form=\"ngForm\" (ngSubmit)=\"saveAddress(form.value)\" class=\"ion-padding\">\n\n<ion-item lines=\"none\">\n  <ion-label position=\"floating\">Address</ion-label>\n  <ion-textarea [(ngModel)]=\"address\" name=\"address\" required></ion-textarea>\n</ion-item>\n\n<ion-item lines=\"none\">\n  <ion-label position=\"floating\">Any Near Landmark</ion-label>\n  <ion-input [(ngModel)]=\"landmark\" name=\"landmark\"></ion-input>\n</ion-item>\n\n<ion-button expand=\"block\" mode=\"ios\" type=\"submit\" [disabled]=\"!form.valid\">Save</ion-button>\n</form>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_address_address_module_ts.js.map