"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_cart_cart_module_ts"],{

/***/ 63951:
/*!*********************************************!*\
  !*** ./src/app/cart/cart-routing.module.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CartPageRoutingModule": () => (/* binding */ CartPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _cart_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cart.page */ 34612);




const routes = [
    {
        path: '',
        component: _cart_page__WEBPACK_IMPORTED_MODULE_0__.CartPage
    }
];
let CartPageRoutingModule = class CartPageRoutingModule {
};
CartPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], CartPageRoutingModule);



/***/ }),

/***/ 12943:
/*!*************************************!*\
  !*** ./src/app/cart/cart.module.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CartPageModule": () => (/* binding */ CartPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _cart_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cart-routing.module */ 63951);
/* harmony import */ var _cart_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./cart.page */ 34612);







let CartPageModule = class CartPageModule {
};
CartPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _cart_routing_module__WEBPACK_IMPORTED_MODULE_0__.CartPageRoutingModule
        ],
        declarations: [_cart_page__WEBPACK_IMPORTED_MODULE_1__.CartPage]
    })
], CartPageModule);



/***/ }),

/***/ 34612:
/*!***********************************!*\
  !*** ./src/app/cart/cart.page.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CartPage": () => (/* binding */ CartPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _cart_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cart.page.html?ngResource */ 73098);
/* harmony import */ var _cart_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./cart.page.scss?ngResource */ 63036);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _offer_offer_page__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../offer/offer.page */ 80370);
/* harmony import */ var _note_note_page__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../note/note.page */ 50700);








let CartPage = class CartPage {
    constructor(platform, modalController, loadingController, server, nav, toastController, alertController) {
        this.platform = platform;
        this.modalController = modalController;
        this.loadingController = loadingController;
        this.server = server;
        this.nav = nav;
        this.toastController = toastController;
        this.alertController = alertController;
        this.text = JSON.parse(localStorage.getItem('app_text'));
    }
    ngOnInit() {
    }
    ionViewWillLeave() {
        this.subscription.unsubscribe();
    }
    ionViewWillEnter() {
        this.loadData();
        this.subscription = this.platform.backButton.subscribe(() => {
            this.modalController.dismiss({ data: true });
        });
    }
    loadData() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                message: '',
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.getCart(localStorage.getItem('cart_no')).subscribe((response) => {
                this.data = response.data;
                console.log(this.data);
                if (this.data.open == false) {
                    this.presentToast(this.text.store_close);
                    this.nav.navigateRoot('/home');
                }
                loading.dismiss();
            });
        });
    }
    updateCart(id, type) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.updateCart(id, type + "?lid=" + localStorage.getItem('lid') + "&lat=" + localStorage.getItem('current_lat') + "&lng=" + localStorage.getItem('current_lng')).subscribe((response) => {
                this.data = response.data;
                loading.dismiss();
            });
        });
    }
    presentToast(txt) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            const toast = yield this.toastController.create({
                message: txt,
                duration: 3000,
                position: 'top',
                mode: 'ios',
                color: 'dark'
            });
            toast.present();
        });
    }
    coupen() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            const modal = yield this.modalController.create({
                component: _offer_offer_page__WEBPACK_IMPORTED_MODULE_3__.OfferPage,
                animated: true,
                mode: 'ios',
                cssClass: 'my-custom-modal-css',
                backdropDismiss: true,
                swipeToClose: true,
            });
            modal.onDidDismiss().then(data => {
                console.log(data.data.id);
                if (data.data.id) {
                    this.applyCoupen(data.data.id);
                }
            });
            return yield modal.present();
        });
    }
    applyCoupen(id) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.applyCoupen(id, localStorage.getItem('cart_no') + "?lid=" + localStorage.getItem('lid')).subscribe((response) => {
                if (response.msg == "done") {
                    this.data = response.data;
                }
                else {
                    this.presentToast(response.msg);
                }
                loading.dismiss();
            });
        });
    }
    removeOffer(id) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.removeOffer(id, localStorage.getItem('cart_no') + "?lid=" + localStorage.getItem('lid')).subscribe((response) => {
                this.data = response.data;
                loading.dismiss();
            });
        });
    }
    checkout() {
        if (localStorage.getItem('user_id') && localStorage.getItem('user_id') != "null") {
            localStorage.setItem('checkout_data', JSON.stringify(this.data));
            this.nav.navigateForward('/checkout');
        }
        else {
            this.nav.navigateForward('/login');
            this.presentToast("Please login for continue");
        }
    }
    writeNote() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            const modal = yield this.modalController.create({
                component: _note_note_page__WEBPACK_IMPORTED_MODULE_4__.NotePage,
                animated: true,
                mode: 'ios',
                cssClass: 'my-custom-modal-css',
                backdropDismiss: true,
                swipeToClose: true,
                breakpoints: [0, 0.3, 0.5, 0.5],
                initialBreakpoint: 0.3
            });
            modal.onDidDismiss().then(data => {
                if (data.data.notes) {
                    this.notes = data.data.notes;
                    localStorage.setItem("cooking_notes", this.notes);
                }
            });
            return yield modal.present();
        });
    }
    removeNotes() {
        this.notes = null;
        localStorage.removeItem("cooking_notes");
    }
};
CartPage.ctorParameters = () => [
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.Platform },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.ModalController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.LoadingController },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.AlertController }
];
CartPage = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.Component)({
        selector: 'app-cart',
        template: _cart_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_cart_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], CartPage);



/***/ }),

/***/ 63036:
/*!************************************************!*\
  !*** ./src/app/cart/cart.page.scss?ngResource ***!
  \************************************************/
/***/ ((module) => {

module.exports = "ion-content {\n  --background:var(--ion-color-light);\n}\n\nion-list {\n  border-radius: 10px;\n}\n\nion-item {\n  border-radius: 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNhcnQucGFnZS5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBRUUsbUNBQUE7QUFBRjs7QUFHQTtFQUVFLG1CQUFBO0FBREY7O0FBSUE7RUFFRSxtQkFBQTtBQUZGIiwiZmlsZSI6ImNhcnQucGFnZS5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiaW9uLWNvbnRlbnRcbntcbiAgLS1iYWNrZ3JvdW5kOnZhcigtLWlvbi1jb2xvci1saWdodCk7XG59XG5cbmlvbi1saXN0XG57XG4gIGJvcmRlci1yYWRpdXM6MTBweDtcbn1cblxuaW9uLWl0ZW1cbntcbiAgYm9yZGVyLXJhZGl1czoxMHB4O1xufSJdfQ== */";

/***/ }),

/***/ 73098:
/*!************************************************!*\
  !*** ./src/app/cart/cart.page.html?ngResource ***!
  \************************************************/
/***/ ((module) => {

module.exports = "<ion-header class=\"ion-no-border\">\n<ion-toolbar color=\"primary\">\n\n<ion-buttons slot=\"start\">\n<ion-back-button></ion-back-button>\n</ion-buttons>\n<ion-buttons slot=\"end\" *ngIf=\"text\"><ion-button fill=\"clear\" routerLink=\"/home\">{{ text.go_back }}</ion-button></ion-buttons>\n\n<ion-title *ngIf=\"text\">{{ text.cart_title }}</ion-title>\n\n</ion-toolbar>\n</ion-header>\n\n<ion-content *ngIf=\"data && text\">\n<!--Empty card-->\n<div *ngIf=\"data && data.data.length == 0\" class=\"ion-padding\">\n\t\n<img src=\"assets/e.png\">\n\n<p align=\"center\" style=\"color:gray\">{{ text.empty }}</p>\n\n</div>\n<!--empty card end-->\n\n<div *ngIf=\"data && data.data.length > 0\" style=\"background:#efeff4\" class=\"ion-padding\">\n\n<ion-row *ngFor=\"let item of data.data\" style=\"padding: 10px 10px;background: white;margin-bottom: 6px;border-radius: 10px;\">\n<ion-col size=\"5\"><img src=\"{{ item.img }}\" style=\"border-radius: 5px\" *ngIf=\"item.img\"></ion-col>\n<ion-col size=\"7\">\n\n<ion-row>\n<ion-col size=\"12\">{{ item.item }}\n<br><small>{{ text.cart_price }} : {{ data.currency }}{{ item.price }} | {{ text.cart_qty }} : {{ item.qty }} {{ item.qtyName }}</small>\n\n<span *ngIf=\"item.addon.length > 0\">\n\n<small *ngFor=\"let addon of item.addon\"><br>{{ addon.name }} - {{ data.currency }}{{ addon.price }}</small>\t\n\n</span>\n<br>\n<ion-icon name=\"remove-circle-outline\" style=\"font-size: 26px\" color=\"danger\" (click)=\"updateCart(item.id,0)\"></ion-icon>\n<ion-icon name=\"add-circle-outline\" style=\"font-size: 26px;margin-left: 15px;margin-top: 10px\" color=\"success\" (click)=\"updateCart(item.id,1)\"></ion-icon>\n</ion-col>\n</ion-row>\n\n</ion-col>\n</ion-row>\n\n<p style=\"font-size:15px;padding: 10px 10px;\" align=\"center\" (click)=\"writeNote()\">{{ text.cooking_notes }}</p>\n\n<p style=\"font-size:11px;border-top:1px dotted black;width:96%;margin:auto;padding: 0px 10px\" align=\"center\" *ngIf=\"notes\">{{ notes }} <a (click)=\"removeNotes()\" style=\"color:red;float: right;\">{{ text.clear }}</a></p>\n\n<ion-item *ngIf=\"data.discount == 0\" (click)=\"coupen()\" lines=\"none\" detail style=\"margin-top: 10px;\">\n  <ion-label>\n   {{ text.have_discount }}\n  </ion-label>\n  <ion-icon name=\"pricetags-outline\" slot=\"start\" color=\"primary\"></ion-icon>\n</ion-item>\n\n<ion-list style=\"margin-top: 10px;\">\n\n<ion-item lines=\"full\">\n  <ion-label style=\"font-size: 14px\">{{ text.sub_total }} <span style=\"float: right\">{{ data.currency }}{{ data.item_total }}</span></ion-label>\n</ion-item>\n\n<ion-item lines=\"full\" *ngIf=\"data.discount > 0\">\n  <ion-label style=\"font-size: 14px\">{{ text.discount }} <span style=\"float: right\">{{ data.currency }}{{ data.discount }}\n  <br>\n  <a (click)=\"removeOffer(data.hasOffer.id)\" style=\"float: right;font-size: 12px;color:red\">{{ text.remove }}</a>\n\n  </span></ion-label>\n</ion-item>\n\n<ion-item lines=\"full\" *ngIf=\"data.discount == 0 && data.hasOffer && data.hasOffer.id\">\n  <ion-label style=\"font-size: 14px\">{{ text.offer_applied }} ({{ data.hasOffer.code }}) \n  <br><small style=\"color:red\">{{ data.currency }}{{ data.hasOffer.amount }} {{ text.cashback_msg }}</small>\n\n <a (click)=\"removeOffer(data.hasOffer.id)\" style=\"float: right;font-size: 12px;color:red\">{{ text.remove }}</a>\n\n</ion-label>\n</ion-item>\n\n<ion-item lines=\"full\" *ngIf=\"data.tax_value > 0\">\n  <ion-label style=\"font-size: 14px\">{{ data.tax_name }} <span style=\"float: right\">{{ data.currency }}{{ data.tax_value }}</span></ion-label>\n</ion-item>\n\n\n\n<ion-item lines=\"full\" *ngIf=\"data.d_charges > 0\">\n  <ion-label style=\"font-size: 14px\">{{ text.d_charges }} <span style=\"float: right\">{{ data.currency }}{{ data.d_charges }}</span></ion-label>\n</ion-item>\n\n<ion-item lines=\"none\">\n  <ion-label style=\"font-size: 14px\">{{ text.total_payable }} <span style=\"float: right\">{{ data.currency }}{{ data.total }}</span></ion-label>\n</ion-item>\n</ion-list>\n</div>\n\n</ion-content>\n<ion-footer class=\"ion-no-border\">\n<ion-toolbar color=\"light\">\n<div class=\"ion-padding\" *ngIf=\"data && data.data.length > 0\">\n<ion-button mode=\"ios\" expand=\"block\" (click)=\"checkout()\">{{ text.checkout }}</ion-button>\n</div>\n\n<div class=\"ion-padding\" *ngIf=\"data && data.data.length == 0\">\n<ion-button mode=\"ios\" expand=\"block\" routerLink=\"/home\">{{ text.start_shopping }}</ion-button>\n</div>\n\n</ion-toolbar>\n</ion-footer>";

/***/ })

}]);
//# sourceMappingURL=src_app_cart_cart_module_ts.js.map