"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_forgot_forgot_module_ts"],{

/***/ 72057:
/*!*************************************************!*\
  !*** ./src/app/forgot/forgot-routing.module.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ForgotPageRoutingModule": () => (/* binding */ ForgotPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _forgot_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./forgot.page */ 36889);




const routes = [
    {
        path: '',
        component: _forgot_page__WEBPACK_IMPORTED_MODULE_0__.ForgotPage
    }
];
let ForgotPageRoutingModule = class ForgotPageRoutingModule {
};
ForgotPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], ForgotPageRoutingModule);



/***/ }),

/***/ 76938:
/*!*****************************************!*\
  !*** ./src/app/forgot/forgot.module.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ForgotPageModule": () => (/* binding */ ForgotPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _forgot_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./forgot-routing.module */ 72057);
/* harmony import */ var _forgot_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./forgot.page */ 36889);







let ForgotPageModule = class ForgotPageModule {
};
ForgotPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _forgot_routing_module__WEBPACK_IMPORTED_MODULE_0__.ForgotPageRoutingModule
        ],
        declarations: [_forgot_page__WEBPACK_IMPORTED_MODULE_1__.ForgotPage]
    })
], ForgotPageModule);



/***/ }),

/***/ 36889:
/*!***************************************!*\
  !*** ./src/app/forgot/forgot.page.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ForgotPage": () => (/* binding */ ForgotPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _forgot_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./forgot.page.html?ngResource */ 74640);
/* harmony import */ var _forgot_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./forgot.page.scss?ngResource */ 15096);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 93819);






let ForgotPage = class ForgotPage {
    constructor(server, toastController, nav, loadingController) {
        this.server = server;
        this.toastController = toastController;
        this.nav = nav;
        this.loadingController = loadingController;
        this.newPassword = false;
        this.text = JSON.parse(localStorage.getItem('app_text'));
    }
    ngOnInit() {
    }
    forgot(data, type = "new") {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.forgot(data).subscribe((response) => {
                if (response.msg == "error") {
                    this.presentToast(response.error);
                }
                else {
                    this.presentToast(this.text.otp_sent_msg);
                    this.user_id = response.user_id;
                    this.email = data.email;
                }
                loading.dismiss();
            });
        });
    }
    verify(data) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            if (data.otp.length == 0) {
                this.presentToast(this.text.otp_validation);
            }
            else {
                const loading = yield this.loadingController.create({
                    duration: 3000,
                    spinner: 'bubbles'
                });
                yield loading.present();
                var allData = { otp: data.otp, user_id: this.user_id };
                this.server.verify(allData).subscribe((response) => {
                    if (response.msg == "error") {
                        this.presentToast(response.error);
                    }
                    else {
                        this.user_id = response.user_id;
                        this.newPassword = true;
                    }
                    loading.dismiss();
                });
            }
        });
    }
    new_password(data) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            if (data.password.length == 0) {
                this.presentToast(this.text.new_pass_validation);
            }
            else if (data.password != data.new_password) {
                this.presentToast(this.text.confirm_pass_validation);
            }
            else {
                const loading = yield this.loadingController.create({
                    duration: 3000,
                    spinner: 'bubbles'
                });
                yield loading.present();
                var allData = { password: data.password, user_id: this.user_id };
                this.server.updatePassword(allData).subscribe((response) => {
                    if (response.msg == "error") {
                        this.presentToast(response.error);
                    }
                    else {
                        this.nav.navigateRoot('/login');
                        this.presentToast(this.text.password_update_msg);
                    }
                    loading.dismiss();
                });
            }
        });
    }
    presentToast(txt) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const toast = yield this.toastController.create({
                message: txt,
                duration: 3000,
                position: 'top',
                mode: 'ios',
                color: 'dark'
            });
            toast.present();
        });
    }
    resend() {
        this.forgot({ email: this.email });
    }
};
ForgotPage.ctorParameters = () => [
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.LoadingController }
];
ForgotPage = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Component)({
        selector: 'app-forgot',
        template: _forgot_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_forgot_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], ForgotPage);



/***/ }),

/***/ 15096:
/*!****************************************************!*\
  !*** ./src/app/forgot/forgot.page.scss?ngResource ***!
  \****************************************************/
/***/ ((module) => {

module.exports = "\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJmb3Jnb3QucGFnZS5zY3NzIn0= */";

/***/ }),

/***/ 74640:
/*!****************************************************!*\
  !*** ./src/app/forgot/forgot.page.html?ngResource ***!
  \****************************************************/
/***/ ((module) => {

module.exports = "<ion-content class=\"ion-padding\" *ngIf=\"text\">\n\n<ion-icon name=\"arrow-back-outline\" style=\"font-size: 26px\" routerLink=\"/login\" routerDirection=\"back\"></ion-icon>\n\n<br><br><br>\n\n<!--Send email for OTP-->\n<div *ngIf=\"!user_id\">\n<h1 align=\"center\">{{ text.forgot_title }}</h1>\n<p align=\"center\">{{ text.forgot_text }}</p>\n<br>\n<form #form=\"ngForm\" (ngSubmit)=\"forgot(form.value)\">\n\n<ion-item lines=\"none\" mode=\"md\">\n  <ion-label position=\"floating\">{{ text.enter_email }}</ion-label>\n  <ion-input type=\"email\" ngModel name=\"email\" required></ion-input>\n</ion-item>\n\n<br>\n<ion-button expand=\"block\" mode=\"ios\" type=\"submit\" [disabled]=\"!form.valid\">{{ text.reset }}</ion-button>\n\n</form>\n</div>\n\n<!--Verify OTP-->\n<div *ngIf=\"user_id && !newPassword\">\n<h1 align=\"center\">{{ text.verify_email }}</h1>\n<p align=\"center\">{{ email }}</p>\n<br>\n<form #form=\"ngForm\" (ngSubmit)=\"verify(form.value)\">\n\n<ion-item lines=\"none\" mode=\"md\">\n  <ion-label position=\"floating\">{{ text.enter_otp }}</ion-label>\n  <ion-input type=\"tel\" ngModel name=\"otp\" required></ion-input>\n</ion-item>\n\n<br><br>\n<ion-button expand=\"block\" mode=\"ios\" type=\"submit\" >{{ text.verify }}</ion-button>\n\n</form>\n</div>\n\n<!--Verify OTP-->\n<div *ngIf=\"user_id && newPassword\">\n<h1 align=\"center\">{{ text.new_pass }}</h1>\n<br>\n<form #form=\"ngForm\" (ngSubmit)=\"new_password(form.value)\">\n\n<ion-item lines=\"none\" mode=\"md\">\n  <ion-label position=\"floating\">{{ text.new_password }}</ion-label>\n  <ion-input type=\"password\" ngModel name=\"password\" required></ion-input>\n</ion-item>\n\n<ion-item lines=\"none\" mode=\"md\">\n  <ion-label position=\"floating\">{{ text.confirm_password }}</ion-label>\n  <ion-input type=\"password\" ngModel name=\"new_password\" required></ion-input>\n</ion-item>\n\n<br><br>\n<ion-button expand=\"block\" mode=\"ios\" type=\"submit\" >{{ text.update_pass }}</ion-button>\n\n</form>\n</div>\n\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_forgot_forgot_module_ts.js.map