"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_login_login_module_ts"],{

/***/ 45393:
/*!***********************************************!*\
  !*** ./src/app/login/login-routing.module.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LoginPageRoutingModule": () => (/* binding */ LoginPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _login_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./login.page */ 66825);




const routes = [
    {
        path: '',
        component: _login_page__WEBPACK_IMPORTED_MODULE_0__.LoginPage
    }
];
let LoginPageRoutingModule = class LoginPageRoutingModule {
};
LoginPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], LoginPageRoutingModule);



/***/ }),

/***/ 80107:
/*!***************************************!*\
  !*** ./src/app/login/login.module.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LoginPageModule": () => (/* binding */ LoginPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _login_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./login-routing.module */ 45393);
/* harmony import */ var _login_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./login.page */ 66825);







let LoginPageModule = class LoginPageModule {
};
LoginPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _login_routing_module__WEBPACK_IMPORTED_MODULE_0__.LoginPageRoutingModule
        ],
        declarations: [_login_page__WEBPACK_IMPORTED_MODULE_1__.LoginPage]
    })
], LoginPageModule);



/***/ }),

/***/ 66825:
/*!*************************************!*\
  !*** ./src/app/login/login.page.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LoginPage": () => (/* binding */ LoginPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _login_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./login.page.html?ngResource */ 41729);
/* harmony import */ var _login_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./login.page.scss?ngResource */ 87047);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ 93819);







let LoginPage = class LoginPage {
    constructor(route, server, toastController, nav, loadingController) {
        this.route = route;
        this.server = server;
        this.toastController = toastController;
        this.nav = nav;
        this.loadingController = loadingController;
        this.email = "sushilasaharan9988@gmail.com";
        this.password = "google123";
        this.text = JSON.parse(localStorage.getItem('app_text'));
        this.setting = JSON.parse(localStorage.getItem('setting'));
    }
    ngOnInit() {
    }
    login(data) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            if (!this.email || !this.password) {
                return this.presentToast(this.text.login_validation);
            }
            const loading = yield this.loadingController.create({
                message: '',
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.login(data).subscribe((response) => {
                if (response.msg != "done") {
                    this.presentToast(this.text.login_error);
                }
                else {
                    localStorage.setItem('user_id', response.user.id);
                    localStorage.setItem('user_data', JSON.stringify(response.user));
                    if (localStorage.getItem('cart_no') && localStorage.getItem('cart_no') != undefined) {
                        this.nav.navigateBack('/cart');
                    }
                    else {
                        window.location.href = "/account";
                    }
                }
                loading.dismiss();
            });
        });
    }
    presentToast(txt) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const toast = yield this.toastController.create({
                message: txt,
                duration: 3000,
                position: 'top',
                mode: 'ios',
                color: 'dark'
            });
            toast.present();
        });
    }
    goBack() {
        if (localStorage.getItem('cart_no')) {
            this.nav.navigateBack('/cart');
        }
        else {
            this.nav.navigateRoot('/home');
        }
    }
};
LoginPage.ctorParameters = () => [
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__.ActivatedRoute },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.LoadingController }
];
LoginPage = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
        selector: 'app-login',
        template: _login_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_login_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], LoginPage);



/***/ }),

/***/ 87047:
/*!**************************************************!*\
  !*** ./src/app/login/login.page.scss?ngResource ***!
  \**************************************************/
/***/ ((module) => {

module.exports = "ion-list {\n  border-radius: 10px;\n}\n\nion-item {\n  border-radius: 10px;\n}\n\nh1 {\n  font-family: \"Poppins\", sans-serif;\n}\n\n.login-divider {\n  margin: 28px 0;\n  display: flex;\n  align-items: center;\n  gap: 12px;\n}\n\n.login-divider .hr {\n  flex: 1;\n  height: 1px;\n  background: var(--ion-color-step-300, var(--ion-background-color-step-300, #b3b3b3));\n}\n\n.login-divider .divider-text {\n  font-family: \"Poppins\", sans-serif;\n  font-size: 16px;\n  color: black;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxvZ2luLnBhZ2Uuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFFQTtFQUVFLG1CQUFBO0FBRkY7O0FBS0E7RUFFRSxtQkFBQTtBQUhGOztBQU1BO0VBRUUsa0NBQUE7QUFKRjs7QUFPQTtFQUNFLGNBQUE7RUFDQSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxTQUFBO0FBSkY7O0FBS0U7RUFDRSxPQUFBO0VBQ0EsV0FBQTtFQUNBLG9GQUFBO0FBSEo7O0FBUUU7RUFDRSxrQ0FBQTtFQUNBLGVBQUE7RUFDQSxZQUFBO0FBTkoiLCJmaWxlIjoibG9naW4ucGFnZS5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiXG5cbmlvbi1saXN0XG57XG4gIGJvcmRlci1yYWRpdXM6MTBweDtcbn1cblxuaW9uLWl0ZW1cbntcbiAgYm9yZGVyLXJhZGl1czoxMHB4O1xufVxuXG5oMVxue1xuICBmb250LWZhbWlseTogXCJQb3BwaW5zXCIsIHNhbnMtc2VyaWY7XG59XG5cbi5sb2dpbi1kaXZpZGVyIHtcbiAgbWFyZ2luOiAyOHB4IDA7XG4gIGRpc3BsYXk6IGZsZXg7XG4gIGFsaWduLWl0ZW1zOiBjZW50ZXI7XG4gIGdhcDogMTJweDtcbiAgLmhyIHtcbiAgICBmbGV4OiAxO1xuICAgIGhlaWdodDogMXB4O1xuICAgIGJhY2tncm91bmQ6IHZhcihcbiAgICAgIC0taW9uLWNvbG9yLXN0ZXAtMzAwLFxuICAgICAgdmFyKC0taW9uLWJhY2tncm91bmQtY29sb3Itc3RlcC0zMDAsICNiM2IzYjMpXG4gICAgKTtcbiAgfVxuICAuZGl2aWRlci10ZXh0IHtcbiAgICBmb250LWZhbWlseTogXCJQb3BwaW5zXCIsIHNhbnMtc2VyaWY7XG4gICAgZm9udC1zaXplOiAxNnB4O1xuICAgIGNvbG9yOmJsYWNrXG4gIH1cbn0iXX0= */";

/***/ }),

/***/ 41729:
/*!**************************************************!*\
  !*** ./src/app/login/login.page.html?ngResource ***!
  \**************************************************/
/***/ ((module) => {

module.exports = "<ion-header class=\"ion-no-border\">\n<ion-toolbar color=\"primary\">\n<ion-buttons slot=\"start\">\n<ion-back-button></ion-back-button>\n</ion-buttons>\n</ion-toolbar>\n</ion-header>\n\n<ion-content *ngIf=\"text && setting\" class=\"ion-padding\">\n\n<form #form=\"ngForm\" (ngSubmit)=\"login(form.value)\">\n\n<h1>{{ text.login_title }}</h1><br>\n\n<ion-item lines=\"none\" *ngIf=\"setting.verify_type == 0 || setting.verify_type == 3\">\n  <ion-label position=\"floating\">{{ text.login_email }}</ion-label>\n  <ion-input type=\"email\" [(ngModel)]=\"email\" required name=\"email\"></ion-input>\n</ion-item>\n\n<ion-item lines=\"none\" *ngIf=\"setting.verify_type == 1 || setting.verify_type == 2\">\n  <ion-label position=\"floating\">{{ text.signup_phone }}</ion-label>\n  <ion-input type=\"tel\" [(ngModel)]=\"phone\" required name=\"phone\"></ion-input>\n</ion-item>\n\n<ion-item lines=\"none\">\n  <ion-label position=\"floating\">{{ text.login_password }}</ion-label>\n  <ion-input type=\"password\" [(ngModel)]=\"password\" required name=\"password\"></ion-input>\n</ion-item>\n\n<a routerLink=\"/forgot\" routerDirection=\"forward\" style=\"color:gray;font-size: 14px;float:right\">{{ text.forgot_pass }}</a>\n\n<br><br>\n<ion-button expand=\"block\" mode=\"ios\" type=\"submit\" style=\"margin-top: 15px\">{{ text.login_button }}</ion-button>\n\n\n\n</form>\n</ion-content>\n<ion-footer class=\"ion-no-border\">\n<ion-toolbar>\n<div class=\"ion-padding\">\n\n<div class=\"login-divider\">\n  <span class=\"hr\"></span>\n  <span class=\"divider-text\">{{ text.dont_have }}</span>\n  <span class=\"hr\"></span>\n</div>\n\n<ion-button mode=\"ios\" expand=\"block\" color=\"dark\" routerLink=\"/signup\">{{ text.signup_now }}</ion-button>\n\n</div>\n</ion-toolbar>\n</ion-footer>";

/***/ })

}]);
//# sourceMappingURL=src_app_login_login_module_ts.js.map