(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["main"],{

/***/ 90158:
/*!***************************************!*\
  !*** ./src/app/app-routing.module.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppRoutingModule": () => (/* binding */ AppRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ 52816);



const routes = [
    {
        path: '',
        redirectTo: 'lang',
        pathMatch: 'full'
    },
    {
        path: 'folder/:id',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_folder_folder_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./folder/folder.module */ 3412)).then(m => m.FolderPageModule)
    },
    {
        path: 'home',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_home_home_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./home/home.module */ 3467)).then(m => m.HomePageModule)
    },
    {
        path: 'about',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_about_about_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./about/about.module */ 46985)).then(m => m.AboutPageModule)
    },
    {
        path: 'faq',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_faq_faq_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./faq/faq.module */ 5083)).then(m => m.FaqPageModule)
    },
    {
        path: 'contact',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_contact_contact_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./contact/contact.module */ 25486)).then(m => m.ContactPageModule)
    },
    {
        path: 'account',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_account_account_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./account/account.module */ 63879)).then(m => m.AccountPageModule)
    },
    {
        path: 'done',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_done_done_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./done/done.module */ 44410)).then(m => m.DonePageModule)
    },
    {
        path: 'checkout',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_checkout_checkout_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./checkout/checkout.module */ 28400)).then(m => m.CheckoutPageModule)
    },
    {
        path: 'my',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_my_my_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./my/my.module */ 68774)).then(m => m.MyPageModule)
    },
    {
        path: 'lang',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_lang_lang_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./lang/lang.module */ 87026)).then(m => m.LangPageModule)
    },
    {
        path: 'city',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_city_city_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./city/city.module */ 11368)).then(m => m.CityPageModule)
    },
    {
        path: 'item/:id/:type',
        loadChildren: () => Promise.all(/*! import() */[__webpack_require__.e("common"), __webpack_require__.e("src_app_item_item_module_ts")]).then(__webpack_require__.bind(__webpack_require__, /*! ./item/item.module */ 4672)).then(m => m.ItemPageModule)
    },
    {
        path: 'option',
        loadChildren: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! ./option/option.module */ 33644)).then(m => m.OptionPageModule)
    },
    {
        path: 'offer',
        loadChildren: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! ./offer/offer.module */ 61357)).then(m => m.OfferPageModule)
    },
    {
        path: 'info',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_info_info_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./info/info.module */ 43056)).then(m => m.InfoPageModule)
    },
    {
        path: 'search',
        loadChildren: () => Promise.all(/*! import() */[__webpack_require__.e("common"), __webpack_require__.e("src_app_search_search_module_ts")]).then(__webpack_require__.bind(__webpack_require__, /*! ./search/search.module */ 24682)).then(m => m.SearchPageModule)
    },
    {
        path: 'cart',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_cart_cart_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./cart/cart.module */ 12943)).then(m => m.CartPageModule)
    },
    {
        path: 'login',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_login_login_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./login/login.module */ 80107)).then(m => m.LoginPageModule)
    },
    {
        path: 'signup',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_signup_signup_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./signup/signup.module */ 77648)).then(m => m.SignupPageModule)
    },
    {
        path: 'forgot',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_forgot_forgot_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./forgot/forgot.module */ 76938)).then(m => m.ForgotPageModule)
    },
    {
        path: 'address',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_address_address_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./address/address.module */ 83384)).then(m => m.AddressPageModule)
    },
    {
        path: 'rate/:oid',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_rate_rate_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./rate/rate.module */ 41413)).then(m => m.RatePageModule)
    },
    {
        path: 'setting',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_setting_setting_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./setting/setting.module */ 80943)).then(m => m.SettingPageModule)
    },
    {
        path: 'detail/:id',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_detail_detail_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./detail/detail.module */ 9251)).then(m => m.DetailPageModule)
    },
    {
        path: 'welcome',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_welcome_welcome_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./welcome/welcome.module */ 32526)).then(m => m.WelcomePageModule)
    },
    {
        path: 'menu',
        loadChildren: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! ./menu/menu.module */ 32825)).then(m => m.MenuPageModule)
    },
    {
        path: 'note',
        loadChildren: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! ./note/note.module */ 29908)).then(m => m.NotePageModule)
    },
    {
        path: 'payment',
        loadChildren: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! ./payment/payment.module */ 24068)).then(m => m.PaymentPageModule)
    },
    {
        path: 'select-address',
        loadChildren: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! ./select-address/select-address.module */ 13372)).then(m => m.SelectAddressPageModule)
    },
    {
        path: 'tip',
        loadChildren: () => Promise.resolve(/*! import() */).then(__webpack_require__.bind(__webpack_require__, /*! ./tip/tip.module */ 81875)).then(m => m.TipPageModule)
    },
    {
        path: 'view/:id',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_view_view_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./view/view.module */ 63070)).then(m => m.ViewPageModule)
    },
    {
        path: 'chat',
        loadChildren: () => __webpack_require__.e(/*! import() */ "src_app_chat_chat_module_ts").then(__webpack_require__.bind(__webpack_require__, /*! ./chat/chat.module */ 20818)).then(m => m.ChatPageModule)
    }
];
let AppRoutingModule = class AppRoutingModule {
};
AppRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_0__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_1__.NgModule)({
        imports: [
            _angular_router__WEBPACK_IMPORTED_MODULE_2__.RouterModule.forRoot(routes, { preloadingStrategy: _angular_router__WEBPACK_IMPORTED_MODULE_2__.PreloadAllModules })
        ],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__.RouterModule]
    })
], AppRoutingModule);



/***/ }),

/***/ 55041:
/*!**********************************!*\
  !*** ./src/app/app.component.ts ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppComponent": () => (/* binding */ AppComponent)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _app_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./app.component.html?ngResource */ 33383);
/* harmony import */ var _app_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./app.component.scss?ngResource */ 79259);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _awesome_cordova_plugins_splash_screen_ngx__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @awesome-cordova-plugins/splash-screen/ngx */ 64883);
/* harmony import */ var _awesome_cordova_plugins_status_bar_ngx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @awesome-cordova-plugins/status-bar/ngx */ 1550);
/* harmony import */ var onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! onesignal-cordova-plugin */ 10182);
/* harmony import */ var onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_4__);








let AppComponent = class AppComponent {
    constructor(platform, splashScreen, statusBar, nav) {
        this.platform = platform;
        this.splashScreen = splashScreen;
        this.statusBar = statusBar;
        this.nav = nav;
        this.selectedIndex = 0;
        this.dir = 'ltr';
        if (localStorage.getItem('setting') && localStorage.getItem('setting') != undefined) {
            this.setting = JSON.parse(localStorage.getItem('setting'));
        }
        this.initializeApp();
        if (localStorage.getItem('lang_data') && localStorage.getItem('lang_data') != 'null') {
            if (localStorage.getItem('current_lat') && localStorage.getItem('current_lat') != 'null') {
                this.nav.navigateRoot('/home');
            }
            else {
                this.nav.navigateRoot('/city');
            }
        }
        else {
            this.nav.navigateRoot('/welcome');
        }
        /*
        ********************************************
        **Setup language
        ********************************************
        */
        if (localStorage.getItem('lang_data') && localStorage.getItem('lang_data') != undefined) {
            this.lang_data = JSON.parse(localStorage.getItem('lang_data'));
            this.dir = this.lang_data.type == '1' ? 'rtl' : 'ltr';
            console.log(this.lang_data);
        }
        if (localStorage.getItem('app_text') && localStorage.getItem('app_text') != undefined) {
            this.text = JSON.parse(localStorage.getItem('app_text'));
            this.appPages = [
                {
                    title: this.text.menu_home,
                    url: '/home',
                    icon: 'home'
                },
                {
                    title: this.text.running_order,
                    url: '/done',
                    icon: 'stats-chart'
                },
                {
                    title: this.text.account_title,
                    url: '/account',
                    icon: 'person'
                },
                {
                    title: this.text.menu_lang,
                    url: '/lang',
                    icon: 'flag'
                },
                {
                    title: this.text.menu_location,
                    url: '/city',
                    icon: 'location'
                },
                {
                    title: this.text.menu_about,
                    url: '/about',
                    icon: 'information-circle'
                },
                {
                    title: this.text.menu_faq,
                    url: '/faq',
                    icon: 'create'
                },
                {
                    title: this.text.menu_contact,
                    url: '/contact',
                    icon: 'mail'
                },
            ];
        }
    }
    initializeApp() {
        this.platform.ready().then(() => {
            this.statusBar.styleDefault();
            //this.splashScreen.hide();
            this.statusBar.overlaysWebView(false);
            this.statusBar.backgroundColorByHexString('#cb202d');
            this.statusBar.styleDefault();
            if (this.setting) {
                this.OneSignalInit();
            }
        });
    }
    ngOnInit() {
        if (localStorage.getItem('user_data') && localStorage.getItem('user_data') != undefined && localStorage.getItem('user_data') != 'null') {
            this.userData = JSON.parse(localStorage.getItem('user_data'));
        }
        const path = window.location.pathname.split('folder/')[1];
        if (path !== undefined) {
            this.selectedIndex = this.appPages.findIndex(page => page.title.toLowerCase() === path.toLowerCase());
        }
    }
    OneSignalInit() {
        // Uncomment to set OneSignal device logging to VERBOSE  
        // OneSignal.setLogLevel(6, 0);
        // NOTE: Update the setAppId value below with your OneSignal AppId.
        onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_4___default().setAppId(this.setting.push_app_id);
        onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_4___default().setNotificationOpenedHandler(function (jsonData) {
            console.log('notificationOpenedCallback: ' + JSON.stringify(jsonData));
        });
        // Prompts the user for notification permissions.
        //    * Since this shows a generic native prompt, we recommend instead using an In-App Message to prompt for notification permission (See step 7) to better communicate to your users what notifications they will get.
        onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_4___default().promptForPushNotificationsWithUserResponse(function (accepted) {
            console.log("User accepted notifications: " + accepted);
        });
        if (localStorage.getItem('user_id') && localStorage.getItem('user_id') != undefined) {
            onesignal_cordova_plugin__WEBPACK_IMPORTED_MODULE_4___default().sendTags({ user_id: localStorage.getItem('user_id') });
        }
    }
};
AppComponent.ctorParameters = () => [
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.Platform },
    { type: _awesome_cordova_plugins_splash_screen_ngx__WEBPACK_IMPORTED_MODULE_2__.SplashScreen },
    { type: _awesome_cordova_plugins_status_bar_ngx__WEBPACK_IMPORTED_MODULE_3__.StatusBar },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.NavController }
];
AppComponent = (0,tslib__WEBPACK_IMPORTED_MODULE_6__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_7__.Component)({
        selector: 'app-root',
        template: _app_component_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_app_component_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], AppComponent);



/***/ }),

/***/ 36747:
/*!*******************************!*\
  !*** ./src/app/app.module.ts ***!
  \*******************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AppModule": () => (/* binding */ AppModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_platform_browser__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! @angular/platform-browser */ 50318);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _awesome_cordova_plugins_splash_screen_ngx__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! @awesome-cordova-plugins/splash-screen/ngx */ 64883);
/* harmony import */ var _awesome_cordova_plugins_status_bar_ngx__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @awesome-cordova-plugins/status-bar/ngx */ 1550);
/* harmony import */ var _app_component__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./app.component */ 55041);
/* harmony import */ var _app_routing_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./app-routing.module */ 90158);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! @angular/common/http */ 28784);
/* harmony import */ var _awesome_cordova_plugins_stripe_ngx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @awesome-cordova-plugins/stripe/ngx */ 66025);
/* harmony import */ var _option_option_module__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./option/option.module */ 33644);
/* harmony import */ var _offer_offer_module__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./offer/offer.module */ 61357);
/* harmony import */ var _awesome_cordova_plugins_native_geocoder_ngx__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @awesome-cordova-plugins/native-geocoder/ngx */ 79683);
/* harmony import */ var _awesome_cordova_plugins_geolocation_ngx__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @awesome-cordova-plugins/geolocation/ngx */ 36457);
/* harmony import */ var _ionic_native_paypal_ngx__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ionic-native/paypal/ngx */ 9908);
/* harmony import */ var _awesome_cordova_plugins_in_app_browser_ngx__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @awesome-cordova-plugins/in-app-browser/ngx */ 12407);
/* harmony import */ var _angular_service_worker__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! @angular/service-worker */ 64933);
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../environments/environment */ 92340);
/* harmony import */ var _menu_menu_module__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./menu/menu.module */ 32825);
/* harmony import */ var _note_note_module__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./note/note.module */ 29908);
/* harmony import */ var _payment_payment_module__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./payment/payment.module */ 24068);
/* harmony import */ var _select_address_select_address_module__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./select-address/select-address.module */ 13372);
/* harmony import */ var _tip_tip_module__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./tip/tip.module */ 81875);
/* harmony import */ var _awesome_cordova_plugins_native_page_transitions_ngx__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! @awesome-cordova-plugins/native-page-transitions/ngx */ 73635);
/* harmony import */ var flutterwave_angular_v3__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! flutterwave-angular-v3 */ 71022);


























let AppModule = class AppModule {
};
AppModule = (0,tslib__WEBPACK_IMPORTED_MODULE_19__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_20__.NgModule)({
        declarations: [_app_component__WEBPACK_IMPORTED_MODULE_2__.AppComponent],
        entryComponents: [],
        imports: [
            _angular_platform_browser__WEBPACK_IMPORTED_MODULE_21__.BrowserModule,
            flutterwave_angular_v3__WEBPACK_IMPORTED_MODULE_18__.FlutterwaveModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_22__.IonicModule.forRoot(),
            _app_routing_module__WEBPACK_IMPORTED_MODULE_3__.AppRoutingModule,
            _angular_common_http__WEBPACK_IMPORTED_MODULE_23__.HttpClientModule,
            _option_option_module__WEBPACK_IMPORTED_MODULE_5__.OptionPageModule,
            _offer_offer_module__WEBPACK_IMPORTED_MODULE_6__.OfferPageModule,
            _menu_menu_module__WEBPACK_IMPORTED_MODULE_12__.MenuPageModule,
            _note_note_module__WEBPACK_IMPORTED_MODULE_13__.NotePageModule,
            _payment_payment_module__WEBPACK_IMPORTED_MODULE_14__.PaymentPageModule,
            _select_address_select_address_module__WEBPACK_IMPORTED_MODULE_15__.SelectAddressPageModule,
            _tip_tip_module__WEBPACK_IMPORTED_MODULE_16__.TipPageModule,
            _angular_service_worker__WEBPACK_IMPORTED_MODULE_24__.ServiceWorkerModule.register('ngsw-worker.js', { enabled: _environments_environment__WEBPACK_IMPORTED_MODULE_11__.environment.production }),
            _angular_service_worker__WEBPACK_IMPORTED_MODULE_24__.ServiceWorkerModule.register('ngsw-worker.js', {
                enabled: _environments_environment__WEBPACK_IMPORTED_MODULE_11__.environment.production,
                // Register the ServiceWorker as soon as the application is stable
                // or after 30 seconds (whichever comes first).
                registrationStrategy: 'registerWhenStable:30000'
            }),
        ],
        providers: [
            _awesome_cordova_plugins_status_bar_ngx__WEBPACK_IMPORTED_MODULE_1__.StatusBar,
            _awesome_cordova_plugins_splash_screen_ngx__WEBPACK_IMPORTED_MODULE_0__.SplashScreen,
            _awesome_cordova_plugins_stripe_ngx__WEBPACK_IMPORTED_MODULE_4__.Stripe,
            _awesome_cordova_plugins_native_geocoder_ngx__WEBPACK_IMPORTED_MODULE_7__.NativeGeocoder,
            _awesome_cordova_plugins_geolocation_ngx__WEBPACK_IMPORTED_MODULE_8__.Geolocation,
            _ionic_native_paypal_ngx__WEBPACK_IMPORTED_MODULE_9__.PayPal,
            _awesome_cordova_plugins_in_app_browser_ngx__WEBPACK_IMPORTED_MODULE_10__.InAppBrowser,
            _awesome_cordova_plugins_native_page_transitions_ngx__WEBPACK_IMPORTED_MODULE_17__.NativePageTransitions,
            { provide: _angular_router__WEBPACK_IMPORTED_MODULE_25__.RouteReuseStrategy, useClass: _ionic_angular__WEBPACK_IMPORTED_MODULE_22__.IonicRouteStrategy }
        ],
        bootstrap: [_app_component__WEBPACK_IMPORTED_MODULE_2__.AppComponent]
    })
], AppModule);



/***/ }),

/***/ 61198:
/*!*********************************************!*\
  !*** ./src/app/menu/menu-routing.module.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MenuPageRoutingModule": () => (/* binding */ MenuPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _menu_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./menu.page */ 25915);




const routes = [
    {
        path: '',
        component: _menu_page__WEBPACK_IMPORTED_MODULE_0__.MenuPage
    }
];
let MenuPageRoutingModule = class MenuPageRoutingModule {
};
MenuPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], MenuPageRoutingModule);



/***/ }),

/***/ 32825:
/*!*************************************!*\
  !*** ./src/app/menu/menu.module.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MenuPageModule": () => (/* binding */ MenuPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _menu_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./menu-routing.module */ 61198);
/* harmony import */ var _menu_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./menu.page */ 25915);







let MenuPageModule = class MenuPageModule {
};
MenuPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _menu_routing_module__WEBPACK_IMPORTED_MODULE_0__.MenuPageRoutingModule
        ],
        declarations: [_menu_page__WEBPACK_IMPORTED_MODULE_1__.MenuPage]
    })
], MenuPageModule);



/***/ }),

/***/ 25915:
/*!***********************************!*\
  !*** ./src/app/menu/menu.page.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "MenuPage": () => (/* binding */ MenuPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _menu_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./menu.page.html?ngResource */ 31757);
/* harmony import */ var _menu_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./menu.page.scss?ngResource */ 140);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @ionic/angular */ 93819);






let MenuPage = class MenuPage {
    constructor(navParams, modalController, nav) {
        this.navParams = navParams;
        this.modalController = modalController;
        this.nav = nav;
        this.text = JSON.parse(localStorage.getItem('app_text'));
        this.user = navParams.get('user');
    }
    ngOnInit() {
    }
    close() {
        // using the injected ModalController this page
        // can "dismiss" itself and optionally pass back data
        this.modalController.dismiss({
            'dismissed': true
        });
    }
    logout() {
        localStorage.removeItem("user_id");
        localStorage.removeItem("user_data");
        this.modalController.dismiss({
            'logout': true
        });
    }
    gotoPage() {
        this.nav.navigateForward('/account');
        this.modalController.dismiss({
            'dismissed': true,
            'animation': true
        });
    }
};
MenuPage.ctorParameters = () => [
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_2__.NavParams },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_2__.ModalController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_2__.NavController }
];
MenuPage = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.Component)({
        selector: 'app-menu',
        template: _menu_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_menu_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], MenuPage);



/***/ }),

/***/ 52744:
/*!*********************************************!*\
  !*** ./src/app/note/note-routing.module.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NotePageRoutingModule": () => (/* binding */ NotePageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _note_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./note.page */ 50700);




const routes = [
    {
        path: '',
        component: _note_page__WEBPACK_IMPORTED_MODULE_0__.NotePage
    }
];
let NotePageRoutingModule = class NotePageRoutingModule {
};
NotePageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], NotePageRoutingModule);



/***/ }),

/***/ 29908:
/*!*************************************!*\
  !*** ./src/app/note/note.module.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NotePageModule": () => (/* binding */ NotePageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _note_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./note-routing.module */ 52744);
/* harmony import */ var _note_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./note.page */ 50700);







let NotePageModule = class NotePageModule {
};
NotePageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _note_routing_module__WEBPACK_IMPORTED_MODULE_0__.NotePageRoutingModule
        ],
        declarations: [_note_page__WEBPACK_IMPORTED_MODULE_1__.NotePage]
    })
], NotePageModule);



/***/ }),

/***/ 50700:
/*!***********************************!*\
  !*** ./src/app/note/note.page.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "NotePage": () => (/* binding */ NotePage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _note_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./note.page.html?ngResource */ 23528);
/* harmony import */ var _note_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./note.page.scss?ngResource */ 76438);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 52816);







let NotePage = class NotePage {
    constructor(loadingController, server, route, nav, toastController, modalController) {
        this.loadingController = loadingController;
        this.server = server;
        this.route = route;
        this.nav = nav;
        this.toastController = toastController;
        this.modalController = modalController;
        this.text = JSON.parse(localStorage.getItem('app_text'));
    }
    ngOnInit() {
    }
    saveData() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            if (this.notes && this.notes.length > 0) {
                yield this.modalController.dismiss({ notes: this.notes });
            }
        });
    }
};
NotePage.ctorParameters = () => [
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.LoadingController },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_5__.ActivatedRoute },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ModalController }
];
NotePage = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
        selector: 'app-note',
        template: _note_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_note_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], NotePage);



/***/ }),

/***/ 98823:
/*!***********************************************!*\
  !*** ./src/app/offer/offer-routing.module.ts ***!
  \***********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OfferPageRoutingModule": () => (/* binding */ OfferPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _offer_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./offer.page */ 80370);




const routes = [
    {
        path: '',
        component: _offer_page__WEBPACK_IMPORTED_MODULE_0__.OfferPage
    }
];
let OfferPageRoutingModule = class OfferPageRoutingModule {
};
OfferPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], OfferPageRoutingModule);



/***/ }),

/***/ 61357:
/*!***************************************!*\
  !*** ./src/app/offer/offer.module.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OfferPageModule": () => (/* binding */ OfferPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _offer_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./offer-routing.module */ 98823);
/* harmony import */ var _offer_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./offer.page */ 80370);







let OfferPageModule = class OfferPageModule {
};
OfferPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _offer_routing_module__WEBPACK_IMPORTED_MODULE_0__.OfferPageRoutingModule
        ],
        declarations: [_offer_page__WEBPACK_IMPORTED_MODULE_1__.OfferPage]
    })
], OfferPageModule);



/***/ }),

/***/ 80370:
/*!*************************************!*\
  !*** ./src/app/offer/offer.page.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OfferPage": () => (/* binding */ OfferPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _offer_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./offer.page.html?ngResource */ 69164);
/* harmony import */ var _offer_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./offer.page.scss?ngResource */ 9111);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 52816);







let OfferPage = class OfferPage {
    constructor(loadingController, server, route, nav, toastController, modalController) {
        this.loadingController = loadingController;
        this.server = server;
        this.route = route;
        this.nav = nav;
        this.toastController = toastController;
        this.modalController = modalController;
        this.text = JSON.parse(localStorage.getItem('app_text'));
    }
    ngOnInit() {
        this.loadData();
    }
    loadData() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.getOffer(localStorage.getItem('cart_no')).subscribe((response) => {
                this.data = response.data;
                loading.dismiss();
            });
        });
    }
    applyNow(cdata) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            yield this.modalController.dismiss({ id: cdata });
        });
    }
    closeModal() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            yield this.modalController.dismiss({ id: false });
        });
    }
};
OfferPage.ctorParameters = () => [
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.LoadingController },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_5__.ActivatedRoute },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ModalController }
];
OfferPage = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
        selector: 'app-offer',
        template: _offer_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_offer_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], OfferPage);



/***/ }),

/***/ 59302:
/*!*************************************************!*\
  !*** ./src/app/option/option-routing.module.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OptionPageRoutingModule": () => (/* binding */ OptionPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _option_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./option.page */ 31355);




const routes = [
    {
        path: '',
        component: _option_page__WEBPACK_IMPORTED_MODULE_0__.OptionPage
    }
];
let OptionPageRoutingModule = class OptionPageRoutingModule {
};
OptionPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], OptionPageRoutingModule);



/***/ }),

/***/ 33644:
/*!*****************************************!*\
  !*** ./src/app/option/option.module.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OptionPageModule": () => (/* binding */ OptionPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _option_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./option-routing.module */ 59302);
/* harmony import */ var _option_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./option.page */ 31355);







let OptionPageModule = class OptionPageModule {
};
OptionPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _option_routing_module__WEBPACK_IMPORTED_MODULE_0__.OptionPageRoutingModule
        ],
        declarations: [_option_page__WEBPACK_IMPORTED_MODULE_1__.OptionPage]
    })
], OptionPageModule);



/***/ }),

/***/ 31355:
/*!***************************************!*\
  !*** ./src/app/option/option.page.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "OptionPage": () => (/* binding */ OptionPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _option_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./option.page.html?ngResource */ 4903);
/* harmony import */ var _option_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./option.page.scss?ngResource */ 67710);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @ionic/angular */ 93819);






let OptionPage = class OptionPage {
    constructor(navParams, modalController) {
        this.navParams = navParams;
        this.modalController = modalController;
        this.addonData = [];
        this.req = false;
        this.item = navParams.get('item');
        this.currency = navParams.get('currency');
        this.text = JSON.parse(localStorage.getItem('app_text'));
    }
    ngOnInit() {
    }
    hasReq() {
        var array = [];
        var error = [];
        for (var i = 0; i < this.item.addon.length; i++) {
            if (this.item.addon[i].req == 1) {
                for (var it = 0; it < this.item.addon[i].item.length; it++) {
                    if (!this.addonData.includes(this.item.addon[i].item[it].id)) {
                        array.push(1);
                    }
                }
            }
            if (array.length == this.item.addon[i].item.length) {
                error.push(1);
            }
            array = [];
        }
        if (error.length > 0) {
            return false;
        }
        else {
            return true;
        }
    }
    addToCart() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__awaiter)(this, void 0, void 0, function* () {
            yield this.modalController.dismiss({ id: this.item.id, price: this.itemPrice, type: this.itemID, addonData: this.addonData, notes: this.notes });
        });
    }
    closeModal() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__awaiter)(this, void 0, void 0, function* () {
            yield this.modalController.dismiss({ data: true });
        });
    }
    selectItem(type, price) {
        this.itemID = type;
        this.itemPrice = price;
        console.log(this.itemID);
    }
    addonSelect(id, type, ids = []) {
        if (type == 1) {
            for (var i = 0; i < ids.length; i++) {
                if (this.addonData.includes(ids[i].id)) {
                    var ind = this.addonData.indexOf(ids[i].id);
                    this.addonData.splice(ind, 1);
                }
            }
        }
        if (this.addonData.includes(id)) {
            var ind = this.addonData.indexOf(id);
            this.addonData.splice(ind, 1);
        }
        else {
            this.addonData.push(id);
        }
        console.log(this.addonData);
    }
};
OptionPage.ctorParameters = () => [
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.NavParams },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_3__.ModalController }
];
OptionPage = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.Component)({
        selector: 'app-option',
        template: _option_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_option_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], OptionPage);



/***/ }),

/***/ 23509:
/*!***************************************************!*\
  !*** ./src/app/payment/payment-routing.module.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PaymentPageRoutingModule": () => (/* binding */ PaymentPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _payment_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./payment.page */ 70684);




const routes = [
    {
        path: '',
        component: _payment_page__WEBPACK_IMPORTED_MODULE_0__.PaymentPage
    }
];
let PaymentPageRoutingModule = class PaymentPageRoutingModule {
};
PaymentPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], PaymentPageRoutingModule);



/***/ }),

/***/ 24068:
/*!*******************************************!*\
  !*** ./src/app/payment/payment.module.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PaymentPageModule": () => (/* binding */ PaymentPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _payment_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./payment-routing.module */ 23509);
/* harmony import */ var _payment_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./payment.page */ 70684);







let PaymentPageModule = class PaymentPageModule {
};
PaymentPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _payment_routing_module__WEBPACK_IMPORTED_MODULE_0__.PaymentPageRoutingModule
        ],
        declarations: [_payment_page__WEBPACK_IMPORTED_MODULE_1__.PaymentPage]
    })
], PaymentPageModule);



/***/ }),

/***/ 70684:
/*!*****************************************!*\
  !*** ./src/app/payment/payment.page.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "PaymentPage": () => (/* binding */ PaymentPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _payment_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./payment.page.html?ngResource */ 7916);
/* harmony import */ var _payment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./payment.page.scss?ngResource */ 19529);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 52816);








let PaymentPage = class PaymentPage {
    constructor(navParams, loadingController, server, route, nav, toastController, modalController) {
        this.navParams = navParams;
        this.loadingController = loadingController;
        this.server = server;
        this.route = route;
        this.nav = nav;
        this.toastController = toastController;
        this.modalController = modalController;
        this.stripeView = false;
        this.text = JSON.parse(localStorage.getItem('app_text'));
        this.setting = JSON.parse(localStorage.getItem('setting'));
        this.years = JSON.parse(localStorage.getItem('years'));
        this.total = navParams.get('total');
        this.wallet = navParams.get('wallet');
        this.user = navParams.get('user');
        console.log(this.total);
    }
    ngOnInit() {
    }
    loadData() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.getOffer(localStorage.getItem('cart_no')).subscribe((response) => {
                this.data = response.data;
                loading.dismiss();
            });
        });
    }
    applyNow() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            yield this.modalController.dismiss({ hasEcash: this.hasEcash, payment: this.payment, card_no: this.card_no, exp_month: this.exp_month, exp_year: this.exp_year, cvv: this.cvv });
        });
    }
    closeModal() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            yield this.modalController.dismiss({ id: false });
        });
    }
    setPayment(id) {
        this.payment = id;
        if (id == 2) {
            this.stripeView = true;
            setTimeout(() => {
                this.content.scrollToBottom(300);
            }, 100);
        }
        else {
            this.stripeView = false;
        }
    }
    allSet() {
        if (this.payment) {
            if (this.payment == 2) {
                if (this.card_no && this.exp_month && this.exp_year && this.cvv) {
                    return true;
                }
                else {
                    return false;
                }
            }
            else {
                return true;
            }
        }
        else {
            if (this.hasEcash) {
                if (this.total - this.wallet <= 0) {
                    return true;
                }
            }
            else {
                return false;
            }
        }
    }
    useEcash() {
        this.hasEcash = this.hasEcash == true ? false : true;
    }
};
PaymentPage.ctorParameters = () => [
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.NavParams },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.LoadingController },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_5__.ActivatedRoute },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ModalController }
];
PaymentPage.propDecorators = {
    content: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_6__.ViewChild, args: ['content', { static: false },] }]
};
PaymentPage = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
        selector: 'app-payment',
        template: _payment_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_payment_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], PaymentPage);



/***/ }),

/***/ 11845:
/*!*****************************************************************!*\
  !*** ./src/app/select-address/select-address-routing.module.ts ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SelectAddressPageRoutingModule": () => (/* binding */ SelectAddressPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _select_address_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./select-address.page */ 55618);




const routes = [
    {
        path: '',
        component: _select_address_page__WEBPACK_IMPORTED_MODULE_0__.SelectAddressPage
    }
];
let SelectAddressPageRoutingModule = class SelectAddressPageRoutingModule {
};
SelectAddressPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], SelectAddressPageRoutingModule);



/***/ }),

/***/ 13372:
/*!*********************************************************!*\
  !*** ./src/app/select-address/select-address.module.ts ***!
  \*********************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SelectAddressPageModule": () => (/* binding */ SelectAddressPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _select_address_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./select-address-routing.module */ 11845);
/* harmony import */ var _select_address_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./select-address.page */ 55618);







let SelectAddressPageModule = class SelectAddressPageModule {
};
SelectAddressPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _select_address_routing_module__WEBPACK_IMPORTED_MODULE_0__.SelectAddressPageRoutingModule
        ],
        declarations: [_select_address_page__WEBPACK_IMPORTED_MODULE_1__.SelectAddressPage]
    })
], SelectAddressPageModule);



/***/ }),

/***/ 55618:
/*!*******************************************************!*\
  !*** ./src/app/select-address/select-address.page.ts ***!
  \*******************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SelectAddressPage": () => (/* binding */ SelectAddressPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _select_address_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./select-address.page.html?ngResource */ 56235);
/* harmony import */ var _select_address_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./select-address.page.scss?ngResource */ 63920);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 52816);








let SelectAddressPage = class SelectAddressPage {
    constructor(navParams, loadingController, server, route, nav, toastController, modalController) {
        this.navParams = navParams;
        this.loadingController = loadingController;
        this.server = server;
        this.route = route;
        this.nav = nav;
        this.toastController = toastController;
        this.modalController = modalController;
        this.text = JSON.parse(localStorage.getItem('app_text'));
        this.address = navParams.get('address');
    }
    ngOnInit() {
    }
    applyNow(a) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            yield this.modalController.dismiss({ address: a });
        });
    }
    closeModal() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            yield this.modalController.dismiss({ id: false });
        });
    }
    addAddress() {
        this.closeModal();
    }
};
SelectAddressPage.ctorParameters = () => [
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.NavParams },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.LoadingController },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_5__.ActivatedRoute },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ModalController }
];
SelectAddressPage = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
        selector: 'app-select-address',
        template: _select_address_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_select_address_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], SelectAddressPage);



/***/ }),

/***/ 76419:
/*!*******************************************!*\
  !*** ./src/app/service/server.service.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ServerService": () => (/* binding */ ServerService)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/common/http */ 28784);
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! rxjs/operators */ 86942);




let ServerService = class ServerService {
    //url = "http://localhost/new_pos/api/";
    constructor(http) {
        this.http = http;
        //put /api/ after your url e.g https://www.abc.com/api/
        this.url = "https://fda.ftafat.in/api/";
    }
    welcome() {
        return this.http.get(this.url + 'welcome?lang_id=0')
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    getStore(id) {
        return this.http.get(this.url + 'getStore?lang_id=' + localStorage.getItem('lid') + "&category_id=" + id + "&lat=" + localStorage.getItem("current_lat") + "&lng=" + localStorage.getItem("current_lng"))
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    homepage(id, type) {
        if (localStorage.getItem('temp_user_id') && localStorage.getItem('temp_user_id') != undefined) {
            var temp = localStorage.getItem('temp_user_id');
        }
        else {
            var temp = Math.floor(Math.random() * 2000000000) + 1;
            localStorage.setItem('temp_user_id', temp);
        }
        return this.http.get(this.url + 'homepage?lid=' + localStorage.getItem('lid') + "&user_id=" + localStorage.getItem('user_id') + "&city_id=" + localStorage.getItem('city_id') + "&cate_id=" + id + '&cart_no=' + localStorage.getItem('cart_no') + "&lat=" + localStorage.getItem("current_lat") + "&lng=" + localStorage.getItem("current_lng") + "&store_type=" + type + "&temp_user_id=" + temp)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    item(id) {
        if (localStorage.getItem('temp_user_id') && localStorage.getItem('temp_user_id') != undefined) {
            var temp = localStorage.getItem('temp_user_id');
        }
        else {
            var temp = Math.floor(Math.random() * 2000000000) + 1;
            localStorage.setItem('temp_user_id', temp);
        }
        return this.http.get(this.url + 'item?lid=' + localStorage.getItem('lid') + "&user_id=" + localStorage.getItem('user_id') + "&store_id=" + id + "&lat=" + localStorage.getItem("current_lat") + "&lng=" + localStorage.getItem("current_lng") + "&temp_user_id=" + temp)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    city() {
        return this.http.get(this.url + 'city?lid=' + localStorage.getItem('lid'))
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    page() {
        return this.http.get(this.url + 'page?lid=' + localStorage.getItem('lid'))
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    makeStripePayment(data) {
        return this.http.get(this.url + 'makeStripePayment' + data + '&lid=' + localStorage.getItem('lid'))
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    my(id) {
        return this.http.get(this.url + 'my?id=' + id + '&lid=' + localStorage.getItem('lid'))
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    getLang(id) {
        return this.http.get(this.url + 'getLang?lang_id=' + id)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    addToCart(data) {
        return this.http.post(this.url + 'addToCart?lang_id=' + localStorage.getItem('lid'), data)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    cartCount(id) {
        return this.http.get(this.url + 'cartCount?lid=' + localStorage.getItem('lid') + "&cart_no=" + id)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    updateCart(id, type) {
        return this.http.get(this.url + 'updateCart/' + id + '/' + type)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    getCart(cartNo) {
        return this.http.get(this.url + 'getCart/' + cartNo + '?lid=' + localStorage.getItem('lid') + "&lat=" + localStorage.getItem("current_lat") + "&lng=" + localStorage.getItem("current_lng"))
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    getOffer(cartNo) {
        return this.http.get(this.url + 'getOffer/' + cartNo + '?lid=' + localStorage.getItem('lid'))
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    applyCoupen(id, cartNo) {
        return this.http.get(this.url + 'applyCoupen/' + id + '/' + cartNo + "&lat=" + localStorage.getItem("current_lat") + "&lng=" + localStorage.getItem("current_lng"))
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    removeOffer(id, cartNo) {
        return this.http.get(this.url + 'removeOffer/' + id + '/' + cartNo + "&lat=" + localStorage.getItem("current_lat") + "&lng=" + localStorage.getItem("current_lng"))
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    order(data) {
        return this.http.post(this.url + 'order' + "?lat=" + localStorage.getItem("current_lat") + "&lng=" + localStorage.getItem("current_lng"), data)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    login(data) {
        return this.http.post(this.url + 'login', data)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    signup(data) {
        return this.http.post(this.url + 'signup', data)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    forgot(data) {
        return this.http.post(this.url + 'forgot', data)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    verify(data) {
        return this.http.post(this.url + 'verify', data)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    updatePassword(data) {
        return this.http.post(this.url + 'updatePassword', data)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    userInfo(id, sid = 0, cart_no = 0) {
        return this.http.get(this.url + 'userInfo?id=' + id + '&store_id=' + sid + '&cart_no=' + cart_no)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    saveAddress(data) {
        return this.http.post(this.url + 'saveAddress', data)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    cancelOrder(id) {
        return this.http.get(this.url + 'cancelOrder?id=' + id + '&lid=' + localStorage.getItem('lid'))
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    rating(data) {
        return this.http.post(this.url + 'rating', data)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    updateInfo(data, id) {
        return this.http.post(this.url + 'updateInfo?id=' + id, data)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    runningOrder() {
        return this.http.get(this.url + 'runningOrder?id=' + localStorage.getItem('user_id'))
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    orderDetail(id) {
        return this.http.get(this.url + 'orderDetail?lid=' + localStorage.getItem('lid') + '&order_id=' + id)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    getSearch(id) {
        return this.http.get(this.url + 'getSearch?lid=' + localStorage.getItem('lid') + '&item_id=' + id)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    verifyUser(id) {
        return this.http.get(this.url + 'verifyUser?id=' + id)
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
    delete() {
        return this.http.get(this.url + 'userInfo?id=' + localStorage.getItem('lid') + "&type=delete")
            .pipe((0,rxjs_operators__WEBPACK_IMPORTED_MODULE_0__.map)(results => results));
    }
};
ServerService.ctorParameters = () => [
    { type: _angular_common_http__WEBPACK_IMPORTED_MODULE_1__.HttpClient }
];
ServerService = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.Injectable)({
        providedIn: 'root'
    })
], ServerService);



/***/ }),

/***/ 45356:
/*!*******************************************!*\
  !*** ./src/app/tip/tip-routing.module.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TipPageRoutingModule": () => (/* binding */ TipPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _tip_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./tip.page */ 25882);




const routes = [
    {
        path: '',
        component: _tip_page__WEBPACK_IMPORTED_MODULE_0__.TipPage
    }
];
let TipPageRoutingModule = class TipPageRoutingModule {
};
TipPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], TipPageRoutingModule);



/***/ }),

/***/ 81875:
/*!***********************************!*\
  !*** ./src/app/tip/tip.module.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TipPageModule": () => (/* binding */ TipPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _tip_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./tip-routing.module */ 45356);
/* harmony import */ var _tip_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tip.page */ 25882);







let TipPageModule = class TipPageModule {
};
TipPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _tip_routing_module__WEBPACK_IMPORTED_MODULE_0__.TipPageRoutingModule
        ],
        declarations: [_tip_page__WEBPACK_IMPORTED_MODULE_1__.TipPage]
    })
], TipPageModule);



/***/ }),

/***/ 25882:
/*!*********************************!*\
  !*** ./src/app/tip/tip.page.ts ***!
  \*********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "TipPage": () => (/* binding */ TipPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _tip_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./tip.page.html?ngResource */ 67843);
/* harmony import */ var _tip_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./tip.page.scss?ngResource */ 50910);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 52816);








let TipPage = class TipPage {
    constructor(navParams, loadingController, server, route, nav, toastController, modalController) {
        this.navParams = navParams;
        this.loadingController = loadingController;
        this.server = server;
        this.route = route;
        this.nav = nav;
        this.toastController = toastController;
        this.modalController = modalController;
        this.filterData = [];
        this.text = JSON.parse(localStorage.getItem('app_text'));
        this.setting = JSON.parse(localStorage.getItem('setting'));
        this.tips = navParams.get('tips');
    }
    ngOnInit() {
    }
    applyNow(t) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            yield this.modalController.dismiss({ tip: t });
        });
    }
    closeModal() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            yield this.modalController.dismiss({ id: false });
        });
    }
};
TipPage.ctorParameters = () => [
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.NavParams },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.LoadingController },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_5__.ActivatedRoute },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ModalController }
];
TipPage = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
        selector: 'app-tip',
        template: _tip_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_tip_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], TipPage);



/***/ }),

/***/ 92340:
/*!*****************************************!*\
  !*** ./src/environments/environment.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "environment": () => (/* binding */ environment)
/* harmony export */ });
// This file can be replaced during build by using the `fileReplacements` array.
// `ng build --prod` replaces `environment.ts` with `environment.prod.ts`.
// The list of file replacements can be found in `angular.json`.
const environment = {
    production: false
};
/*
 * For easier debugging in development mode, you can import the following file
 * to ignore zone related error stack frames such as `zone.run`, `zoneDelegate.invokeTask`.
 *
 * This import should be commented out in production mode because it will have a negative impact
 * on performance if an error is thrown.
 */
// import 'zone.js/dist/zone-error';  // Included with Angular CLI.


/***/ }),

/***/ 14431:
/*!*********************!*\
  !*** ./src/main.ts ***!
  \*********************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_platform_browser_dynamic__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/platform-browser-dynamic */ 68150);
/* harmony import */ var _app_app_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./app/app.module */ 36747);
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./environments/environment */ 92340);




if (_environments_environment__WEBPACK_IMPORTED_MODULE_1__.environment.production) {
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.enableProdMode)();
}
(0,_angular_platform_browser_dynamic__WEBPACK_IMPORTED_MODULE_3__.platformBrowserDynamic)().bootstrapModule(_app_app_module__WEBPACK_IMPORTED_MODULE_0__.AppModule)
    .catch(err => console.log(err));


/***/ }),

/***/ 50863:
/*!******************************************************************************************************************************************!*\
  !*** ./node_modules/@ionic/core/dist/esm/ lazy ^\.\/.*\.entry\.js$ include: \.entry\.js$ exclude: \.system\.entry\.js$ namespace object ***!
  \******************************************************************************************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var map = {
	"./ion-accordion_2.entry.js": [
		70079,
		"common",
		"node_modules_ionic_core_dist_esm_ion-accordion_2_entry_js"
	],
	"./ion-action-sheet.entry.js": [
		25593,
		"common",
		"node_modules_ionic_core_dist_esm_ion-action-sheet_entry_js"
	],
	"./ion-alert.entry.js": [
		13225,
		"common",
		"node_modules_ionic_core_dist_esm_ion-alert_entry_js"
	],
	"./ion-app_8.entry.js": [
		4812,
		"common",
		"node_modules_ionic_core_dist_esm_ion-app_8_entry_js"
	],
	"./ion-avatar_3.entry.js": [
		86655,
		"node_modules_ionic_core_dist_esm_ion-avatar_3_entry_js"
	],
	"./ion-back-button.entry.js": [
		44856,
		"common",
		"node_modules_ionic_core_dist_esm_ion-back-button_entry_js"
	],
	"./ion-backdrop.entry.js": [
		13059,
		"node_modules_ionic_core_dist_esm_ion-backdrop_entry_js"
	],
	"./ion-breadcrumb_2.entry.js": [
		58648,
		"common",
		"node_modules_ionic_core_dist_esm_ion-breadcrumb_2_entry_js"
	],
	"./ion-button_2.entry.js": [
		98308,
		"node_modules_ionic_core_dist_esm_ion-button_2_entry_js"
	],
	"./ion-card_5.entry.js": [
		44690,
		"node_modules_ionic_core_dist_esm_ion-card_5_entry_js"
	],
	"./ion-checkbox.entry.js": [
		64090,
		"node_modules_ionic_core_dist_esm_ion-checkbox_entry_js"
	],
	"./ion-chip.entry.js": [
		36214,
		"node_modules_ionic_core_dist_esm_ion-chip_entry_js"
	],
	"./ion-col_3.entry.js": [
		69447,
		"node_modules_ionic_core_dist_esm_ion-col_3_entry_js"
	],
	"./ion-datetime-button.entry.js": [
		17950,
		"default-node_modules_ionic_core_dist_esm_data-caf38df0_js-node_modules_ionic_core_dist_esm_th-d3ab8e",
		"node_modules_ionic_core_dist_esm_ion-datetime-button_entry_js"
	],
	"./ion-datetime_3.entry.js": [
		79689,
		"default-node_modules_ionic_core_dist_esm_data-caf38df0_js-node_modules_ionic_core_dist_esm_th-d3ab8e",
		"common",
		"node_modules_ionic_core_dist_esm_ion-datetime_3_entry_js"
	],
	"./ion-fab_3.entry.js": [
		18840,
		"common",
		"node_modules_ionic_core_dist_esm_ion-fab_3_entry_js"
	],
	"./ion-img.entry.js": [
		40749,
		"node_modules_ionic_core_dist_esm_ion-img_entry_js"
	],
	"./ion-infinite-scroll_2.entry.js": [
		69667,
		"common",
		"node_modules_ionic_core_dist_esm_ion-infinite-scroll_2_entry_js"
	],
	"./ion-input.entry.js": [
		83288,
		"common",
		"node_modules_ionic_core_dist_esm_ion-input_entry_js"
	],
	"./ion-item-option_3.entry.js": [
		35473,
		"common",
		"node_modules_ionic_core_dist_esm_ion-item-option_3_entry_js"
	],
	"./ion-item_8.entry.js": [
		53634,
		"common",
		"node_modules_ionic_core_dist_esm_ion-item_8_entry_js"
	],
	"./ion-loading.entry.js": [
		22855,
		"node_modules_ionic_core_dist_esm_ion-loading_entry_js"
	],
	"./ion-menu_3.entry.js": [
		495,
		"common",
		"node_modules_ionic_core_dist_esm_ion-menu_3_entry_js"
	],
	"./ion-modal.entry.js": [
		58737,
		"common",
		"node_modules_ionic_core_dist_esm_ion-modal_entry_js"
	],
	"./ion-nav_2.entry.js": [
		99632,
		"common",
		"node_modules_ionic_core_dist_esm_ion-nav_2_entry_js"
	],
	"./ion-picker-column-internal.entry.js": [
		54446,
		"common",
		"node_modules_ionic_core_dist_esm_ion-picker-column-internal_entry_js"
	],
	"./ion-picker-internal.entry.js": [
		32275,
		"node_modules_ionic_core_dist_esm_ion-picker-internal_entry_js"
	],
	"./ion-popover.entry.js": [
		48050,
		"common",
		"node_modules_ionic_core_dist_esm_ion-popover_entry_js"
	],
	"./ion-progress-bar.entry.js": [
		18994,
		"node_modules_ionic_core_dist_esm_ion-progress-bar_entry_js"
	],
	"./ion-radio_2.entry.js": [
		23592,
		"node_modules_ionic_core_dist_esm_ion-radio_2_entry_js"
	],
	"./ion-range.entry.js": [
		35454,
		"common",
		"node_modules_ionic_core_dist_esm_ion-range_entry_js"
	],
	"./ion-refresher_2.entry.js": [
		290,
		"common",
		"node_modules_ionic_core_dist_esm_ion-refresher_2_entry_js"
	],
	"./ion-reorder_2.entry.js": [
		92666,
		"common",
		"node_modules_ionic_core_dist_esm_ion-reorder_2_entry_js"
	],
	"./ion-ripple-effect.entry.js": [
		64816,
		"node_modules_ionic_core_dist_esm_ion-ripple-effect_entry_js"
	],
	"./ion-route_4.entry.js": [
		45534,
		"node_modules_ionic_core_dist_esm_ion-route_4_entry_js"
	],
	"./ion-searchbar.entry.js": [
		94902,
		"common",
		"node_modules_ionic_core_dist_esm_ion-searchbar_entry_js"
	],
	"./ion-segment_2.entry.js": [
		91938,
		"common",
		"node_modules_ionic_core_dist_esm_ion-segment_2_entry_js"
	],
	"./ion-select_3.entry.js": [
		78179,
		"node_modules_ionic_core_dist_esm_ion-select_3_entry_js"
	],
	"./ion-slide_2.entry.js": [
		90668,
		"node_modules_ionic_core_dist_esm_ion-slide_2_entry_js"
	],
	"./ion-spinner.entry.js": [
		61624,
		"common",
		"node_modules_ionic_core_dist_esm_ion-spinner_entry_js"
	],
	"./ion-split-pane.entry.js": [
		19989,
		"node_modules_ionic_core_dist_esm_ion-split-pane_entry_js"
	],
	"./ion-tab-bar_2.entry.js": [
		28902,
		"common",
		"node_modules_ionic_core_dist_esm_ion-tab-bar_2_entry_js"
	],
	"./ion-tab_2.entry.js": [
		70199,
		"common",
		"node_modules_ionic_core_dist_esm_ion-tab_2_entry_js"
	],
	"./ion-text.entry.js": [
		48395,
		"node_modules_ionic_core_dist_esm_ion-text_entry_js"
	],
	"./ion-textarea.entry.js": [
		96357,
		"node_modules_ionic_core_dist_esm_ion-textarea_entry_js"
	],
	"./ion-toast.entry.js": [
		38268,
		"node_modules_ionic_core_dist_esm_ion-toast_entry_js"
	],
	"./ion-toggle.entry.js": [
		15269,
		"common",
		"node_modules_ionic_core_dist_esm_ion-toggle_entry_js"
	],
	"./ion-virtual-scroll.entry.js": [
		32875,
		"node_modules_ionic_core_dist_esm_ion-virtual-scroll_entry_js"
	]
};
function webpackAsyncContext(req) {
	if(!__webpack_require__.o(map, req)) {
		return Promise.resolve().then(() => {
			var e = new Error("Cannot find module '" + req + "'");
			e.code = 'MODULE_NOT_FOUND';
			throw e;
		});
	}

	var ids = map[req], id = ids[0];
	return Promise.all(ids.slice(1).map(__webpack_require__.e)).then(() => {
		return __webpack_require__(id);
	});
}
webpackAsyncContext.keys = () => (Object.keys(map));
webpackAsyncContext.id = 50863;
module.exports = webpackAsyncContext;

/***/ }),

/***/ 79259:
/*!***********************************************!*\
  !*** ./src/app/app.component.scss?ngResource ***!
  \***********************************************/
/***/ ((module) => {

"use strict";
module.exports = "ion-menu ion-content {\n  --background: var(--ion-item-background, var(--ion-background-color, #fff));\n}\n\nion-menu.md ion-content {\n  --padding-start: 8px;\n  --padding-end: 8px;\n  --padding-top: 20px;\n  --padding-bottom: 20px;\n}\n\nion-menu.md ion-list {\n  padding: 20px 0;\n}\n\nion-menu.md ion-note {\n  margin-bottom: 30px;\n}\n\nion-menu.md ion-list-header,\nion-menu.md ion-note {\n  padding-left: 10px;\n}\n\nion-menu.md ion-list#inbox-list {\n  border-bottom: 1px solid var(--ion-color-step-150, #d7d8da);\n}\n\nion-menu.md ion-list#inbox-list ion-list-header {\n  font-size: 22px;\n  font-weight: 600;\n  min-height: 20px;\n}\n\nion-menu.md ion-list#labels-list ion-list-header {\n  font-size: 16px;\n  margin-bottom: 18px;\n  color: #757575;\n  min-height: 26px;\n}\n\nion-menu.md ion-item {\n  --padding-start: 10px;\n  --padding-end: 10px;\n  border-radius: 4px;\n}\n\nion-menu.md ion-item.selected {\n  --background: rgba(var(--ion-color-primary-rgb), 0.14);\n}\n\nion-menu.md ion-item.selected ion-icon {\n  color: var(--ion-color-primary);\n}\n\nion-menu.md ion-item ion-icon {\n  color: #616e7e;\n}\n\nion-menu.md ion-item ion-label {\n  font-weight: 500;\n}\n\nion-menu.ios ion-content {\n  --padding-bottom: 20px;\n}\n\nion-menu.ios ion-list {\n  padding: 20px 0 0 0;\n}\n\nion-menu.ios ion-note {\n  line-height: 24px;\n  margin-bottom: 20px;\n}\n\nion-menu.ios ion-item {\n  --padding-start: 16px;\n  --padding-end: 16px;\n  --min-height: 50px;\n}\n\nion-menu.ios ion-item.selected ion-icon {\n  color: var(--ion-color-primary);\n}\n\nion-menu.ios ion-item ion-icon {\n  font-size: 24px;\n  color: #73849a;\n}\n\nion-menu.ios ion-list#labels-list ion-list-header {\n  margin-bottom: 8px;\n}\n\nion-menu.ios ion-list-header,\nion-menu.ios ion-note {\n  padding-left: 16px;\n  padding-right: 16px;\n}\n\nion-menu.ios ion-note {\n  margin-bottom: 8px;\n}\n\nion-note {\n  display: inline-block;\n  font-size: 16px;\n  color: var(--ion-color-medium-shade);\n}\n\nion-item.selected {\n  --color: var(--ion-color-primary);\n}\n/*# sourceMappingURL=data:application/json;base64,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 */";

/***/ }),

/***/ 140:
/*!************************************************!*\
  !*** ./src/app/menu/menu.page.scss?ngResource ***!
  \************************************************/
/***/ ((module) => {

"use strict";
module.exports = "ion-content {\n  --background:var(--ion-color-light);\n}\n\nion-list {\n  border-radius: 10px;\n  font-size: 14px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm1lbnUucGFnZS5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBRUUsbUNBQUE7QUFBRjs7QUFHQTtFQUVFLG1CQUFBO0VBQ0EsZUFBQTtBQURGIiwiZmlsZSI6Im1lbnUucGFnZS5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiaW9uLWNvbnRlbnRcbntcbiAgLS1iYWNrZ3JvdW5kOnZhcigtLWlvbi1jb2xvci1saWdodCk7XG59XG5cbmlvbi1saXN0XG57XG4gIGJvcmRlci1yYWRpdXM6MTBweDtcbiAgZm9udC1zaXplOjE0cHhcbn0iXX0= */";

/***/ }),

/***/ 76438:
/*!************************************************!*\
  !*** ./src/app/note/note.page.scss?ngResource ***!
  \************************************************/
/***/ ((module) => {

"use strict";
module.exports = "ion-item {\n  border-bottom: 1px dotted gray;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm5vdGUucGFnZS5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBRUMsOEJBQUE7QUFBRCIsImZpbGUiOiJub3RlLnBhZ2Uuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbImlvbi1pdGVtXG57XG5cdGJvcmRlci1ib3R0b206MXB4IGRvdHRlZCBncmF5O1xufSJdfQ== */";

/***/ }),

/***/ 9111:
/*!**************************************************!*\
  !*** ./src/app/offer/offer.page.scss?ngResource ***!
  \**************************************************/
/***/ ((module) => {

"use strict";
module.exports = "\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJvZmZlci5wYWdlLnNjc3MifQ== */";

/***/ }),

/***/ 67710:
/*!****************************************************!*\
  !*** ./src/app/option/option.page.scss?ngResource ***!
  \****************************************************/
/***/ ((module) => {

"use strict";
module.exports = "ion-content {\n  --background:#efeff4 ;\n}\n\nion-list {\n  border-radius: 10px;\n  margin-bottom: 5%;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIm9wdGlvbi5wYWdlLnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFFRSxxQkFBQTtBQUFGOztBQUdBO0VBRUUsbUJBQUE7RUFDQSxpQkFBQTtBQURGIiwiZmlsZSI6Im9wdGlvbi5wYWdlLnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyJpb24tY29udGVudFxue1xuICAtLWJhY2tncm91bmQ6I2VmZWZmNFxufVxuXG5pb24tbGlzdFxue1xuICBib3JkZXItcmFkaXVzOjEwcHg7XG4gIG1hcmdpbi1ib3R0b206NSVcbn0iXX0= */";

/***/ }),

/***/ 19529:
/*!******************************************************!*\
  !*** ./src/app/payment/payment.page.scss?ngResource ***!
  \******************************************************/
/***/ ((module) => {

"use strict";
module.exports = "ion-row {\n  text-align: left;\n  border: 1px solid #f3f3f3;\n  padding: 0px 10px;\n  margin-top: 10px;\n  background: white;\n  border-radius: 10px;\n}\n\nimg {\n  width: 50px;\n}\n\n.amount {\n  font-size: 14px;\n  margin-top: 8px;\n  display: block;\n}\n\nion-item {\n  border: 1px solid #e1e0e0;\n  border-radius: 10px;\n}\n\n.ecash {\n  border: 1px solid #e3e3e3;\n  border-radius: 10px;\n  padding: 10px 10px;\n}\n\nion-content {\n  --background:#efeff4 ;\n}\n\nion-list {\n  border-radius: 10px;\n  padding: 10px 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBheW1lbnQucGFnZS5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBRUMsZ0JBQUE7RUFDQSx5QkFBQTtFQUNBLGlCQUFBO0VBQ0EsZ0JBQUE7RUFDQSxpQkFBQTtFQUNBLG1CQUFBO0FBQUQ7O0FBR0E7RUFFQyxXQUFBO0FBREQ7O0FBSUE7RUFFQyxlQUFBO0VBQ0EsZUFBQTtFQUNBLGNBQUE7QUFGRDs7QUFLQTtFQUVFLHlCQUFBO0VBQ0EsbUJBQUE7QUFIRjs7QUFNQTtFQUVDLHlCQUFBO0VBQ0csbUJBQUE7RUFDQSxrQkFBQTtBQUpKOztBQU9BO0VBRUUscUJBQUE7QUFMRjs7QUFRQTtFQUVFLG1CQUFBO0VBQ0Esa0JBQUE7QUFORiIsImZpbGUiOiJwYXltZW50LnBhZ2Uuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbImlvbi1yb3dcbntcblx0dGV4dC1hbGlnbjpsZWZ0O1xuXHRib3JkZXI6MXB4IHNvbGlkICNmM2YzZjM7XG5cdHBhZGRpbmc6MHB4IDEwcHg7XG5cdG1hcmdpbi10b3A6MTBweDtcblx0YmFja2dyb3VuZDp3aGl0ZTtcblx0Ym9yZGVyLXJhZGl1czoxMHB4XG59XG5cbmltZ1xue1xuXHR3aWR0aDo1MHB4XG59XG5cbi5hbW91bnRcbntcblx0Zm9udC1zaXplOjE0cHg7XG5cdG1hcmdpbi10b3A6OHB4O1xuXHRkaXNwbGF5OiBibG9jaztcbn1cblxuaW9uLWl0ZW1cbntcbiAgYm9yZGVyOiAxcHggc29saWQgI2UxZTBlMDtcbiAgYm9yZGVyLXJhZGl1czogMTBweDtcbn1cblxuLmVjYXNoXG57XG5cdGJvcmRlcjogMXB4IHNvbGlkICNlM2UzZTM7XG4gICAgYm9yZGVyLXJhZGl1czogMTBweDtcbiAgICBwYWRkaW5nOiAxMHB4IDEwcHg7XG59XG5cbmlvbi1jb250ZW50XG57XG4gIC0tYmFja2dyb3VuZDojZWZlZmY0XG59XG5cbmlvbi1saXN0XG57XG4gIGJvcmRlci1yYWRpdXM6MTBweDtcbiAgcGFkZGluZzoxMHB4IDEwcHhcbn0iXX0= */";

/***/ }),

/***/ 63920:
/*!********************************************************************!*\
  !*** ./src/app/select-address/select-address.page.scss?ngResource ***!
  \********************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "ion-item {\n  border: 1px solid #e1e0e0;\n  border-radius: 10px;\n  margin-bottom: 10px;\n}\n\nion-content {\n  --background:#efeff4 ;\n}\n\nion-list {\n  border-radius: 10px;\n  padding: 10px 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNlbGVjdC1hZGRyZXNzLnBhZ2Uuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQTtFQUVFLHlCQUFBO0VBQ0EsbUJBQUE7RUFDQSxtQkFBQTtBQUFGOztBQUdBO0VBRUUscUJBQUE7QUFERjs7QUFJQTtFQUVFLG1CQUFBO0VBQ0Esa0JBQUE7QUFGRiIsImZpbGUiOiJzZWxlY3QtYWRkcmVzcy5wYWdlLnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyJpb24taXRlbVxue1xuICBib3JkZXI6IDFweCBzb2xpZCAjZTFlMGUwO1xuICBib3JkZXItcmFkaXVzOiAxMHB4O1xuICBtYXJnaW4tYm90dG9tOjEwcHhcbn1cblxuaW9uLWNvbnRlbnRcbntcbiAgLS1iYWNrZ3JvdW5kOiNlZmVmZjRcbn1cblxuaW9uLWxpc3RcbntcbiAgYm9yZGVyLXJhZGl1czoxMHB4O1xuICBwYWRkaW5nOjEwcHggMTBweFxufSJdfQ== */";

/***/ }),

/***/ 50910:
/*!**********************************************!*\
  !*** ./src/app/tip/tip.page.scss?ngResource ***!
  \**********************************************/
/***/ ((module) => {

"use strict";
module.exports = ".horizontal-scrollable {\n  padding: 15px;\n  white-space: nowrap;\n  overflow-x: scroll;\n  overflow-y: hide;\n  -webkit-overflow-scrolling: touch;\n  scrollbar-width: none;\n  display: flex;\n  flex-wrap: nowrap;\n}\n\n.year-tag {\n  border: 1px solid gray;\n  border-radius: 10px;\n  font-size: 12px;\n  color: black;\n  padding: 5px 15px;\n  margin-right: 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInRpcC5wYWdlLnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFDRSxhQUFBO0VBQ0EsbUJBQUE7RUFDQSxrQkFBQTtFQUNBLGdCQUFBO0VBQ0EsaUNBQUE7RUFDQSxxQkFBQTtFQUNBLGFBQUE7RUFDQSxpQkFBQTtBQUNGOztBQUVBO0VBRUUsc0JBQUE7RUFDQSxtQkFBQTtFQUNBLGVBQUE7RUFDQSxZQUFBO0VBQ0EsaUJBQUE7RUFDQSxrQkFBQTtBQUFGIiwiZmlsZSI6InRpcC5wYWdlLnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuaG9yaXpvbnRhbC1zY3JvbGxhYmxlIHtcbiAgcGFkZGluZzogMTVweDtcbiAgd2hpdGUtc3BhY2U6IG5vd3JhcDtcbiAgb3ZlcmZsb3cteDogc2Nyb2xsO1xuICBvdmVyZmxvdy15OiBoaWRlO1xuICAtd2Via2l0LW92ZXJmbG93LXNjcm9sbGluZzogdG91Y2g7XG4gIHNjcm9sbGJhci13aWR0aDogbm9uZTtcbiAgZGlzcGxheTogZmxleDtcbiAgZmxleC13cmFwOiBub3dyYXA7XG59XG5cbi55ZWFyLXRhZyB7XG4gIFxuICBib3JkZXI6IDFweCBzb2xpZCBncmF5O1xuICBib3JkZXItcmFkaXVzOiAxMHB4O1xuICBmb250LXNpemU6IDEycHg7XG4gIGNvbG9yOiBibGFjaztcbiAgcGFkZGluZzogNXB4IDE1cHg7XG4gIG1hcmdpbi1yaWdodDogMTBweDtcbn0iXX0= */";

/***/ }),

/***/ 33383:
/*!***********************************************!*\
  !*** ./src/app/app.component.html?ngResource ***!
  \***********************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-app dir=\"{{ dir }}\">\n  <ion-split-pane contentId=\"main-content\" when=\"false\">\n    <ion-menu contentId=\"main-content\" type=\"push\" side=\"end\" swipeGesture=\"false\">\n\n      <ion-menu-toggle><ion-icon name=\"arrow-back-outline\" style=\"font-size: 28px;padding: 10px 10px;\"></ion-icon></ion-menu-toggle>\n\n      <ion-content *ngIf=\"text\">\n        <ion-list id=\"inbox-list\">\n          <ion-list-header *ngIf=\"userData && userData.name\">{{ userData.name }}</ion-list-header>\n          <ion-note *ngIf=\"userData && userData.name\">{{ userData.phone }}</ion-note>\n\n          <ion-list-header *ngIf=\"!userData\">{{ text.menu_welcome }}</ion-list-header>\n          <ion-note *ngIf=\"!userData\">&nbsp;</ion-note>\n\n          <ion-menu-toggle auto-hide=\"false\" *ngFor=\"let p of appPages; let i = index\">\n            <ion-item routerDirection=\"forward\" [routerLink]=\"[p.url]\" lines=\"none\" detail=\"false\" routerLinkActive=\"selected\">\n              <ion-icon slot=\"start\" [ios]=\"p.icon + '-outline'\" [md]=\"p.icon + '-sharp'\"></ion-icon>\n              <ion-label>{{ p.title }}</ion-label>\n            </ion-item>\n          </ion-menu-toggle>\n        </ion-list>\n        \n      </ion-content>\n\n      <ion-footer class=\"ion-no-border\" *ngIf=\"!userData && text\">\n      <ion-toolbar color=\"light\">\n\n      <ion-menu-toggle auto-hide=\"false\">\n        <ion-row>\n        <ion-col size=\"6\"><ion-button routerLink=\"/login\" routerDirection=\"forward\" expand=\"block\" color=\"primary\" mode=\"ios\"><ion-icon name=\"log-in-outline\"></ion-icon> {{ text.login_button }}</ion-button></ion-col>\n        <ion-col size=\"6\"><ion-button routerLink=\"/signup\" routerDirection=\"forward\" expand=\"block\" color=\"dark\" mode=\"ios\"><ion-icon name=\"create-outline\"></ion-icon> {{ text.sign_btn }}</ion-button></ion-col>\n        </ion-row>\n      </ion-menu-toggle>\n\n      </ion-toolbar>\n      </ion-footer>\n\n    </ion-menu>\n    <ion-router-outlet id=\"main-content\" dir=\"{{ dir }}\"></ion-router-outlet>\n  </ion-split-pane>\n</ion-app>\n";

/***/ }),

/***/ 31757:
/*!************************************************!*\
  !*** ./src/app/menu/menu.page.html?ngResource ***!
  \************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-content class=\"ion-padding\" *ngIf=\"text\">\n\n<ion-icon name=\"arrow-back-outline\" style=\"font-size: 25px;\" (click)=\"close()\"></ion-icon>\n\n<div *ngIf=\"!user\">\n<h3>{{ text.your_profile }}</h3>\n\n<p style=\"margin-top: -2%;color:gray\">{{ text.menu_desc }}</p>\n\n<ion-button expand=\"block\" fill=\"outline\" mode=\"ios\" routerLink=\"/login\" routerDirection=\"forward\" (click)=\"close()\">{{ text.conti }}</ion-button>\n</div>\n\n<div *ngIf=\"user && user.id\">\n<h3 style=\"margin-bottom: -1%\">{{ user.name }} <a style=\"float:right;font-size:14px\" routerLink=\"/account\" routerDirection=\"forward\" (click)=\"close()\">{{ text.view_account }}</a></h3>\n<small style=\"color:gray\">{{ user.email }}</small>\n\n</div>\n\n<br>\n\n<ion-list>\n<ion-list-header>\n  <ion-label style=\"font-size: 14px;color:gray\">{{ text.menu_title }}</ion-label>\n</ion-list-header>\n\n<ion-item detail routerLink=\"/done\" routerDirection=\"forward\" (click)=\"close()\">\n  <ion-label>\n   {{ text.running_order }}\n  </ion-label>\n  <ion-icon name=\"stats-chart-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n\n<ion-item detail routerLink=\"/my\" routerDirection=\"forward\" (click)=\"close()\">\n  <ion-label>\n   {{ text.menu_my }}\n  </ion-label>\n  <ion-icon name=\"cart-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n\n<ion-item detail routerLink=\"/account\" routerDirection=\"forward\" (click)=\"close()\">\n  <ion-label>\n  {{ text.menu_my_account }}\n  </ion-label>\n  <ion-icon name=\"person-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n\n<ion-item detail routerLink=\"/lang\" routerDirection=\"forward\" (click)=\"close()\">\n  <ion-label>\n   {{ text.lang_setting }}\n  </ion-label>\n  <ion-icon name=\"flag-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n\n<ion-item detail routerLink=\"/about\" routerDirection=\"forward\" (click)=\"close()\">\n  <ion-label>\n   {{ text.menu_about }}\n  </ion-label>\n  <ion-icon name=\"information-circle-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n\n<ion-item detail routerLink=\"/faq\" routerDirection=\"forward\"  (click)=\"close()\">\n  <ion-label>\n  {{ text.menu_faq }}\n  </ion-label>\n  <ion-icon name=\"create-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n\n<ion-item detail routerLink=\"/contact\" routerDirection=\"forward\" (click)=\"close()\">\n  <ion-label>\n   {{ text.menu_contact }}\n  </ion-label>\n  <ion-icon name=\"mail-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n\n<ion-item detail  lines=\"none\" (click)=\"logout()\">\n  <ion-label>\n   {{ text.logout }}\n  </ion-label>\n  <ion-icon name=\"log-out-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n\n</ion-list>\n\n</ion-content>\n";

/***/ }),

/***/ 23528:
/*!************************************************!*\
  !*** ./src/app/note/note.page.html?ngResource ***!
  \************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-content class=\"ion-padding\" *ngIf=\"text\">\n\n<ion-item lines=\"none\">\n  <ion-label position=\"floating\" style=\"font-size:12px\">{{ text.write_note }}</ion-label>\n  <ion-input type=\"text\" required name=\"notes\" [(ngModel)]=\"notes\"></ion-input>\n</ion-item>\n<br>\n<ion-button expand=\"block\" mode=\"ios\" (click)=\"saveData()\">{{ text.conti }}</ion-button>\n\n</ion-content>\n";

/***/ }),

/***/ 69164:
/*!**************************************************!*\
  !*** ./src/app/offer/offer.page.html?ngResource ***!
  \**************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-content *ngIf=\"data && text\" class=\"ion-padding\">\n\n<h1>{{ text.select_offer }}</h1>\n<br>\n<ion-list *ngIf=\"data.length > 0\">\n\n  <ion-item *ngFor=\"let offer of data\">\n    <ion-label>{{ offer.code }}<br><small style=\"font-size: 11px;color: gray\">{{ offer.desc }}</small>\n\n    <ion-button size=\"small\" shape=\"round\" fill=\"outline\" style=\"float: right;margin-top: -17px\" (click)=\"applyNow(offer.id)\">{{ text.apply }}</ion-button>\n\n    </ion-label>\n  </ion-item>\n  </ion-list>\n\n<p *ngIf=\"data.length == 0\" style=\"text-align: center;padding: 10px 10px;font-size: 11px;color:gray;line-height: 2;margin-top: 25%\">{{ text.no_offer }}</p>\n\n</ion-content>\n\n<ion-footer class=\"ion-no-border\" *ngIf=\"data && text\">\n<ion-toolbar color=\"medium\">\n<ion-button mode=\"ios\" expand=\"block\" size=\"medium\" (click)=\"closeModal()\" style=\"width: 90%;margin-left: 5%;margin-bottom:15px\">{{ text.close  }}</ion-button>\n</ion-toolbar>\n</ion-footer>";

/***/ }),

/***/ 4903:
/*!****************************************************!*\
  !*** ./src/app/option/option.page.html?ngResource ***!
  \****************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-header class=\"ion-no-border\">\n<ion-toolbar color=\"light\">\n<ion-buttons slot=\"start\" (click)=\"closeModal()\">\n<ion-icon name=\"arrow-back-outline\" style=\"font-size: 25px;margin-left: 13px;\"></ion-icon>\n</ion-buttons>\n</ion-toolbar>\n</ion-header>\n\n<ion-content *ngIf=\"text\" class=\"ion-padding\">\n\n<ion-card mode=\"ios\" style=\"width: 100%;margin: auto;\">\n<img src=\"{{ item.img }}\">\n\n<ion-card-content style=\"padding: 10px;\">\n<b style=\"color:black;\">{{ item.name }}</b>\n\n<small style=\"display: block;\">{{ item.desc }}</small>\n\n</ion-card-content>\n\n</ion-card>\n\n<div >\n<ion-list style=\"width: 100% !important;margin-top:5%;\">\n<ion-list-header>\n{{ text.select_size }}\n</ion-list-header>\n<ion-radio-group mode=\"md\">\n<ion-item *ngIf=\"item.s_price\">\n<ion-label>{{ item.unit1 }} <span style=\"float: right\">{{ currency }}{{ item.s_price }}</span></ion-label>\n<ion-radio slot=\"start\" color=\"primary\" value=\"small\" (click)=\"selectItem(1,item.s_price)\"></ion-radio>\n</ion-item>\n\n<ion-item *ngIf=\"item.m_price\">\n<ion-label>{{ item.unit2 }} <span style=\"float: right\">{{ currency }}{{ item.m_price }}</span></ion-label>\n<ion-radio slot=\"start\" color=\"primary\" value=\"m\" (click)=\"selectItem(2,item.m_price)\"></ion-radio>\n</ion-item>\n\n<ion-item *ngIf=\"item.l_price\">\n<ion-label>{{ item.unit3 }} <span style=\"float: right\">{{ currency }}{{ item.l_price }}</span></ion-label>\n<ion-radio slot=\"start\" color=\"primary\" value=\"l\" (click)=\"selectItem(3,item.l_price)\"></ion-radio>\n</ion-item>\n</ion-radio-group>\n</ion-list>\n\n<span *ngIf=\"item.addon.length > 0\">\n<ion-list *ngFor=\"let addonCate of item.addon\" style=\"width: 100% !important\">\n<br>\n<span style=\"padding: 10px 10px\">{{ addonCate.name }} <small style=\"color:red;float: right;margin-right: 10px\" *ngIf=\"addonCate.req == 1\">({{ text.req_addon }})</small></span>\n\n<span *ngIf=\"addonCate.type == 0\">\n<ion-item *ngFor=\"let addon of addonCate.item\">\n<ion-label>{{ addon.name }} <span style=\"float: right\">{{ currency }}{{ addon.price }}</span></ion-label>\n<ion-checkbox color=\"primary\" slot=\"start\" (ionChange)=\"addonSelect(addon.id,0)\" mode=\"md\"></ion-checkbox>\n</ion-item>\n</span>\n\n<span *ngIf=\"addonCate.type == 1\">\n<ion-radio-group mode=\"md\">\n\n<ion-item *ngFor=\"let addon of addonCate.item\">\n<ion-label>{{ addon.name }} <span style=\"float: right\">{{ currency }}{{ addon.price }}</span></ion-label>\n<ion-radio slot=\"start\" value=\"{{ addon.id }}\" (click)=\"addonSelect(addon.id,1,addonCate.item)\"></ion-radio>\n</ion-item>\n\n</ion-radio-group>\n</span>\n\n</ion-list>\n</span>\n</div>\n\n<ion-button expand=\"block\" mode=\"ios\" style=\"width: 90%;margin-left:5%;margin-bottom:15px\" [disabled]=\"!itemID || hasReq() == false\" (click)=\"addToCart()\">{{ text.add_cart }}</ion-button>\n\n</ion-content>\n";

/***/ }),

/***/ 7916:
/*!******************************************************!*\
  !*** ./src/app/payment/payment.page.html?ngResource ***!
  \******************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-content class=\"ion-padding\" *ngIf=\"text\" #content>\n\n<a (click)=\"closeModal()\" style=\"float:right\">{{ text.close }}</a>\n<br>\n\n<h2 style=\"margin-bottom: 22px\">{{ text.payment_method }} <span class=\"amount storeName\"> {{ setting.currency }}{{ total }}</span></h2>\n\n<ion-item lines=\"none\">\n<ion-label style=\"font-size: 13px\">{{ text.ecash_desc }} <span style=\"float: right;font-size: 13px\">{{ wallet }}</span>\n</ion-label>\n<ion-checkbox slot=\"start\" mode=\"ios\" (click)=\"useEcash()\"></ion-checkbox>\n</ion-item>\n\n<ion-row (click)=\"setPayment(1)\" *ngIf=\"setting.cod == 0\">\n<ion-col size=\"3\"><img src=\"assets/pay_cod.png\"></ion-col>\n<ion-col size=\"9\" style=\"margin-top: 13px;\" class=\"storeName\">{{ text.cod }}\n<ion-icon name=\"checkmark-circle\" style=\"float: right;font-size: 25px;\" color=\"primary\" *ngIf=\"payment == 1\"></ion-icon>\n</ion-col>\n</ion-row>\n\n\n<ion-row (click)=\"setPayment(2)\" *ngIf=\"setting.stripe_key\">\n<ion-col size=\"3\"><img src=\"assets/pay_stripe.png\"></ion-col>\n<ion-col size=\"9\" style=\"margin-top: 13px;\" class=\"storeName\">{{ text.stripe }}\n<ion-icon name=\"checkmark-circle\" style=\"float: right;font-size: 25px;\" color=\"primary\" *ngIf=\"payment == 2\"></ion-icon>\n</ion-col>\n</ion-row>\n\n<ion-row (click)=\"setPayment(3)\" *ngIf=\"setting.razor_key\">\n<ion-col size=\"3\"><img src=\"assets/pay_upi.png\"></ion-col>\n<ion-col size=\"9\" style=\"margin-top: 13px;\" class=\"storeName\">{{ text.razor }}\n<ion-icon name=\"checkmark-circle\" style=\"float: right;font-size: 25px;\" color=\"primary\" *ngIf=\"payment == 3\"></ion-icon>\n</ion-col>\n</ion-row>\n\n<ion-row (click)=\"setPayment(4)\" *ngIf=\"setting.paypal_id\">\n<ion-col size=\"3\"><img src=\"assets/pay_paypal.png\"></ion-col>\n<ion-col size=\"9\" style=\"margin-top: 13px;\" class=\"storeName\">{{ text.pay_paypal }}\n<ion-icon name=\"checkmark-circle\" style=\"float: right;font-size: 25px;\" color=\"primary\" *ngIf=\"payment == 4\"></ion-icon>\n</ion-col>\n</ion-row>\n\n<ion-row (click)=\"setPayment(5)\" *ngIf=\"setting.paystack_id\">\n<ion-col size=\"3\"><img src=\"assets/ps.png\"></ion-col>\n<ion-col size=\"9\" style=\"margin-top: 13px;\" class=\"storeName\">{{ text.pay_paystack }}\n<ion-icon name=\"checkmark-circle\" style=\"float: right;font-size: 25px;\" color=\"primary\" *ngIf=\"payment == 5\"></ion-icon>\n</ion-col>\n</ion-row>\n\n<ion-row (click)=\"setPayment(6)\">\n<ion-col size=\"3\"><img src=\"assets/fw.png\"></ion-col>\n<ion-col size=\"9\" style=\"margin-top: 13px;\" class=\"storeName\"> {{ text.fw }}\n<ion-icon name=\"checkmark-circle\" style=\"float: right;font-size: 25px;\" color=\"primary\" *ngIf=\"payment == 5\"></ion-icon>\n</ion-col>\n</ion-row>\n\n<ion-row *ngIf=\"stripeView\">\n<ion-col size=\"12\"><p>{{ text.stripe_title }}</p></ion-col>\n\n<ion-col size=\"12\">\n<ion-item lines=\"none\">\n  <ion-input type=\"tel\" [(ngModel)]=\"card_no\" name=\"card_no\" maxlength=\"16\" placeholder=\"{{ text.card_no }}\"></ion-input>\n</ion-item>\n</ion-col>\n\n<ion-col size=\"6\">\n<ion-row class=\"brdr\">\n<ion-col size=\"12\">\n<ion-select placeholder=\"{{ text.exp_month }}\" [(ngModel)]=\"exp_month\" name=\"exp_month\" required interface=\"action-sheet\" mode=\"md\">\n<ion-select-option value=\"01\">01</ion-select-option>\n<ion-select-option value=\"02\">02</ion-select-option>\n<ion-select-option value=\"03\">03</ion-select-option>\n<ion-select-option value=\"04\">04</ion-select-option>\n<ion-select-option value=\"05\">05</ion-select-option>\n<ion-select-option value=\"06\">06</ion-select-option>\n<ion-select-option value=\"07\">07</ion-select-option>\n<ion-select-option value=\"08\">08</ion-select-option>\n<ion-select-option value=\"09\">09</ion-select-option>\n<ion-select-option value=\"10\">10</ion-select-option>\n<ion-select-option value=\"11\">11</ion-select-option>\n<ion-select-option value=\"12\">12</ion-select-option>\n</ion-select>\n</ion-col>\n</ion-row>\n\n</ion-col>\n\n<ion-col size=\"6\">\n<ion-row class=\"brdr\">\n<ion-col size=\"12\">\n<ion-select placeholder=\"{{ text.exp_year }}\" [(ngModel)]=\"exp_year\" name=\"exp_year\" required interface=\"action-sheet\" mode=\"md\">\n<ion-select-option value=\"{{ y }}\" *ngFor=\"let y of years\">{{ y }}</ion-select-option>\n</ion-select>\n</ion-col>\n</ion-row>\n\n</ion-col>\n\n<ion-col size=\"6\" style=\"margin-bottom: 10px;\">\n<ion-item lines=\"none\">\n  <ion-input type=\"tel\" [(ngModel)]=\"cvv\" name=\"cvv\" placeholder=\"{{ text.cvv }}\" maxlength=\"3\"></ion-input>\n</ion-item>\n</ion-col>\n</ion-row>\n\n<br>\n<ion-button mode=\"ios\" expand=\"block\" *ngIf=\"allSet()\" (click)=\"applyNow()\">{{ text.conti }}</ion-button>\n\n</ion-content>\n";

/***/ }),

/***/ 56235:
/*!********************************************************************!*\
  !*** ./src/app/select-address/select-address.page.html?ngResource ***!
  \********************************************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-content class=\"ion-padding\" *ngIf=\"text\">\n\n<ion-icon name=\"arrow-back-outline\" style=\"font-size: 25px;\" (click)=\"closeModal()\"></ion-icon>\n<br>\n<h1>{{ text.select_delivery_address }}</h1>\n\n<ion-row style=\"margin-top: 20%\" *ngIf=\"!address || address.length == 0\">\n<ion-col size=\"12\"><p align=\"center\" style=\"font-size:13px\">{{ text.address_msg }}</p>\n\n\n<ion-button expand=\"block\" mode=\"ios\" routerLink=\"/address\" routerDirection=\"forward\" (click)=\"addAddress()\">{{ text.address_add }}</ion-button>\n\n\n</ion-col>\n</ion-row>\n\n\n<div style=\"overflow-y: scroll;height: 350px;margin-top: 15px;\">\n<ion-radio-group value=\"0\" [(ngModel)]=\"address_id\" name=\"address_id\">\n\n<ion-list *ngIf=\"address && address.length > 0\">\n\n<ion-item *ngFor=\"let a of address\" lines=\"none\">\n<ion-label>{{ a.address }}</ion-label>\n<ion-radio slot=\"start\" value=\"{{ a.id }}\" (click)=\"applyNow(a)\" mode=\"md\"></ion-radio>\n</ion-item>\n\n\n\n</ion-list>\n</ion-radio-group>\n</div>\n\n</ion-content>\n<ion-footer *ngIf=\"address && address.length > 0\">\n<div class=\"ion-padding\">\n<p align=\"center\">{{ text.want_new_address }}</p>\n<ion-button expand=\"block\" mode=\"ios\" routerLink=\"/address\" routerDirection=\"forward\" (click)=\"addAddress()\">{{ text.address_add }}</ion-button>\n</div>\n</ion-footer>";

/***/ }),

/***/ 67843:
/*!**********************************************!*\
  !*** ./src/app/tip/tip.page.html?ngResource ***!
  \**********************************************/
/***/ ((module) => {

"use strict";
module.exports = "<ion-content class=\"ion-padding\" *ngIf=\"text\">\n\n<p>{{ text.select_tip }}</p>\n<div *ngIf=\"tips && tips.length > 0\" class=\"tipBox\">\n<p></p>\n<div style=\"width: 350px;margin-top: -12px;\">\n  <div class=\"horizontal-scrollable year-list\">\n    <a class=\"year-tag-clear\" (click)=\"filterData(0)\" *ngIf=\"filterPress\"><ion-icon name=\"close-outline\"></ion-icon> {{ text.clear }}</a>\n    <a [class]=\"filterPress == 1 ? 'year-tag-select' : 'year-tag'\" (click)=\"applyNow(t)\" *ngFor=\"let t of tips\">{{ setting.currency }}{{ t }}</a>\n    <div class=\"year-tag\" style=\"opacity: 0; padding: 4px;\"></div>\n  </div>\n</div>\n</div>\n\n</ion-content>\n";

/***/ })

},
/******/ __webpack_require__ => { // webpackRuntimeModules
/******/ var __webpack_exec__ = (moduleId) => (__webpack_require__(__webpack_require__.s = moduleId))
/******/ __webpack_require__.O(0, ["vendor"], () => (__webpack_exec__(14431)));
/******/ var __webpack_exports__ = __webpack_require__.O();
/******/ }
]);
//# sourceMappingURL=main.js.map