"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_account_account_module_ts"],{

/***/ 34742:
/*!***************************************************!*\
  !*** ./src/app/account/account-routing.module.ts ***!
  \***************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccountPageRoutingModule": () => (/* binding */ AccountPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _account_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./account.page */ 97282);




const routes = [
    {
        path: '',
        component: _account_page__WEBPACK_IMPORTED_MODULE_0__.AccountPage
    }
];
let AccountPageRoutingModule = class AccountPageRoutingModule {
};
AccountPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], AccountPageRoutingModule);



/***/ }),

/***/ 63879:
/*!*******************************************!*\
  !*** ./src/app/account/account.module.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccountPageModule": () => (/* binding */ AccountPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _account_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./account-routing.module */ 34742);
/* harmony import */ var _account_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./account.page */ 97282);







let AccountPageModule = class AccountPageModule {
};
AccountPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _account_routing_module__WEBPACK_IMPORTED_MODULE_0__.AccountPageRoutingModule
        ],
        declarations: [_account_page__WEBPACK_IMPORTED_MODULE_1__.AccountPage]
    })
], AccountPageModule);



/***/ }),

/***/ 97282:
/*!*****************************************!*\
  !*** ./src/app/account/account.page.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AccountPage": () => (/* binding */ AccountPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _account_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./account.page.html?ngResource */ 59024);
/* harmony import */ var _account_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./account.page.scss?ngResource */ 8365);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 93819);







let AccountPage = class AccountPage {
    constructor(alertController, route, server, toastController, nav, loadingController) {
        this.alertController = alertController;
        this.route = route;
        this.server = server;
        this.toastController = toastController;
        this.nav = nav;
        this.loadingController = loadingController;
        this.slideOption = {
            initialSlide: 0,
            slidesPerView: 1.2,
            loop: false,
            centeredSlides: false,
            autoplay: false,
            speed: 500,
            spaceBetween: 0,
        };
        this.text = JSON.parse(localStorage.getItem('app_text'));
    }
    ngOnInit() {
    }
    ionViewWillEnter() {
        if (localStorage.getItem('user_id') == 'null' || !localStorage.getItem('user_id') || localStorage.getItem('user_id') == undefined) {
            this.presentToast(this.text.access_page);
            this.nav.navigateRoot('/home');
        }
        else {
            this.loadData();
        }
    }
    loadData() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                message: '',
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.userInfo(localStorage.getItem('user_id')).subscribe((response) => {
                this.data = response.data;
                localStorage.setItem('user_data', JSON.stringify(response.data));
                loading.dismiss();
            });
        });
    }
    presentToast(txt) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const toast = yield this.toastController.create({
                message: txt,
                duration: 3000,
                position: 'top',
                mode: 'ios',
                color: 'dark'
            });
            toast.present();
        });
    }
    logout() {
        localStorage.setItem('user_id', null);
        localStorage.setItem('user_data', null);
        this.nav.navigateRoot('/home');
    }
    copyData(c) {
        this.presentToast("Referral code copied successfully.");
    }
    presentAlert() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const alert = yield this.alertController.create({
                header: 'Are you sure?',
                message: 'Want to delete your account? Your all data, order history will be removed and you will not be able to undo.',
                mode: 'ios',
                buttons: [
                    {
                        text: 'Cancel',
                        role: 'cancel',
                        handler: () => {
                        },
                    },
                    {
                        text: 'Yes Delete!',
                        role: 'confirm',
                        handler: () => {
                            this.delete();
                        },
                    },
                ],
            });
            yield alert.present();
            const { role } = yield alert.onDidDismiss();
        });
    }
    delete() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                message: '',
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.delete().subscribe((response) => {
                this.presentToast("Account deleted successfully.");
                localStorage.setItem('user_id', null);
                localStorage.setItem('user_data', null);
                this.nav.navigateRoot('/home');
                loading.dismiss();
            });
        });
    }
};
AccountPage.ctorParameters = () => [
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.AlertController },
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_5__.ActivatedRoute },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.LoadingController }
];
AccountPage = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
        selector: 'app-account',
        template: _account_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_account_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], AccountPage);



/***/ }),

/***/ 8365:
/*!******************************************************!*\
  !*** ./src/app/account/account.page.scss?ngResource ***!
  \******************************************************/
/***/ ((module) => {

module.exports = ".accountHeader {\n  background-color: var(--ion-color-light);\n  height: 305px;\n}\n\nion-content {\n  --background:var(--ion-color-light);\n}\n\n.head {\n  background-color: white;\n  border-radius: 10px;\n  padding: 10px 10px;\n  margin: auto;\n}\n\n.topHead {\n  background-color: white;\n  border-radius: 10px;\n  padding: 10px 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImFjY291bnQucGFnZS5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBRUMsd0NBQUE7RUFDQSxhQUFBO0FBQUQ7O0FBR0E7RUFFQyxtQ0FBQTtBQUREOztBQUlBO0VBRUMsdUJBQUE7RUFDQSxtQkFBQTtFQUNBLGtCQUFBO0VBQ0EsWUFBQTtBQUZEOztBQUtBO0VBRUMsdUJBQUE7RUFDQSxtQkFBQTtFQUNBLGtCQUFBO0FBSEQiLCJmaWxlIjoiYWNjb3VudC5wYWdlLnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIuYWNjb3VudEhlYWRlclxue1xuXHRiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1pb24tY29sb3ItbGlnaHQpO1xuXHRoZWlnaHQ6MzA1cHg7XG59XG5cbmlvbi1jb250ZW50XG57XG5cdC0tYmFja2dyb3VuZDp2YXIoLS1pb24tY29sb3ItbGlnaHQpO1xufVxuXG4uaGVhZFxue1xuXHRiYWNrZ3JvdW5kLWNvbG9yOndoaXRlO1xuXHRib3JkZXItcmFkaXVzOjEwcHg7XG5cdHBhZGRpbmc6MTBweCAxMHB4O1xuXHRtYXJnaW46YXV0bztcbn1cblxuLnRvcEhlYWRcbntcblx0YmFja2dyb3VuZC1jb2xvcjogd2hpdGU7XG5cdGJvcmRlci1yYWRpdXM6IDEwcHg7XG5cdHBhZGRpbmc6IDEwcHggMTBweDtcbn0iXX0= */";

/***/ }),

/***/ 59024:
/*!******************************************************!*\
  !*** ./src/app/account/account.page.html?ngResource ***!
  \******************************************************/
/***/ ((module) => {

module.exports = "<ion-header class=\"ion-no-border\">\n<ion-toolbar color=\"light\">\n<ion-buttons slot=\"start\">\n<ion-back-button></ion-back-button>\n</ion-buttons>\n</ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n<div *ngIf=\"text && data\">\n\n<div class=\"topHead\">\n\n<ion-item lines=\"none\">\n<ion-label><h1>{{ data.name }}</h1><span style=\"display: block;margin-top: 5px;font-size: 14px;color:gray\">{{ data.email }}</span></ion-label>\n<ion-icon name=\"person-circle-outline\" slot=\"start\" style=\"font-size: 40px;\"></ion-icon>\n</ion-item>\n</div>\n\n<br>\n<ion-row class=\"topHead\">\n<ion-col size=\"12\">\n<b>{{ text.ecash }} <span style=\"float:right;color:#db4d4d\">{{ data.wallet }}</span></b>\n<small style=\"display:block;margin-top: 10px\">{{ text.ecash_use_desc }}</small>\n</ion-col>\n</ion-row>\n<br>\n<ion-row class=\"topHead\" *ngIf=\"data.rcode\">\n<ion-col size=\"12\">\n<b>{{ text.ref_code }} <span style=\"float:right;color:#db4d4d\">{{ data.rcode }}</span></b>\n<small style=\"display:block;margin-top: 10px\">{{ text.ref_code_desc }}</small>\n</ion-col>\n</ion-row>\n\n\n<br>\n<ion-list style=\"border-radius: 10px;\">\n<ion-item detail routerLink=\"/setting\" routerDirection=\"forward\">\n  <ion-label>\n   {{ text.account_title }}\n  </ion-label>\n  <ion-icon name=\"cog-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n\n<ion-item detail routerLink=\"/my\" routerDirection=\"forward\">\n  <ion-label>\n    {{ text.my }}\n  </ion-label>\n  <ion-icon name=\"cart-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n\n<ion-item detail routerLink=\"/lang\" routerDirection=\"forward\">\n  <ion-label>\n   {{ text.lang_setting }}\n  </ion-label>\n  <ion-icon name=\"flag-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n\n<ion-item routerLink=\"/city\" routerDirection=\"forward\" detail>\n  <ion-label>\n    {{ text.change_location }}\n  </ion-label>\n  <ion-icon name=\"location-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n\n<ion-item  detail routerLink=\"/home\" routerDirection=\"root\">\n  <ion-label>\n    {{ text.back_home }}\n  </ion-label>\n  <ion-icon name=\"home-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n\n<ion-item  detail (click)=\"presentAlert()\">\n  <ion-label>\n    Delete My Account\n  </ion-label>\n  <ion-icon name=\"trash-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n\n<ion-item  detail lines=\"none\" (click)=\"logout()\">\n  <ion-label>\n    {{ text.logout }}\n  </ion-label>\n  <ion-icon name=\"log-out-outline\" slot=\"start\"></ion-icon>\n</ion-item>\n</ion-list>\n</div>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_account_account_module_ts.js.map