"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_home_home_module_ts"],{

/***/ 52003:
/*!*********************************************!*\
  !*** ./src/app/home/home-routing.module.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HomePageRoutingModule": () => (/* binding */ HomePageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _home_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./home.page */ 62267);




const routes = [
    {
        path: '',
        component: _home_page__WEBPACK_IMPORTED_MODULE_0__.HomePage
    }
];
let HomePageRoutingModule = class HomePageRoutingModule {
};
HomePageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], HomePageRoutingModule);



/***/ }),

/***/ 3467:
/*!*************************************!*\
  !*** ./src/app/home/home.module.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HomePageModule": () => (/* binding */ HomePageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _home_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./home-routing.module */ 52003);
/* harmony import */ var _home_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./home.page */ 62267);







let HomePageModule = class HomePageModule {
};
HomePageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _home_routing_module__WEBPACK_IMPORTED_MODULE_0__.HomePageRoutingModule
        ],
        declarations: [_home_page__WEBPACK_IMPORTED_MODULE_1__.HomePage]
    })
], HomePageModule);



/***/ }),

/***/ 62267:
/*!***********************************!*\
  !*** ./src/app/home/home.page.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "HomePage": () => (/* binding */ HomePage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _home_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./home.page.html?ngResource */ 91670);
/* harmony import */ var _home_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./home.page.scss?ngResource */ 1020);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _menu_menu_page__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../menu/menu.page */ 25915);
/* harmony import */ var _awesome_cordova_plugins_native_page_transitions_ngx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @awesome-cordova-plugins/native-page-transitions/ngx */ 73635);









let HomePage = class HomePage {
    constructor(nativePageTransitions, actionSheetController, routerOutlet, modalController, activatedRoute, server, loadingController, alertController, platform, nav) {
        this.nativePageTransitions = nativePageTransitions;
        this.actionSheetController = actionSheetController;
        this.routerOutlet = routerOutlet;
        this.modalController = modalController;
        this.activatedRoute = activatedRoute;
        this.server = server;
        this.loadingController = loadingController;
        this.alertController = alertController;
        this.platform = platform;
        this.nav = nav;
        this.BannerOption = {
            initialSlide: 0,
            slidesPerView: 1,
            loop: false,
            centeredSlides: false,
            autoplay: true,
            speed: 500,
            spaceBetween: 20,
        };
        this.CateOption = {
            initialSlide: 0,
            slidesPerView: 4.2,
            loop: false,
            centeredSlides: false,
            autoplay: false,
            speed: 500,
            spaceBetween: 6,
        };
        this.TrendOption = {
            initialSlide: 1,
            slidesPerView: 2.2,
            loop: true,
            centeredSlides: false,
            autoplay: false,
            speed: 500,
            spaceBetween: 10,
        };
        this.RecoOption = {
            initialSlide: 0,
            slidesPerView: 2.0,
            loop: true,
            centeredSlides: false,
            autoplay: false,
            speed: 500,
            spaceBetween: -20,
        };
        this.sl = [1, 2, 3, 4, 5];
        this.fakeData = [1, 2, 3, 4, 5, 6, 7];
        this.storeData = [];
        this.store_type = 0;
        this.text = JSON.parse(localStorage.getItem('app_text'));
    }
    ngOnInit() {
        this.loadData();
    }
    cateData(cate) {
        this.cate_id = cate.id;
        this.cate_name = cate.name;
        this.data = null;
        this.loadData(cate.id);
    }
    clearCate() {
        this.cate_id = null;
        this.cate_name = null;
        this.data = null;
        this.loadData();
    }
    viewAll() {
        setTimeout(() => {
            const element = document.getElementById("store");
            element.scrollIntoView({ behavior: "smooth" });
        }, 200);
    }
    ionViewDidEnter() {
        this.address = localStorage.getItem('current_add');
        this.subscription = this.platform.backButton.subscribe(() => {
            this.presentAlertConfirm();
        });
    }
    ionViewWillLeave() {
        this.subscription.unsubscribe();
    }
    presentAlertConfirm() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            const alert = yield this.alertController.create({
                header: this.text.exit_app,
                message: this.text.exit_app_desc,
                buttons: [
                    {
                        text: this.text.s_canceled_order,
                        role: 'cancel',
                        cssClass: 'secondary',
                        handler: (blah) => {
                            console.log('Confirm Cancel: blah');
                        }
                    }, {
                        text: this.text.exit_app_confirm,
                        handler: () => {
                            navigator['app'].exitApp();
                        }
                    }
                ]
            });
            yield alert.present();
        });
    }
    setType(type) {
        this.storeData = [];
        this.store_type = type;
        for (var i = 0; i < this.data.store.length; i++) {
            if (this.store_type == 0) {
                if (this.data.store[i].delivery == 0) {
                    this.storeData.push(this.data.store[i]);
                }
            }
            else {
                if (this.data.store[i].dinein == 0) {
                    this.storeData.push(this.data.store[i]);
                }
            }
        }
        setTimeout(() => {
            const element = document.getElementById("store");
            element.scrollIntoView({ behavior: "smooth" });
        }, 200);
    }
    loadData(id = 0, load = false) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            this.server.homepage(id, this.store_type).subscribe((response) => {
                this.data = response.data;
                this.storeData = response.data.store;
                this.allData = response.data.store;
                console.log(this.data);
                if (id > 0 && this.data || load) {
                    setTimeout(() => {
                        const element = document.getElementById("store");
                        element.scrollIntoView({ behavior: "smooth" });
                    }, 200);
                }
                localStorage.setItem('app_text', JSON.stringify(response.data.text));
                localStorage.setItem('setting', JSON.stringify(response.data.setting));
                localStorage.setItem('country', JSON.stringify(response.data.country));
            });
        });
    }
    item(store) {
        if (store.open) {
            this.nav.navigateForward('/item/' + store.id + '/' + this.store_type);
        }
    }
    search() {
        localStorage.setItem('trend_data', JSON.stringify(this.data.trend));
        localStorage.setItem('all_data', JSON.stringify(this.data.search_data));
        this.nav.navigateForward('/search');
    }
    account() {
        if (localStorage.getItem('user_id') && localStorage.getItem('user_id') != "null") {
            this.nav.navigateForward('/account');
        }
        else {
            this.nav.navigateForward('/login');
        }
    }
    bannerLink(banner) {
        if (banner.link_to == 1) {
            this.nav.navigateForward('/item/' + banner.link_id);
        }
        else if (banner.link_to == 2) {
            this.data = null;
            this.loadData(banner.link_id);
        }
        else if (banner.link_to == 3) {
            window.open(banner.link_id, "_blank");
        }
    }
    filterData(id) {
        //this.stores = this.storeData;
        this.filterPress = this.filterPress == id ? 0 : id;
        if (id == 0) {
            this.filterPress = null;
        }
        else if (id == 1) {
            this.filterName = this.text.rating;
            this.storeData.sort((a, b) => {
                return parseFloat(b.rating) - parseFloat(a.rating);
            });
        }
        else if (id == 2) {
            this.filterName = this.text.nearest;
            this.storeData.sort((a, b) => {
                return parseFloat(a.km) - parseFloat(b.km);
            });
        }
        else if (id == 3) {
            this.filterName = this.text.new_arrival;
            this.storeData.sort((a, b) => {
                return parseFloat(b.id) - parseFloat(a.id);
            });
        }
        else {
            this.filterName = "Fastest Delivery";
            this.storeData.sort((a, b) => {
                return parseFloat(a.dtime) - parseFloat(b.dtime);
            });
        }
        setTimeout(() => {
            if (id > 0) {
                const element = document.getElementById("store");
                element.scrollIntoView({ behavior: "smooth" });
            }
        }, 500);
    }
    doRefresh(event) {
        console.log('Begin async operation');
        setTimeout(() => {
            this.loadData();
            event.target.complete();
        }, 2000);
    }
    showMenu() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            const modal = yield this.modalController.create({
                component: _menu_menu_page__WEBPACK_IMPORTED_MODULE_3__.MenuPage,
                animated: true,
                mode: 'ios',
                cssClass: 'my-custom-modal-css',
                backdropDismiss: true,
                swipeToClose: true,
                breakpoints: [1, 0.3, 0.5, 0.5],
                initialBreakpoint: 1,
                componentProps: {
                    'user': this.data.user,
                }
            });
            modal.onDidDismiss().then(data => {
                if (data.data.logout) {
                    this.loadData();
                }
            });
            return yield modal.present();
        });
    }
    presentActionSheet() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            const actionSheet = yield this.actionSheetController.create({
                header: 'Filter By',
                cssClass: 'my-custom-class',
                mode: 'md',
                buttons: [{
                        text: this.text.rating,
                        role: 'destructive',
                        icon: 'star-outline',
                        id: 'delete-button',
                        data: {
                            type: 'delete'
                        },
                        handler: () => {
                            this.filterData(1);
                        }
                    }, {
                        text: this.text.nearest,
                        icon: 'location-outline',
                        data: 10,
                        handler: () => {
                            this.filterData(2);
                        }
                    }, {
                        text: this.text.new_arrival,
                        icon: 'checkmark-done-outline',
                        data: 'Data value',
                        handler: () => {
                            this.filterData(3);
                        }
                    }, {
                        text: 'Fastest Delivery',
                        icon: 'rocket-outline',
                        handler: () => {
                            this.filterData(4);
                        }
                    }, {
                        text: 'Cancel',
                        icon: 'close',
                        role: 'cancel',
                        handler: () => {
                            console.log('Cancel clicked');
                        }
                    }]
            });
            yield actionSheet.present();
            const { role, data } = yield actionSheet.onDidDismiss();
            console.log('onDidDismiss resolved with role and data', role, data);
        });
    }
};
HomePage.ctorParameters = () => [
    { type: _awesome_cordova_plugins_native_page_transitions_ngx__WEBPACK_IMPORTED_MODULE_4__.NativePageTransitions },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.ActionSheetController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonRouterOutlet },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.ModalController },
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_7__.ActivatedRoute },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.LoadingController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.AlertController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.Platform },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.NavController }
];
HomePage.propDecorators = {
    content: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.ViewChild, args: ['content', { static: false },] }]
};
HomePage = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Component)({
        selector: 'app-home',
        template: _home_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_home_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], HomePage);



/***/ }),

/***/ 1020:
/*!************************************************!*\
  !*** ./src/app/home/home.page.scss?ngResource ***!
  \************************************************/
/***/ ((module) => {

module.exports = ".top {\n  margin-top: 10px;\n}\n\n.bgLight {\n  width: 98%;\n  margin: auto;\n  margin-top: 5px;\n}\n\n.topBtn {\n  border: 1px solid #202020;\n  border-radius: 10px;\n  padding: 7px 10px;\n  margin-left: 15px;\n  font-weight: bold;\n  font-size: 14px;\n  margin-top: 10px;\n}\n\n.welcomeHeader {\n  height: 200px;\n}\n\nion-title {\n  font-size: 15px;\n}\n\n.custom-slider {\n  position: relative;\n  /* To make sure the bullets are positioned relative to the slider */\n}\n\n.custom-slider .swiper-pagination {\n  position: absolute;\n  bottom: -10px;\n  /* Adjust this value to control the vertical positioning */\n  left: 50%;\n  transform: translateX(-50%);\n}\n\n.segment-button-checked {\n  color: red !important;\n}\n\n.horizontal-scrollable {\n  padding: 15px;\n  white-space: nowrap;\n  overflow-x: scroll;\n  overflow-y: hide;\n  -webkit-overflow-scrolling: touch;\n  scrollbar-width: none;\n  display: flex;\n  flex-wrap: nowrap;\n}\n\n.year-tag {\n  border: 1px solid gray;\n  border-radius: 10px;\n  font-size: 12px;\n  color: black;\n  padding: 5px 10px;\n  margin-right: 10px;\n}\n\n.year-tag-clear {\n  border: 1px solid red;\n  border-radius: 10px;\n  font-size: 12px;\n  color: red;\n  padding: 5px 10px;\n  margin-right: 10px;\n}\n\n.year-tag-select {\n  border: 1px solid green;\n  border-radius: 10px;\n  font-size: 12px;\n  color: green;\n  padding: 5px 10px;\n  margin-right: 10px;\n}\n\n.homeHeader {\n  background-color: var(--ion-color-light);\n  color: white;\n  height: 140px;\n}\n\n.storeType {\n  background-color: #f47720;\n  border-top-right-radius: 15px;\n  border-bottom-right-radius: 15px;\n  padding: 10px 10px;\n  color: white;\n}\n\nion-footer ion-icon {\n  font-size: 28px;\n}\n\nion-footer small {\n  font-size: 11px;\n}\n\n.act {\n  color: #f47720;\n}\n\n.sort {\n  border: 1px solid #f3f3f3;\n  border-radius: 10px;\n  font-size: 12px;\n  padding: 10px 10px;\n  margin: 1%;\n}\n\n.cate {\n  text-align: center;\n  margin-top: -6%;\n}\n\n.cate img {\n  background-color: white;\n  padding: 10px 10px;\n  border-radius: 50%;\n  width: 65px;\n}\n\n.cate ion-col {\n  margin-bottom: 10px;\n}\n\n.cate span {\n  display: block;\n  font-size: 14px;\n}\n\n.bgWhite {\n  background-color: white;\n  padding: 5px 5px;\n  margin-top: 10px;\n}\n\n.add {\n  display: block;\n  margin-top: 5px;\n  color: gray;\n}\n\n.tr {\n  border: 1px solid #f3f3f3;\n  border-radius: 5px;\n}\n\n.login-divider {\n  margin: 28px 0;\n  display: flex;\n  align-items: center;\n  gap: 12px;\n}\n\n.login-divider .hr {\n  flex: 1;\n  height: 1px;\n  background: var(--ion-color-step-300, var(--ion-background-color-step-300, #b3b3b3));\n}\n\n.login-divider .divider-text {\n  font-family: \"Poppins\", sans-serif;\n  font-size: 16px;\n  color: black;\n}\n\n.mainStore {\n  background-color: var(--ion-color-light);\n}\n\n.scroll-horizontal {\n  display: flex;\n  overflow-x: auto;\n  white-space: nowrap;\n  margin-top: -4%;\n}\n\n.scroll-horizontal ion-button {\n  margin-left: 10px;\n  margin-bottom: 28px;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */";

/***/ }),

/***/ 91670:
/*!************************************************!*\
  !*** ./src/app/home/home.page.html?ngResource ***!
  \************************************************/
/***/ ((module) => {

module.exports = "<ion-header class=\"ion-no-border\">\n<ion-toolbar color=\"primary\">\n<ion-title *ngIf=\"address\" routerLink=\"/city\" routerDirection=\"forward\"><ion-icon name=\"location-outline\"></ion-icon> {{ address }}</ion-title>\n<ion-buttons slot=\"end\" *ngIf=\"data\"><ion-button fill=\"clear\"><ion-icon name=\"bag-handle-outline\" style=\"font-size: 25px;\"></ion-icon><small style=\"color:red;font-size: 12px\" *ngIf=\"data.count > 0\">{{ data.count }}</small></ion-button></ion-buttons>\n<ion-buttons slot=\"start\" (click)=\"showMenu()\"><ion-button fill=\"clear\"><ion-icon name=\"menu-outline\" style=\"font-size: 25px;\"></ion-icon></ion-button></ion-buttons>\n</ion-toolbar>\n</ion-header>\n\n\n<ion-content [fullscreen]=\"true\" #content>\n\n<ion-refresher slot=\"fixed\" (ionRefresh)=\"doRefresh($event)\">\n    <ion-refresher-content></ion-refresher-content>\n  </ion-refresher>\n\n<!--Display loading-->\n<ion-list id=\"skeleton\" *ngIf=\"!data\">\n<ion-list-header>\n<ion-skeleton-text animated style=\"width: 40%\"></ion-skeleton-text>\n</ion-list-header>\n\n<ion-item *ngFor=\"let fake of fakeData\">\n<ion-thumbnail slot=\"start\">\n<ion-skeleton-text></ion-skeleton-text>\n</ion-thumbnail>\n<ion-label>\n<h3>\n<ion-skeleton-text animated style=\"width: 80%\"></ion-skeleton-text>\n</h3>\n<p>\n<ion-skeleton-text animated style=\"width: 60%\"></ion-skeleton-text>\n</p>\n<p>\n<ion-skeleton-text animated style=\"width: 30%\"></ion-skeleton-text>\n</p>\n</ion-label>\n</ion-item>\n\n</ion-list>\n\n<!--Main content start here-->\n<span *ngIf=\"data && text\">\n\n<div class=\"top\">\n<ion-searchbar mode=\"ios\" (click)=\"search()\" placeholder=\" {{ text.search }}\" color=\"light\" style=\"margin-bottom: 10px;\"></ion-searchbar>\n\n<!--<a class=\"topBtn\" (click)=\"setType(0)\"><ion-icon name=\"rocket\"></ion-icon> {{ text.delivery }}</a>\n<a class=\"topBtn\" (click)=\"setType(1)\"><ion-icon name=\"fast-food\"></ion-icon> {{ text.dinein_title }}</a>\n<a class=\"topBtn\" (click)=\"presentActionSheet()\"><ion-icon name=\"options\"></ion-icon> Filter</a>-->\n</div>\n<ion-slides [options]=\"BannerOption\" #slideone autoplay=\"1000\" pager=\"true\" class=\"custom-slider\" style=\"margin-top: 15px;padding:0px 10px;\">\n<ion-slide *ngFor=\"let banner of data.slider\" (click)=\"bannerLink(banner)\">\n\n<img src=\"{{ banner.img }}\" style=\"border-radius: 10px;\">\n\n</ion-slide>\n</ion-slides>\n<div class=\"bgLight\">\n\n<div class=\"login-divider\">\n  <span class=\"hr\"></span>\n  <span class=\"divider-text\">Choose From Categories</span>\n  <span class=\"hr\"></span>\n</div>\n\n<ion-row class=\"cate\">\n<ion-col size=\"3\" *ngFor=\"let cate of data.category\" routerLink=\"/view/{{ cate.id }}\">\n\n<img src=\"{{ cate.img }}\"><span>{{ cate.name }}</span>\n\n</ion-col>\n</ion-row>\n</div>\n\n<div class=\"login-divider\">\n  <span class=\"hr\"></span>\n  <span class=\"divider-text\">{{ text.trend_in }}</span>\n  <span class=\"hr\"></span>\n</div>\n\n<ion-slides pager=\"false\" [options]=\"TrendOption\" #slideone style=\"margin-top: -3%;\" id=\"store\">\n<ion-slide *ngFor=\"let trend of data.trend\" (click)=\"item(trend)\">\n\n<div>\n<ion-badge style=\"position: absolute;z-index: 99;top:0px;right:0px\" color=\"success\"><ion-icon name=\"trending-up-outline\"></ion-icon></ion-badge>\n<img src=\"{{ trend.img }}\" style=\"border-radius: 5px;width: 96%;\"><br><span style=\"display: block;margin-top: 5px;font-size: 15px;\">{{ trend.name }}</span>\n\n</div>\n\n\n</ion-slide>\n</ion-slides>\n\n<div class=\"login-divider\">\n  <span class=\"hr\"></span>\n  <span class=\"divider-text\">{{ storeData.length }} {{ text.store_around }}</span>\n  <span class=\"hr\"></span>\n</div>\n\n<div class=\"scroll-horizontal\">\n  <ion-button size=\"small\" [fill]=\"filterPress == '1' ? 'solid' : 'outline'\"  mode=\"ios\" color=\"dark\" (click)=\"filterData(1)\"><ion-icon name=\"star-outline\" slot=\"start\"></ion-icon> {{ text.rating }}</ion-button>\n  <ion-button size=\"small\" [fill]=\"filterPress == '2' ? 'solid' : 'outline'\"  mode=\"ios\" color=\"dark\" (click)=\"filterData(2)\"><ion-icon name=\"location-outline\" slot=\"start\"></ion-icon> {{ text.nearest }}</ion-button>\n  <ion-button size=\"small\" [fill]=\"filterPress == '3' ? 'solid' : 'outline'\"  mode=\"ios\" color=\"dark\" (click)=\"filterData(3)\"><ion-icon name=\"checkmark-done-outline\" slot=\"start\"></ion-icon> {{ text.new_arrival }}</ion-button>\n  <ion-button size=\"small\" [fill]=\"filterPress == '4' ? 'solid' : 'outline'\"  mode=\"ios\" color=\"dark\" (click)=\"filterData(4)\"><ion-icon name=\"rocket-outline\" slot=\"start\"></ion-icon> Fastest Delivery</ion-button>\n</div>\n\n<div class=\"mainStore\"><br>\n<ion-card mode=\"ios\" *ngFor=\"let store of storeData\" (click)=\"item(store)\" style=\"margin-top: 0%;\">\n<img src=\"{{ store.img }}\">\n\n<ion-card-content style=\"padding: 10px;\">\n\n<b style=\"color:black;font-size: 20px;\">{{ store.name }} <ion-badge style=\"float: right;\" *ngIf=\"store.rating > 0\"><ion-icon name=\"star-outline\"></ion-icon> {{ store.rating }}</ion-badge></b>\n\n<span style=\"display:block;font-size: 15px;margin-top: 5px;\">{{ store.currency }}{{ store.price }} {{ text.per_person }} |  {{ store.dtime }}</span>\n\n<span style=\"color:red;display: block;\" *ngIf=\"!store.open\">{{ text.store_close }}</span>\n\n</ion-card-content>\n\n</ion-card>\n<br>\n</div>\n</span>\n</ion-content>\n\n<ion-footer class=\"ion-no-border\" *ngIf=\"data && text\">\n<ion-toolbar color=\"light\">\n<ion-segment value=\"default\" color=\"primary\" mode=\"md\">\n<ion-segment-button value=\"default\" (click)=\"setType(0)\"><ion-icon name=\"rocket\"></ion-icon> <ion-label>{{ text.delivery }}</ion-label></ion-segment-button>\n<ion-segment-button value=\"segment\" (click)=\"setType(1)\"><ion-icon name=\"fast-food\"></ion-icon> <ion-label>{{ text.dinein_title }}</ion-label></ion-segment-button>\n</ion-segment>\n</ion-toolbar>\n</ion-footer>";

/***/ })

}]);
//# sourceMappingURL=src_app_home_home_module_ts.js.map