"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_lang_lang_module_ts"],{

/***/ 60531:
/*!*********************************************!*\
  !*** ./src/app/lang/lang-routing.module.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LangPageRoutingModule": () => (/* binding */ LangPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _lang_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lang.page */ 89214);




const routes = [
    {
        path: '',
        component: _lang_page__WEBPACK_IMPORTED_MODULE_0__.LangPage
    }
];
let LangPageRoutingModule = class LangPageRoutingModule {
};
LangPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], LangPageRoutingModule);



/***/ }),

/***/ 87026:
/*!*************************************!*\
  !*** ./src/app/lang/lang.module.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LangPageModule": () => (/* binding */ LangPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _lang_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lang-routing.module */ 60531);
/* harmony import */ var _lang_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lang.page */ 89214);







let LangPageModule = class LangPageModule {
};
LangPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _lang_routing_module__WEBPACK_IMPORTED_MODULE_0__.LangPageRoutingModule
        ],
        declarations: [_lang_page__WEBPACK_IMPORTED_MODULE_1__.LangPage]
    })
], LangPageModule);



/***/ }),

/***/ 89214:
/*!***********************************!*\
  !*** ./src/app/lang/lang.page.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "LangPage": () => (/* binding */ LangPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _lang_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./lang.page.html?ngResource */ 32450);
/* harmony import */ var _lang_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./lang.page.scss?ngResource */ 46692);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);






let LangPage = class LangPage {
    constructor(platform, loadingController, server, nav, toastController, alertController) {
        this.platform = platform;
        this.loadingController = loadingController;
        this.server = server;
        this.nav = nav;
        this.toastController = toastController;
        this.alertController = alertController;
        this.lid = '0';
    }
    ngOnInit() {
        if (localStorage.getItem('lid') && localStorage.getItem('lid') != 'null' && localStorage.getItem('lid') != undefined) {
            this.lid = localStorage.getItem('lid');
        }
        else {
            this.lid = "0";
        }
    }
    ionViewWillEnter() {
        this.loadData();
    }
    ionViewDidEnter() {
        this.subscription = this.platform.backButton.subscribe(() => {
            this.presentAlertConfirm();
        });
    }
    ionViewWillLeave() {
        this.subscription.unsubscribe();
    }
    presentAlertConfirm() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const alert = yield this.alertController.create({
                header: this.text.exit_app,
                message: this.text.exit_app_desc,
                buttons: [
                    {
                        text: this.text.cancel_btn,
                        role: 'cancel',
                        cssClass: 'secondary',
                        handler: (blah) => {
                            console.log('Confirm Cancel: blah');
                        }
                    }, {
                        text: this.text.exit_app_confirm,
                        handler: () => {
                            navigator['app'].exitApp();
                        }
                    }
                ]
            });
            yield alert.present();
        });
    }
    loadData() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                message: '',
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.getLang(this.lid).subscribe((response) => {
                this.data = response.data;
                this.text = response.text;
                this.ldata = response.data[0];
                localStorage.setItem('setting', JSON.stringify(response.setting));
                loading.dismiss();
            });
        });
    }
    set(data) {
        this.lid = data.id;
        this.ldata = data;
    }
    setLang() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.getLang(this.lid).subscribe((response) => {
                this.data = response.data;
                localStorage.setItem('app_text', JSON.stringify(response.text));
                localStorage.setItem('lang_data', JSON.stringify(this.ldata));
                localStorage.setItem('lid', this.lid);
                if (localStorage.getItem('current_lat') && localStorage.getItem('current_lat') != undefined) {
                    window.location.href = "/home";
                }
                else {
                    window.location.href = "/city";
                }
                loading.dismiss();
            });
        });
    }
    presentToast(txt) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const toast = yield this.toastController.create({
                message: txt,
                duration: 3000,
                position: 'top',
                mode: 'ios',
                color: 'dark'
            });
            toast.present();
        });
    }
};
LangPage.ctorParameters = () => [
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.Platform },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.LoadingController },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.AlertController }
];
LangPage = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Component)({
        selector: 'app-lang',
        template: _lang_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_lang_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], LangPage);



/***/ }),

/***/ 46692:
/*!************************************************!*\
  !*** ./src/app/lang/lang.page.scss?ngResource ***!
  \************************************************/
/***/ ((module) => {

module.exports = ".nonSelected {\n  background-color: #e0e0e0;\n  color: black;\n  padding: 20px;\n}\n\n.selected {\n  background-color: #fc8019;\n  color: white;\n  padding: 20px;\n}\n\n.lang-item:hover {\n  transform: scale(1.02);\n}\n\nion-content {\n  --background:var(--ion-color-light);\n}\n\nion-list {\n  border-radius: 10px;\n  margin-top: 20px;\n  padding: 20px 20px;\n}\n\nion-item {\n  border-radius: 10px;\n  --min-height:60px;\n  margin-top: 20px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImxhbmcucGFnZS5zY3NzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBO0VBRUMseUJBQUE7RUFDQSxZQUFBO0VBQ0EsYUFBQTtBQUFEOztBQUdBO0VBRUMseUJBQUE7RUFDQSxZQUFBO0VBQ0EsYUFBQTtBQUREOztBQUtBO0VBQ0Msc0JBQUE7QUFGRDs7QUFNQTtFQUVDLG1DQUFBO0FBSkQ7O0FBT0E7RUFFQyxtQkFBQTtFQUNBLGdCQUFBO0VBQ0Esa0JBQUE7QUFMRDs7QUFRQTtFQUVDLG1CQUFBO0VBQ0EsaUJBQUE7RUFDQSxnQkFBQTtBQU5EIiwiZmlsZSI6ImxhbmcucGFnZS5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiLm5vblNlbGVjdGVkXG57XG5cdGJhY2tncm91bmQtY29sb3I6ICNlMGUwZTA7XG5cdGNvbG9yOmJsYWNrO1xuXHRwYWRkaW5nOiAyMHB4XG59XG5cbi5zZWxlY3RlZFxue1xuXHRiYWNrZ3JvdW5kLWNvbG9yOiAjZmM4MDE5O1xuXHRjb2xvcjp3aGl0ZTtcblx0cGFkZGluZzogMjBweFxuXHRcbn1cblxuLmxhbmctaXRlbTpob3ZlciB7XG5cdHRyYW5zZm9ybTogc2NhbGUoMS4wMik7XG4gIH1cblxuXG5pb24tY29udGVudFxue1xuXHQtLWJhY2tncm91bmQ6dmFyKC0taW9uLWNvbG9yLWxpZ2h0KTtcbn1cblxuaW9uLWxpc3Rcbntcblx0Ym9yZGVyLXJhZGl1czoxMHB4O1xuXHRtYXJnaW4tdG9wOjIwcHg7XG5cdHBhZGRpbmc6IDIwcHggMjBweDtcbn1cblxuaW9uLWl0ZW1cbntcblx0Ym9yZGVyLXJhZGl1czogMTBweDtcblx0LS1taW4taGVpZ2h0OjYwcHg7XG5cdG1hcmdpbi10b3A6IDIwcHg7XG59Il19 */";

/***/ }),

/***/ 32450:
/*!************************************************!*\
  !*** ./src/app/lang/lang.page.html?ngResource ***!
  \************************************************/
/***/ ((module) => {

module.exports = "<ion-header class=\"ion-no-border\">\n<ion-toolbar color=\"primary\">\n<ion-buttons slot=\"start\">\n<ion-back-button></ion-back-button>\n<ion-title>Language</ion-title>\n</ion-buttons>\n\n</ion-toolbar>\n</ion-header>\n\n<ion-content *ngIf=\"data && text\" class=\"ion-padding\">\n\n<h1>{{ text.lang_title }}</h1><br>\n\n<ion-item (click)=\"set(lang)\" *ngFor=\"let lang of data\" lines=\"none\" mode=\"md\">\n  <ion-avatar slot=\"start\">\n    <img src=\"{{ lang.img }}\" style=\"width: 32px;height: 32px;\">\n  </ion-avatar>\n  <ion-label>\n   {{ lang.name }}\n  </ion-label>\n  <ion-icon name=\"checkmark\" slot=\"end\" color=\"primary\" *ngIf=\"lid == lang.id\"></ion-icon>\n</ion-item>\n\n</ion-content>\n\n<ion-footer *ngIf=\"text\" class=\"ion-no-border\">\n<ion-toolbar color=\"light\">\n<div class=\"ion-padding\">\n  <ion-button mode=\"ios\" expand=\"block\" (click)=\"setLang()\" class=\"sharp-button\">{{ text.update_lang }}</ion-button>\n</div>\n</ion-toolbar>\n</ion-footer>";

/***/ })

}]);
//# sourceMappingURL=src_app_lang_lang_module_ts.js.map