"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_rate_rate_module_ts"],{

/***/ 91397:
/*!*********************************************!*\
  !*** ./src/app/rate/rate-routing.module.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RatePageRoutingModule": () => (/* binding */ RatePageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _rate_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./rate.page */ 73899);




const routes = [
    {
        path: '',
        component: _rate_page__WEBPACK_IMPORTED_MODULE_0__.RatePage
    }
];
let RatePageRoutingModule = class RatePageRoutingModule {
};
RatePageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], RatePageRoutingModule);



/***/ }),

/***/ 41413:
/*!*************************************!*\
  !*** ./src/app/rate/rate.module.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RatePageModule": () => (/* binding */ RatePageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _rate_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./rate-routing.module */ 91397);
/* harmony import */ var _rate_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./rate.page */ 73899);







let RatePageModule = class RatePageModule {
};
RatePageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _rate_routing_module__WEBPACK_IMPORTED_MODULE_0__.RatePageRoutingModule
        ],
        declarations: [_rate_page__WEBPACK_IMPORTED_MODULE_1__.RatePage]
    })
], RatePageModule);



/***/ }),

/***/ 73899:
/*!***********************************!*\
  !*** ./src/app/rate/rate.page.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "RatePage": () => (/* binding */ RatePage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _rate_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./rate.page.html?ngResource */ 83712);
/* harmony import */ var _rate_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./rate.page.scss?ngResource */ 50391);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ 93819);







let RatePage = class RatePage {
    constructor(route, server, toastController, nav, loadingController) {
        this.route = route;
        this.server = server;
        this.toastController = toastController;
        this.nav = nav;
        this.loadingController = loadingController;
        this.star = 0;
        this.oid = this.route.snapshot.paramMap.get('oid');
        this.text = JSON.parse(localStorage.getItem('app_text'));
    }
    ngOnInit() {
    }
    setStar(val) {
        this.star = val;
    }
    giveRating(data) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            if (this.star == 0) {
                this.presentToast('Please Select Any Rating For Continue.');
            }
            else {
                const loading = yield this.loadingController.create({
                    message: 'Please wait...',
                    duration: 3000
                });
                yield loading.present();
                var allData = { comment: data.comment, user_id: localStorage.getItem('user_id'), star: this.star, oid: this.oid };
                this.server.rating(allData).subscribe((response) => {
                    this.presentToast('Thank You! Rating Submitted Successfully.');
                    this.nav.navigateBack('/my');
                    loading.dismiss();
                });
            }
        });
    }
    presentToast(txt) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const toast = yield this.toastController.create({
                message: txt,
                duration: 2000,
                position: 'top'
            });
            toast.present();
        });
    }
};
RatePage.ctorParameters = () => [
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__.ActivatedRoute },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.LoadingController }
];
RatePage = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
        selector: 'app-rate',
        template: _rate_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_rate_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], RatePage);



/***/ }),

/***/ 50391:
/*!************************************************!*\
  !*** ./src/app/rate/rate.page.scss?ngResource ***!
  \************************************************/
/***/ ((module) => {

module.exports = "\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJyYXRlLnBhZ2Uuc2NzcyJ9 */";

/***/ }),

/***/ 83712:
/*!************************************************!*\
  !*** ./src/app/rate/rate.page.html?ngResource ***!
  \************************************************/
/***/ ((module) => {

module.exports = "<ion-header no-border>\n  <ion-toolbar color=\"primary\">\n\n  \t<ion-buttons slot=\"start\">\n      <ion-back-button></ion-back-button>\n    </ion-buttons>\n\n    <ion-title>\n    {{ text.rating_title }}\n    </ion-title>\n  </ion-toolbar>\n</ion-header>\n\n<ion-content class=\"ion-padding\">\n\n\n<form #form=\"ngForm\" (ngSubmit)=\"giveRating(form.value)\">\n\n<ion-list>\n\n<small>{{ text.rating_des }}</small>\n<br><br>\n\n<ion-row style=\"font-size: 25px;color:#ff5722\" *ngIf=\"star == 0\">\n<ion-col size=\"1\" (click)=\"setStar(1)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(2)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(3)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(4)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(5)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n</ion-row>\n\n<ion-row style=\"font-size: 25px;color:#ff5722\" *ngIf=\"star == 1\">\n<ion-col size=\"1\" (click)=\"setStar(1)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(2)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(3)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(4)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(5)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n</ion-row>\n\n<ion-row style=\"font-size: 25px;color:#ff5722\" *ngIf=\"star == 2\">\n<ion-col size=\"1\" (click)=\"setStar(1)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(2)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(3)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(4)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(5)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n</ion-row>\n\n<ion-row style=\"font-size: 25px;color:#ff5722\" *ngIf=\"star == 3\">\n<ion-col size=\"1\" (click)=\"setStar(1)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(2)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(3)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(4)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(5)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n</ion-row>\n\n<ion-row style=\"font-size: 25px;color:#ff5722\" *ngIf=\"star == 4\">\n<ion-col size=\"1\" (click)=\"setStar(1)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(2)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(3)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(4)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(5)\"><ion-icon name=\"star-outline\"></ion-icon></ion-col>\n</ion-row>\n\n<ion-row style=\"font-size: 25px;color:#ff5722\" *ngIf=\"star == 5\">\n<ion-col size=\"1\" (click)=\"setStar(1)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(2)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(3)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(4)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n<ion-col size=\"1\" (click)=\"setStar(5)\"><ion-icon name=\"star\"></ion-icon></ion-col>\n</ion-row>\n\n<br><br>\n<ion-item>\n  <ion-textarea ngModel name=\"comment\" placeholder=\"Write your review\"></ion-textarea>\n</ion-item>\n\n\n</ion-list>\n<br>\n<ion-button color=\"primary\" expand=\"block\" type=\"submit\" [disabled]=\"form.invalid\" mode=\"ios\">{{ text.submit_btn }}</ion-button>\n\n</form>\n\n\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_rate_rate_module_ts.js.map