import { Component, OnInit,ViewChild } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { ServerService } from '../service/server.service';
import { NavController,Platform,LoadingController,IonSlides,AlertController,ModalController,IonRouterOutlet,ActionSheetController } from '@ionic/angular';
import { MenuPage } from '../menu/menu.page';
import { NativePageTransitions, NativeTransitionOptions } from '@awesome-cordova-plugins/native-page-transitions/ngx';

@Component({
  selector: 'app-view',
  templateUrl: './view.page.html',
  styleUrls: ['./view.page.scss'],
})
export class ViewPage implements OnInit {


  text:any;
  data:any;
  id:any;
  fakeData = [1,2,3,4,5,6,9];

  constructor(private route: ActivatedRoute,public actionSheetController: ActionSheetController,private routerOutlet: IonRouterOutlet,public modalController: ModalController,private activatedRoute: ActivatedRoute,public server : ServerService,public loadingController: LoadingController,public alertController: AlertController,public platform : Platform,public nav : NavController) {

   this.text = JSON.parse(localStorage.getItem('app_text'));
   this.id = this.route.snapshot.paramMap.get('id');

  }

  ngOnInit()
  {
  	this.loadData();
  }

  async loadData()
  {
    this.server.getStore(this.id).subscribe((response:any) => {
  
    this.data   = response;

    });

  }
  
  item(store)
  {
    if(store.open)
    {
      this.nav.navigateForward('/item/'+store.id+'/0');
    }
  }
} 
