"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_checkout_checkout_module_ts"],{

/***/ 2290:
/*!*****************************************************!*\
  !*** ./src/app/checkout/checkout-routing.module.ts ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CheckoutPageRoutingModule": () => (/* binding */ CheckoutPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _checkout_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./checkout.page */ 45247);




const routes = [
    {
        path: '',
        component: _checkout_page__WEBPACK_IMPORTED_MODULE_0__.CheckoutPage
    }
];
let CheckoutPageRoutingModule = class CheckoutPageRoutingModule {
};
CheckoutPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], CheckoutPageRoutingModule);



/***/ }),

/***/ 28400:
/*!*********************************************!*\
  !*** ./src/app/checkout/checkout.module.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CheckoutPageModule": () => (/* binding */ CheckoutPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _checkout_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./checkout-routing.module */ 2290);
/* harmony import */ var _checkout_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./checkout.page */ 45247);







let CheckoutPageModule = class CheckoutPageModule {
};
CheckoutPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _checkout_routing_module__WEBPACK_IMPORTED_MODULE_0__.CheckoutPageRoutingModule
        ],
        declarations: [_checkout_page__WEBPACK_IMPORTED_MODULE_1__.CheckoutPage]
    })
], CheckoutPageModule);



/***/ }),

/***/ 45247:
/*!*******************************************!*\
  !*** ./src/app/checkout/checkout.page.ts ***!
  \*******************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "CheckoutPage": () => (/* binding */ CheckoutPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _checkout_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./checkout.page.html?ngResource */ 84645);
/* harmony import */ var _checkout_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./checkout.page.scss?ngResource */ 11125);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _awesome_cordova_plugins_stripe_ngx__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @awesome-cordova-plugins/stripe/ngx */ 66025);
/* harmony import */ var _awesome_cordova_plugins_in_app_browser_ngx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @awesome-cordova-plugins/in-app-browser/ngx */ 12407);
/* harmony import */ var _payment_payment_page__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../payment/payment.page */ 70684);
/* harmony import */ var _select_address_select_address_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../select-address/select-address.page */ 55618);
/* harmony import */ var _tip_tip_page__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../tip/tip.page */ 25882);












let CheckoutPage = class CheckoutPage {
    constructor(alertController, routerOutlet, modalController, iab, route, server, toastController, nav, loadingController, stripe) {
        this.alertController = alertController;
        this.routerOutlet = routerOutlet;
        this.modalController = modalController;
        this.iab = iab;
        this.route = route;
        this.server = server;
        this.toastController = toastController;
        this.nav = nav;
        this.loadingController = loadingController;
        this.stripe = stripe;
        /*Stripe Config & Payment*/
        this.stripeView = false;
        this.revisit = false;
        this.discount = 0;
        this.r = false;
        this.otype = 1;
        this.odate = 1;
        this.address = [];
        this.hasEcash = false;
        this.ecash = 0;
        this.wallet = 0;
        this.cod = true;
        this.tip = 0;
        this.data = JSON.parse(localStorage.getItem('checkout_data'));
        this.setting = JSON.parse(localStorage.getItem('setting'));
        this.text = JSON.parse(localStorage.getItem('app_text'));
        this.stripe_id = this.setting.stripe_key;
        this.razor_id = this.setting.razor_key;
        this.cod = this.setting.cod == 0 ? true : false;
        this.getDate();
        this.publicKey = this.setting.fw_key;
        this.meta = { 'counsumer_id': this.setting.fw_ci, 'consumer_mac': this.setting.fw_mac };
        this.customizations = { title: 'New Order', description: 'Food Delivery App Payment', logo: 'https://dicont.s3.amazonaws.com/static/flow-logos/flutterwave-logo.png' };
    }
    getTotal() {
        if (this.otype == 2) {
            return (this.data.total - this.data.d_charges) + (this.tip * 1);
        }
        else {
            return (this.data.total) + (this.tip * 1);
        }
    }
    totalPayable() {
        return (this.getTotal() - this.ecash) + (this.tip * 1);
    }
    getDate() {
        var today = new Date();
        var dd = String(today.getDate()).padStart(2, '0');
        var mm = String(today.getMonth() + 1).padStart(2, '0');
        var yyyy = today.getFullYear();
        today = yyyy + '-' + mm + '-' + dd;
        this.todayDate = today;
        console.log(this.todayDate);
    }
    ngOnInit() {
    }
    ionViewWillEnter() {
        this.loadData();
    }
    loadData() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                message: '',
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.userInfo(localStorage.getItem('user_id'), this.data.data[0].store_id, localStorage.getItem('cart_no')).subscribe((response) => {
                this.address = response.address;
                this.user = response.data;
                this.wallet = this.user.wallet;
                this.api = response.api;
                this.dates = response.dates;
                this.times = response.times;
                this.tips = response.tip;
                this.customerDetails = { name: this.user.name, email: this.user.email, phone_number: this.user.phone };
                localStorage.setItem("years", JSON.stringify(response.year));
                if (response.stock == false) {
                    this.presentToast(this.text.out_stock_msg_checkout);
                    this.nav.navigateBack('/cart');
                }
                if (response.store.delivery_by == 1) {
                    this.cod = response.store.cod == 1 ? true : false;
                }
                if (response.store.stripe_key) {
                    this.stripe_id = response.store.stripe_key;
                }
                if (response.store.razor_key) {
                    this.razor_id = response.store.razor_key;
                }
                loading.dismiss();
            });
        });
    }
    setAddress(a) {
        this.address_id = a.id;
        this.addressName = a.address;
        localStorage.setItem("current_lat", a.lat);
        localStorage.setItem("current_lng", a.lng);
        this.presentToast(this.text.d_charge_msg);
        this.server.getCart(localStorage.getItem('cart_no')).subscribe((response) => {
            this.data = response.data;
        });
    }
    book() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                spinner: 'bubbles',
                duration: 3000
            });
            yield loading.present();
            var allData = {
                payment: this.payment,
                cart_no: localStorage.getItem('cart_no'),
                payment_id: this.payment_id,
                otype: this.otype,
                odate: this.odate,
                order_date: this.order_date,
                order_time: this.order_time,
                user_id: localStorage.getItem('user_id'),
                address: this.address_id,
                ecash: this.ecash,
                comment: localStorage.getItem('cooking_notes'),
                tip: this.tip
            };
            this.server.order(allData).subscribe((response) => {
                localStorage.setItem('order_data', JSON.stringify(response.data));
                localStorage.removeItem("cooking_notes");
                this.nav.navigateRoot('/detail/' + response.data.data.id);
                if (this.data.store.whatsapp_new_order == 0) {
                    this.presentAlertConfirm(response.data.data.id);
                }
                loading.dismiss();
            });
        });
    }
    presentAlertConfirm(id) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__awaiter)(this, void 0, void 0, function* () {
            const alert = yield this.alertController.create({
                cssClass: 'my-custom-class',
                mode: 'ios',
                header: 'Thank you! Your order has been successfully registered.',
                message: "Do you want to send a Copy of this Order on Whatsapp?",
                buttons: [
                    {
                        text: 'Yes! Send',
                        role: 'cancel',
                        cssClass: 'secondary',
                        handler: (blah) => {
                            this.nav.navigateRoot('/detail/' + id);
                            this.sendWhatsapp();
                        }
                    }, {
                        text: 'No',
                        handler: () => {
                            this.nav.navigateRoot('/detail/' + id);
                        }
                    }
                ]
            });
            yield alert.present();
        });
    }
    sendWhatsapp() {
        var itemName = "Olá! *" + this.data.store.name + "* Tudo bem?, Segue os detalhes do meu pedido, Qualquer dúvida que tenham, pode me chamar pelo WhatsApp\n\n";
        //items detail
        for (var i = 0; i < this.data.data.length; i++) {
            var name = this.data.data[i].qtyName ? this.data.data[i].qtyName : "";
            var price = this.data.data[i].price * this.data.data[i].qty;
            itemName = itemName + this.data.data[i].item + " - " + this.data.data[i].qty + " " + name + " - " + this.setting.currency + price + " \n\n";
            if (this.data.data[i].addon.length > 0) {
                for (var a = 0; a < this.data.data[i].addon.length; a++) {
                    itemName = itemName + "----" + this.data.data[i].addon[a].name + " - " + this.setting.currency + this.data.data[i].addon[a].price + "\n\n";
                }
            }
        }
        if (this.odate == 1) {
            var o_date_time = "Entregas de hoje";
        }
        else {
            var o_date_time = this.order_date + " " + this.order_time;
        }
        var order_type = this.otype == 1 ? "Entregar no Endereço" : "Buscarei no Local";
        //other detail
        itemName = itemName + "*Tipo de pedido* : " + order_type;
        itemName = itemName + "\n\n*Data e horas da Entrega* : " + o_date_time;
        itemName = itemName + "\n\n*Detalhes do usuário*";
        itemName = itemName + "\n*Nome* : " + this.user.name;
        itemName = itemName + "\n*Telefone* : " + this.user.phone;
        if (this.otype == 1) {
            itemName = itemName + "\n*Endereço* : " + this.addressName;
        }
        if (this.comment) {
            itemName = itemName + "\n*Observações* : " + this.comment;
        }
        if (this.payment == 1) {
            var pm = "Pagamento na entrega";
        }
        else {
            var pm = "Pago Online (Id da Transação : " + this.payment_id + ")";
        }
        itemName = itemName + "\n\n\n*Valor Total* : " + this.setting.currency + this.getTotal();
        if (this.otype == 1 && this.data.d_charges > 0) {
            itemName = itemName + "\n\n\n*Taxa de entrega* : " + this.setting.currency + this.data.d_charges;
        }
        itemName = itemName + "\n\n*Forma de pagamento* : " + pm;
        window.location.href = "https://wa.me/" + this.data.store.whatsapp + "?text=" + encodeURI(itemName);
    }
    makeOrder() {
        if (this.payment == 2) {
            this.payWithStripe();
        }
        else if (this.payment == 3) {
            this.payWithRazor();
        }
        else if (this.payment == 4) {
            this.payPaypal();
        }
        else if (this.payment == 5) {
            this.payStack();
        }
        else if (this.payment == 6) {
            this.makeFlutterPayment();
        }
        else {
            this.book();
        }
    }
    payWithStripe() {
        var cNo = this.card_no;
        if (cNo && cNo.length == 16 && this.exp_month.length == 2 && this.exp_year.length == 4 && this.cvv.length == 3) {
            this.stripe.setPublishableKey(this.stripe_id);
            let card = {
                number: cNo,
                expMonth: this.exp_month,
                expYear: this.exp_year,
                cvc: this.cvv
            };
            var cardNo = false;
            var cvvCorrect = false;
            //validate card no
            this.stripe.validateCardNumber(cNo)
                .then(res => {
                this.stripe.createCardToken(card)
                    .then(token => {
                    if (token.id) {
                        this.makePayment(token.id, cNo);
                    }
                    else {
                        this.presentToast(this.text.card_no_validation);
                    }
                })
                    .catch(error => {
                    this.presentToast(this.text.stripe_config);
                });
            })
                .catch(error => {
                this.presentToast(this.text.card_no_validation);
            });
        }
        else {
            this.presentToast(this.text.stripe_validation);
        }
    }
    makePayment(token, cNo) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.makeStripePayment("?token=" + token + "&amount=" + this.getTotal() + "&user_id=" + this.phone + '&store_id=' + this.data.data[0].store_id).subscribe((response) => {
                if (response.data == "done") {
                    this.payment_id = response.id;
                    if (this.payment_id) {
                        this.book();
                    }
                }
                else {
                    this.presentToast(response.error);
                }
                loading.dismiss();
            });
        });
    }
    payWithRazor() {
        var options = {
            description: 'Pay Now',
            image: 'https://cdn.iconscout.com/icon/free/png-512/bhim-3-69845.png',
            currency: this.setting.currency_code,
            key: this.razor_id,
            amount: this.getTotal() * 100,
            name: 'Food Order App',
            prefill: {
                email: this.name + "@google.com",
                contact: this.phone,
                name: this.name
            },
            theme: {
                color: '#2196f3'
            },
            modal: {
                ondismiss: function () {
                    alert('dismissed');
                }
            }
        };
        var successCallback = (success) => {
            this.payment_id = success;
            if (this.payment_id) {
                this.book();
            }
        };
        var cancelCallback = function (error) {
            alert(error.description + ' (Error ' + error.code + ')');
        };
        RazorpayCheckout.open(options, successCallback, cancelCallback);
    }
    presentToast(txt) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__awaiter)(this, void 0, void 0, function* () {
            const toast = yield this.toastController.create({
                message: txt,
                duration: 3000,
                position: 'top',
                mode: 'ios',
                color: 'dark'
            });
            toast.present();
        });
    }
    allSet() {
        if (this.otype && this.odate) {
            if (this.totalPayable() > 0 && !this.payment) {
                return false;
            }
            if (this.otype == 1 && this.odate == 1 && this.address_id) {
                return true;
            }
            else if (this.otype == 2 && this.odate == 1) {
                return true;
            }
            else if (this.otype == 2 && this.odate == 2 && this.order_time && this.order_date) {
                return true;
            }
            else if (this.otype == 1 && this.odate == 2 && this.address_id && this.order_date && this.order_time) {
                return true;
            }
        }
        else {
            return false;
        }
    }
    payPaypal() {
    }
    payStack() {
        var query = "?name=" + this.user.name + "&phone=" + this.user.phone + "&email=" + this.user.email + "&amount=" + this.getTotal();
        var paymetUrl = this.api + "/payStack" + query;
        var successUrl = this.api + "/payStackSuccess";
        var failUrl = this.api + "/payStackCancel";
        const browser = this.iab.create(paymetUrl, "_blank", { zoom: 'no', location: 'no', toolbar: 'no' });
        browser.on('loadstop').subscribe(event => {
            if (event.url === successUrl) {
                this.book();
                browser.close();
            }
            else if (event.url === failUrl) {
                this.presentToast(this.text.pay_cancel);
                browser.close();
            }
        });
        browser.show();
    }
    getPaymentMethod() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__awaiter)(this, void 0, void 0, function* () {
            const modal = yield this.modalController.create({
                component: _payment_payment_page__WEBPACK_IMPORTED_MODULE_5__.PaymentPage,
                animated: true,
                mode: 'ios',
                cssClass: 'my-custom-modal-css',
                backdropDismiss: true,
                swipeToClose: true,
                presentingElement: this.routerOutlet.nativeEl,
                componentProps: {
                    'total': this.getTotal(),
                    'wallet': this.wallet,
                    'user': this.user
                }
            });
            modal.onDidDismiss().then(data => {
                if (data.data) {
                    this.payment = data.data.payment;
                    this.hasEcash = data.data.hasEcash;
                    this.card_no = data.data.card_no;
                    this.exp_month = data.data.exp_month;
                    this.exp_year = data.data.exp_year;
                    this.cvv = data.data.cvv;
                    //if used ecash
                    if (this.hasEcash == true) {
                        if (this.wallet > this.getTotal()) {
                            this.ecash = this.getTotal();
                            this.wallet = this.wallet - this.ecash;
                        }
                        else {
                            this.ecash = this.wallet;
                            this.wallet = 0;
                            console.log(this.ecash);
                        }
                    }
                    else {
                        this.wallet = this.user.wallet;
                        this.ecash = 0;
                    }
                }
            });
            return yield modal.present();
        });
    }
    getAddress() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__awaiter)(this, void 0, void 0, function* () {
            const modal = yield this.modalController.create({
                component: _select_address_select_address_page__WEBPACK_IMPORTED_MODULE_6__.SelectAddressPage,
                animated: true,
                mode: 'ios',
                cssClass: 'my-custom-modal-css',
                backdropDismiss: true,
                swipeToClose: true,
                componentProps: {
                    'address': this.address,
                }
            });
            modal.onDidDismiss().then(data => {
                if (data.data) {
                    this.setAddress(data.data.address);
                }
            });
            return yield modal.present();
        });
    }
    addTip() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__awaiter)(this, void 0, void 0, function* () {
            const modal = yield this.modalController.create({
                component: _tip_tip_page__WEBPACK_IMPORTED_MODULE_7__.TipPage,
                animated: true,
                mode: 'ios',
                cssClass: 'my-custom-modal-css',
                backdropDismiss: true,
                swipeToClose: true,
                breakpoints: [0, 0.3, 0.5, 0.5],
                initialBreakpoint: 0.2,
                componentProps: {
                    'tips': this.tips,
                }
            });
            modal.onDidDismiss().then(data => {
                if (data.data) {
                    this.tip = data.data.tip;
                }
            });
            return yield modal.present();
        });
    }
    removeTip() {
        this.tip = null;
    }
    makeFlutterPayment() {
        /*var paymentData: InlinePaymentOptions = {
        public_key: this.publicKey,
        tx_ref: "Ref_id_"+Math.floor(Math.random() * 2000000000) + 1,
        amount: this.getTotal(),
        currency: this.setting.currency_code,
        payment_options: 'card,ussd',
        redirect_url: '',
        meta: this.meta,
        customer: this.customerDetails,
        customizations: this.customizations,
        callback: this.makePaymentCallback,
        onclose: this.closedPaymentModal,
        callbackContext: this
      }
    
        this.flutterwave.inlinePay(paymentData);*/
    }
};
CheckoutPage.ctorParameters = () => [
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.AlertController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.IonRouterOutlet },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.ModalController },
    { type: _awesome_cordova_plugins_in_app_browser_ngx__WEBPACK_IMPORTED_MODULE_4__.InAppBrowser },
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_10__.ActivatedRoute },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_9__.LoadingController },
    { type: _awesome_cordova_plugins_stripe_ngx__WEBPACK_IMPORTED_MODULE_3__.Stripe }
];
CheckoutPage.propDecorators = {
    content: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_11__.ViewChild, args: ['content', { static: false },] }]
};
CheckoutPage = (0,tslib__WEBPACK_IMPORTED_MODULE_8__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_11__.Component)({
        selector: 'app-checkout',
        template: _checkout_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_checkout_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], CheckoutPage);



/***/ }),

/***/ 11125:
/*!********************************************************!*\
  !*** ./src/app/checkout/checkout.page.scss?ngResource ***!
  \********************************************************/
/***/ ((module) => {

module.exports = "ion-content {\n  --background: #efeff4;\n}\n\n.paymentIcon {\n  float: right;\n  font-size: 28px;\n  margin-top: -3%;\n}\n\n.activeCard {\n  background-color: var(--ion-color-primary);\n  color: white;\n}\n\n.activeHeader {\n  color: white;\n}\n\nion-item {\n  border: 1px solid #e1e0e0;\n  border-radius: 10px;\n}\n\nion-list {\n  border-radius: 10px;\n  padding: 10px 10px;\n}\n\n.address {\n  border: 1px solid #e1e0e0;\n  padding: 0px 10px;\n  border-radius: 10px;\n}\n\n.shwPayment {\n  display: block;\n  padding: 0px 10px;\n  margin-top: -10px;\n  margin-bottom: 5px;\n}\n\n.tipBox {\n  background-color: #f7f7f7;\n  padding: 10px 10px;\n  border-radius: 10px;\n}\n\n.tip small {\n  display: block;\n  margin-top: -5px;\n}\n\nh3 {\n  font-family: \"Poppins\", sans-serif;\n  font-size: 21px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbImNoZWNrb3V0LnBhZ2Uuc2NzcyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFDQTtFQUVFLHFCQUFBO0FBREY7O0FBSUE7RUFFQyxZQUFBO0VBQWEsZUFBQTtFQUFnQixlQUFBO0FBQTlCOztBQUdBO0VBRUMsMENBQUE7RUFDQSxZQUFBO0FBREQ7O0FBU0E7RUFFQyxZQUFBO0FBUEQ7O0FBVUE7RUFFRSx5QkFBQTtFQUNBLG1CQUFBO0FBUkY7O0FBV0E7RUFFRSxtQkFBQTtFQUNBLGtCQUFBO0FBVEY7O0FBWUE7RUFFQyx5QkFBQTtFQUF5QixpQkFBQTtFQUFrQixtQkFBQTtBQVI1Qzs7QUFXQTtFQUVDLGNBQUE7RUFBYyxpQkFBQTtFQUFrQixpQkFBQTtFQUFrQixrQkFBQTtBQU5uRDs7QUFTQTtFQUVDLHlCQUFBO0VBQ0Msa0JBQUE7RUFDQSxtQkFBQTtBQVBGOztBQVVBO0VBRUMsY0FBQTtFQUNBLGdCQUFBO0FBUkQ7O0FBV0E7RUFFQyxrQ0FBQTtFQUNBLGVBQUE7QUFURCIsImZpbGUiOiJjaGVja291dC5wYWdlLnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyJcbmlvbi1jb250ZW50XG57XG4gIC0tYmFja2dyb3VuZDogI2VmZWZmNDtcbn1cblxuLnBheW1lbnRJY29uXG57XG5cdGZsb2F0OiByaWdodDtmb250LXNpemU6IDI4cHg7bWFyZ2luLXRvcDogLTMlO1xufVxuXG4uYWN0aXZlQ2FyZFxue1xuXHRiYWNrZ3JvdW5kLWNvbG9yOiB2YXIoLS1pb24tY29sb3ItcHJpbWFyeSk7XG5cdGNvbG9yOndoaXRlO1xufVxuXG4ubm9uXG57XG5cdFxufVxuXG4uYWN0aXZlSGVhZGVyXG57XG5cdGNvbG9yOndoaXRlO1xufVxuXG5pb24taXRlbVxue1xuICBib3JkZXI6IDFweCBzb2xpZCAjZTFlMGUwO1xuICBib3JkZXItcmFkaXVzOiAxMHB4O1xufVxuXG5pb24tbGlzdFxue1xuICBib3JkZXItcmFkaXVzOiAxMHB4O1xuICBwYWRkaW5nOjEwcHggMTBweDtcbn1cblxuLmFkZHJlc3Ncbntcblx0Ym9yZGVyOjFweCBzb2xpZCAjZTFlMGUwO3BhZGRpbmc6IDBweCAxMHB4O2JvcmRlci1yYWRpdXM6IDEwcHg7XG59XG5cbi5zaHdQYXltZW50XG57XG5cdGRpc3BsYXk6YmxvY2s7cGFkZGluZzogMHB4IDEwcHg7bWFyZ2luLXRvcDogLTEwcHg7bWFyZ2luLWJvdHRvbTogNXB4O1xufVxuXG4udGlwQm94XG57XG5cdGJhY2tncm91bmQtY29sb3I6ICNmN2Y3Zjc7XG4gIHBhZGRpbmc6IDEwcHggMTBweDtcbiAgYm9yZGVyLXJhZGl1czogMTBweDtcbn1cblxuLnRpcCBzbWFsbFxue1xuXHRkaXNwbGF5OiBibG9jaztcblx0bWFyZ2luLXRvcDogLTVweDtcbn1cblxuaDNcbntcblx0Zm9udC1mYW1pbHk6IFwiUG9wcGluc1wiLCBzYW5zLXNlcmlmO1xuXHRmb250LXNpemU6IDIxcHg7XG59Il19 */";

/***/ }),

/***/ 84645:
/*!********************************************************!*\
  !*** ./src/app/checkout/checkout.page.html?ngResource ***!
  \********************************************************/
/***/ ((module) => {

module.exports = "<ion-header class=\"ion-no-border\">\n<ion-toolbar color=\"primary\">\n\n<ion-buttons slot=\"start\">\n<ion-back-button></ion-back-button>\n</ion-buttons>\n\n<ion-title *ngIf=\"text\">{{ text.checkout }}</ion-title>\n\n\n</ion-toolbar>\n</ion-header>\n\n<ion-content *ngIf=\"data && text\" #content class=\"ion-padding\">\n\n<ion-list>\n  <ion-radio-group value=\"0\" [(ngModel)]=\"otype\" name=\"otype\">\n    \n   <ion-item lines=\"none\">\n    <ion-label style=\"font-size: 14px\">{{ text.order_type }}</ion-label>\n    <ion-select placeholder=\"{{ text.delivery }}\" name=\"otype\" [(ngModel)]=\"otype\">\n      <ion-select-option value=\"1\">{{ text.delivery }}</ion-select-option>\n      <ion-select-option value=\"2\">{{ text.pickup }}</ion-select-option>\n    </ion-select>\n  </ion-item>\n\n  <br>\n\n  <ion-item lines=\"none\">\n    <ion-label style=\"font-size: 14px\">{{ text.order_date_time }}</ion-label>\n    <ion-select placeholder=\"{{ text.deliver_today }}\" name=\"odate\" [(ngModel)]=\"odate\">\n      <ion-select-option value=\"1\">{{ text.deliver_today }}</ion-select-option>\n      <ion-select-option value=\"2\">{{ text.deliver_later }}</ion-select-option>\n    </ion-select>\n  </ion-item>\n\n  <span *ngIf=\"odate == 2\">\n  <br>\n  <ion-item lines=\"none\" *ngIf=\"dates\">\n    <ion-label style=\"font-size: 14px\">{{ text.order_date_time }}</ion-label>\n    <ion-select placeholder=\"{{ text.select }}\" [(ngModel)]=\"order_date\" name=\"order_date\" interface=\"action-sheet\" mode=\"md\">\n      <ion-select-option value=\"{{ d }}\" *ngFor=\"let d of dates\">{{ d }}</ion-select-option>\n    </ion-select>\n  </ion-item>\n  <br>\n  <ion-item lines=\"none\" *ngIf=\"times\">\n    <ion-label style=\"font-size: 14px\">{{ text.select_time }}</ion-label>\n    <ion-select placeholder=\"{{ text.select }}\" [(ngModel)]=\"order_time\" name=\"order_time\" interface=\"action-sheet\" mode=\"md\">\n      <ion-select-option value=\"{{ t }}\" *ngFor=\"let t of times\">{{ t }}</ion-select-option>\n    </ion-select>\n  </ion-item>\n</span>\n  \n  </ion-radio-group>\n</ion-list>\n\n<div style=\"background-color:white;margin-top:10px;border-radius: 10px;\" *ngIf=\"otype == 1\">\n<ion-list>\n<ion-item (click)=\"addTip()\" lines=\"none\" detail>\n  <ion-label style=\"font-size: 13px;\">\n   {{ text.add_tip }}\n  </ion-label>\n  <ion-icon name=\"cash-outline\" slot=\"start\" color=\"primary\"></ion-icon>\n</ion-item>\n</ion-list>\n<p *ngIf=\"tip\" style=\"font-size: 14px;padding: 10px 20px;\"><br>{{ setting.currency }}{{ tip }} {{ text.tip_added }} <a style=\"float:right\" (click)=\"removeTip()\">{{ text.clear }}</a></p>\n\n</div>\n\n<div style=\"background-color:white;margin-top:10px;border-radius:10px;padding: 10px 10px;\">\n<h3>{{ text.address_payment }}</h3><br>\n<span *ngIf=\"otype == 1\">\n<div class=\"address\" (click)=\"getAddress()\">\n<p style=\"padding: 0px 10px\">{{ text.persoanl_info }} <ion-icon name=\"caret-down-circle-outline\" style=\"float: right;margin-top: 4px;\"></ion-icon></p>\n\n<small *ngIf=\"addressName\" style=\"display:block;padding: 0px 10px;margin-top: -10px;margin-bottom: 5px\">{{ addressName }}</small>\n\n</div>\n</span>\n<br>\n<div class=\"address\">\n<p style=\"padding: 0px 10px\" (click)=\"getPaymentMethod()\">{{ text.payment_method }} <span style=\"font-size:16px;float: right\"><ion-badge>{{ setting.currency }}{{ getTotal() }}</ion-badge></span></p>\n\n<small *ngIf=\"payment && payment == 1\" class=\"shwPayment\">{{ text.cod }}</small>\n<small *ngIf=\"payment && payment == 2\" class=\"shwPayment\">{{ text.stripe }}</small>\n<small *ngIf=\"payment && payment == 3\" class=\"shwPayment\">{{ text.razor }}</small>\n<small *ngIf=\"payment && payment == 4\" class=\"shwPayment\">{{ text.pay_paypal }}</small>\n<small *ngIf=\"payment && payment == 5\" class=\"shwPayment\">{{ text.pay_paystack }}</small>\n<small *ngIf=\"payment && payment == 6\" class=\"shwPayment\">{{ text.fw }}</small>\n<small *ngIf=\"!payment && hasEcash\" class=\"shwPayment\">{{ text.ecash }}</small>\n\n\n</div>\n\n\n\n<br>\n<ion-button mode=\"ios\" expand=\"block\" [disabled]=\"!allSet()\" (click)=\"makeOrder()\">{{ text.book_now }}</ion-button>\n</div>\n\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_checkout_checkout_module_ts.js.map