"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_search_search_module_ts"],{

/***/ 19730:
/*!*************************************************!*\
  !*** ./src/app/search/search-routing.module.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SearchPageRoutingModule": () => (/* binding */ SearchPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _search_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./search.page */ 75105);




const routes = [
    {
        path: '',
        component: _search_page__WEBPACK_IMPORTED_MODULE_0__.SearchPage
    }
];
let SearchPageRoutingModule = class SearchPageRoutingModule {
};
SearchPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], SearchPageRoutingModule);



/***/ }),

/***/ 24682:
/*!*****************************************!*\
  !*** ./src/app/search/search.module.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SearchPageModule": () => (/* binding */ SearchPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _search_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./search-routing.module */ 19730);
/* harmony import */ var _search_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./search.page */ 75105);
/* harmony import */ var ng2_search_filter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ng2-search-filter */ 9991);








let SearchPageModule = class SearchPageModule {
};
SearchPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule,
            _search_routing_module__WEBPACK_IMPORTED_MODULE_0__.SearchPageRoutingModule,
            ng2_search_filter__WEBPACK_IMPORTED_MODULE_2__.Ng2SearchPipeModule
        ],
        declarations: [_search_page__WEBPACK_IMPORTED_MODULE_1__.SearchPage]
    })
], SearchPageModule);



/***/ }),

/***/ 75105:
/*!***************************************!*\
  !*** ./src/app/search/search.page.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SearchPage": () => (/* binding */ SearchPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _search_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./search.page.html?ngResource */ 20463);
/* harmony import */ var _search_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./search.page.scss?ngResource */ 99090);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);






let SearchPage = class SearchPage {
    constructor(platform, loadingController, server, nav, toastController, alertController) {
        this.platform = platform;
        this.loadingController = loadingController;
        this.server = server;
        this.nav = nav;
        this.toastController = toastController;
        this.alertController = alertController;
        this.search = false;
        this.fakeData = [1, 2, 3, 4, 5, 6, 7];
        this.search_query = [];
        this.text = JSON.parse(localStorage.getItem('app_text'));
        this.trend = JSON.parse(localStorage.getItem('trend_data'));
        this.store = JSON.parse(localStorage.getItem('all_data'));
        if (localStorage.getItem('search_query') && localStorage.getItem('search_query') != undefined && localStorage.getItem('search_query') != "null") {
            this.search_query = JSON.parse(localStorage.getItem('search_query'));
        }
    }
    ngOnInit() {
    }
    ionViewDidEnter() {
        this.searchBar.setFocus();
    }
    clearSearch() {
        localStorage.removeItem("search_query");
        this.search_query = [];
    }
    search_again(t) {
        this.q = t;
    }
    save(e) {
        if (this.search_query) {
            var search_array = this.search_query;
        }
        else {
            var search_array = [];
        }
        search_array.push(e.target.value);
        if (search_array.length > 0) {
            localStorage.setItem("search_query", JSON.stringify(search_array));
        }
    }
    presentToast(txt) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const toast = yield this.toastController.create({
                message: txt,
                duration: 3000,
                position: 'top',
                mode: 'ios',
                color: 'dark'
            });
            toast.present();
        });
    }
    searchPage(s) {
        if (s.item == false) {
            this.nav.navigateForward('/item/' + s.id + "/0");
        }
        else {
            this.search = true;
            this.searchData(s.id);
            this.searchQ = s.name;
        }
    }
    searchData(id) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            this.server.getSearch(id).subscribe((response) => {
                this.data = response.data;
                this.search = false;
            });
        });
    }
    item(store) {
        if (store.open) {
            this.nav.navigateForward('/item/' + store.id + '/0');
        }
    }
};
SearchPage.ctorParameters = () => [
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.Platform },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.LoadingController },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__.AlertController }
];
SearchPage.propDecorators = {
    searchBar: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_5__.ViewChild, args: ['searchBar', { static: false },] }]
};
SearchPage = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_5__.Component)({
        selector: 'app-search',
        template: _search_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_search_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], SearchPage);



/***/ }),

/***/ 99090:
/*!****************************************************!*\
  !*** ./src/app/search/search.page.scss?ngResource ***!
  \****************************************************/
/***/ ((module) => {

module.exports = "ion-content {\n  --background:var(--ion-color-light);\n}\n\nion-list {\n  border-radius: 10px;\n}\n\nion-item {\n  border-radius: 10px;\n  margin-top: 20px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNlYXJjaC5wYWdlLnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFFRSxtQ0FBQTtBQUFGOztBQUdBO0VBRUUsbUJBQUE7QUFERjs7QUFJQTtFQUVFLG1CQUFBO0VBQ0EsZ0JBQUE7QUFGRiIsImZpbGUiOiJzZWFyY2gucGFnZS5zY3NzIiwic291cmNlc0NvbnRlbnQiOlsiaW9uLWNvbnRlbnRcbntcbiAgLS1iYWNrZ3JvdW5kOnZhcigtLWlvbi1jb2xvci1saWdodCk7XG59XG5cbmlvbi1saXN0XG57XG4gIGJvcmRlci1yYWRpdXM6MTBweFxufVxuXG5pb24taXRlbVxue1xuICBib3JkZXItcmFkaXVzOiAxMHB4O1xuICBtYXJnaW4tdG9wOiAyMHB4O1xufSJdfQ== */";

/***/ }),

/***/ 20463:
/*!****************************************************!*\
  !*** ./src/app/search/search.page.html?ngResource ***!
  \****************************************************/
/***/ ((module) => {

module.exports = "<ion-header class=\"ion-no-border\">\n<ion-toolbar color=\"light\">\n<ion-buttons slot=\"start\">\n<ion-back-button></ion-back-button>\n</ion-buttons>\n</ion-toolbar>\n</ion-header>\n\n<ion-content *ngIf=\"text\">\n\n<!--Display loading-->\n<ion-list id=\"skeleton\" *ngIf=\"search\">\n<ion-list-header>\n<ion-skeleton-text animated style=\"width: 40%\"></ion-skeleton-text>\n</ion-list-header>\n\n<ion-item *ngFor=\"let fake of fakeData\">\n<ion-thumbnail slot=\"start\">\n<ion-skeleton-text></ion-skeleton-text>\n</ion-thumbnail>\n<ion-label>\n<h3>\n<ion-skeleton-text animated style=\"width: 80%\"></ion-skeleton-text>\n</h3>\n<p>\n<ion-skeleton-text animated style=\"width: 60%\"></ion-skeleton-text>\n</p>\n<p>\n<ion-skeleton-text animated style=\"width: 30%\"></ion-skeleton-text>\n</p>\n</ion-label>\n</ion-item>\n\n</ion-list>\n\n<h1 style=\"padding: 10px 15px\">{{ text.search }}</h1>\n\n<ion-searchbar mode=\"ios\" [(ngModel)]=\"q\" placeholder=\"{{ text.search_title }}\" (ionChange)=\"save($event)\" #searchBar></ion-searchbar>\n\n<ion-list *ngIf=\"q && q.length > 2 && !data\">\n<ion-list-header>{{ text.search_res }} <b>&nbsp;{{ q }}</b></ion-list-header>\n\n<ion-item *ngFor=\"let s of store | filter:q\" detail (click)=\"searchPage(s)\">\n<ion-thumbnail slot=\"start\">\n    <img src=\"{{ s.img }}\" style=\"border-radius: 6px\">\n  </ion-thumbnail>\n<ion-label>{{ s.name }}</ion-label>\n</ion-item>\n\n</ion-list>\n\n<div style=\"background-color: #efeff4\" *ngIf=\"data && data.length > 0\">\n\n<p style=\"padding: 10px 10px\">{{ text.all_store_deliver }} {{ searchQ }}</p>\n\n<ion-row *ngFor=\"let store of data\" (click)=\"item(store)\" style=\"background-color: white;padding: 0px 10px;margin-bottom: 2%\">\n<ion-col size=\"6\"><img src=\"{{ store.img }}\" style=\"border-radius: 10px\">\n<ion-badge style=\"position: absolute;z-index: 99;top:0px;left:0px\" *ngIf=\"store.rating > 0\">{{ store.rating }} <ion-icon name=\"star\"></ion-icon></ion-badge>\n</ion-col>\n\n<ion-col size=\"6\">\n\n<ion-row>\n\n<ion-col size=\"12\" style=\"color:black;font-weight: bold\">{{ store.name }}</ion-col>\n<ion-col size=\"12\" style=\"margin-top: -5%\"><small style=\"color:#a9a9a9\">{{ store.address }}</small></ion-col>\n<ion-col size=\"12\" *ngIf=\"!store.open\"><small style=\"color:red\">{{ text.store_close }}</small></ion-col>\n\n</ion-row>\n\n</ion-col>\n</ion-row>\n</div>\n\n<div *ngIf=\"trend && trend.length > 0\" class=\"ion-padding\">\n\n<p>{{ text.trend_search }}</p>\n<ion-item detail routerDirection=\"forward\" *ngFor=\"let t of trend\" routerLink=\"/item/{{ t.id }}/0\" lines=\"none\">\n  <ion-avatar slot=\"start\">\n    <img src=\"{{ t.img }}\">\n  </ion-avatar>\n  <ion-label>\n  {{ t.name }}\n  </ion-label>\n</ion-item>\n\n\n</div>\n\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_search_search_module_ts.js.map