"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_signup_signup_module_ts"],{

/***/ 50159:
/*!*************************************************!*\
  !*** ./src/app/signup/signup-routing.module.ts ***!
  \*************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SignupPageRoutingModule": () => (/* binding */ SignupPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _signup_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./signup.page */ 80771);




const routes = [
    {
        path: '',
        component: _signup_page__WEBPACK_IMPORTED_MODULE_0__.SignupPage
    }
];
let SignupPageRoutingModule = class SignupPageRoutingModule {
};
SignupPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], SignupPageRoutingModule);



/***/ }),

/***/ 77648:
/*!*****************************************!*\
  !*** ./src/app/signup/signup.module.ts ***!
  \*****************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SignupPageModule": () => (/* binding */ SignupPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _signup_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./signup-routing.module */ 50159);
/* harmony import */ var _signup_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./signup.page */ 80771);







let SignupPageModule = class SignupPageModule {
};
SignupPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_2__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_3__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_4__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_5__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonicModule,
            _signup_routing_module__WEBPACK_IMPORTED_MODULE_0__.SignupPageRoutingModule
        ],
        declarations: [_signup_page__WEBPACK_IMPORTED_MODULE_1__.SignupPage]
    })
], SignupPageModule);



/***/ }),

/***/ 80771:
/*!***************************************!*\
  !*** ./src/app/signup/signup.page.ts ***!
  \***************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "SignupPage": () => (/* binding */ SignupPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _signup_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./signup.page.html?ngResource */ 31998);
/* harmony import */ var _signup_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./signup.page.scss?ngResource */ 92444);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic/angular */ 93819);







let SignupPage = class SignupPage {
    constructor(route, server, toastController, nav, loadingController) {
        this.route = route;
        this.server = server;
        this.toastController = toastController;
        this.nav = nav;
        this.loadingController = loadingController;
        this.hasTerm = false;
        this.country = 91;
        this.text = JSON.parse(localStorage.getItem('app_text'));
        this.setting = JSON.parse(localStorage.getItem('setting'));
        this.countrys = JSON.parse(localStorage.getItem('country'));
    }
    ngOnInit() {
    }
    term() {
        this.hasTerm = this.hasTerm == true ? false : true;
    }
    signup(data) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                message: '',
                spinner: 'bubbles',
                duration: 3000
            });
            yield loading.present();
            this.server.signup(data).subscribe((response) => {
                console.log(response.otp);
                if (response.msg != "done") {
                    this.presentToast(this.text.signup_error);
                }
                else {
                    if (response.otp > 0) {
                        this.otp = response.otp;
                        this.user_id = response.user.id;
                        if (response.codeSent == 1) {
                            this.codeSent = data.email;
                        }
                        else {
                            this.codeSent = data.phone;
                        }
                    }
                    else {
                        localStorage.setItem('user_id', response.user.id);
                        localStorage.setItem('user_data', JSON.stringify(response.user));
                        if (localStorage.getItem('cart_no') && localStorage.getItem('cart_no') != undefined) {
                            this.nav.navigateBack('/cart');
                        }
                        else {
                            this.nav.navigateRoot('/account');
                        }
                    }
                }
                loading.dismiss();
            });
        });
    }
    verify(data) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            if (data.vcode != this.otp) {
                return this.presentToast("Please enter valid OTP");
            }
            const loading = yield this.loadingController.create({
                message: '',
                spinner: 'bubbles',
                duration: 4000
            });
            yield loading.present();
            this.server.verifyUser(this.user_id).subscribe((response) => {
                localStorage.setItem('user_id', response.user.id);
                localStorage.setItem('user_data', JSON.stringify(response.user));
                if (localStorage.getItem('cart_no') && localStorage.getItem('cart_no') != undefined) {
                    this.nav.navigateBack('/cart');
                }
                else {
                    this.nav.navigateRoot('/account');
                }
                loading.dismiss();
            });
        });
    }
    presentToast(txt) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__awaiter)(this, void 0, void 0, function* () {
            const toast = yield this.toastController.create({
                message: txt,
                duration: 3000,
                position: 'top',
                mode: 'ios',
                color: 'dark'
            });
            toast.present();
        });
    }
};
SignupPage.ctorParameters = () => [
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__.ActivatedRoute },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.ToastController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_5__.LoadingController }
];
SignupPage = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_6__.Component)({
        selector: 'app-signup',
        template: _signup_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_signup_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], SignupPage);



/***/ }),

/***/ 92444:
/*!****************************************************!*\
  !*** ./src/app/signup/signup.page.scss?ngResource ***!
  \****************************************************/
/***/ ((module) => {

module.exports = "ion-content {\n  --background:var(--ion-color-light);\n}\n\nion-list {\n  border-radius: 10px;\n}\n\nion-item {\n  border-radius: 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNpZ251cC5wYWdlLnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFFRSxtQ0FBQTtBQUFGOztBQUdBO0VBRUUsbUJBQUE7QUFERjs7QUFJQTtFQUVFLG1CQUFBO0FBRkYiLCJmaWxlIjoic2lnbnVwLnBhZ2Uuc2NzcyIsInNvdXJjZXNDb250ZW50IjpbImlvbi1jb250ZW50XG57XG4gIC0tYmFja2dyb3VuZDp2YXIoLS1pb24tY29sb3ItbGlnaHQpO1xufVxuXG5pb24tbGlzdFxue1xuICBib3JkZXItcmFkaXVzOjEwcHg7XG59XG5cbmlvbi1pdGVtXG57XG4gIGJvcmRlci1yYWRpdXM6MTBweDtcbn0iXX0= */";

/***/ }),

/***/ 31998:
/*!****************************************************!*\
  !*** ./src/app/signup/signup.page.html?ngResource ***!
  \****************************************************/
/***/ ((module) => {

module.exports = "<ion-header class=\"ion-no-border\">\n<ion-toolbar color=\"primary\">\n<ion-buttons slot=\"start\">\n<ion-back-button></ion-back-button>\n</ion-buttons>\n</ion-toolbar>\n</ion-header>\n\n<ion-content *ngIf=\"text && setting\" class=\"ion-padding\">\n\n<span *ngIf=\"!otp\">\n<h1 align=\"center\">{{ text.signup_title }}</h1>\n<p align=\"center\">{{ text.signup_desc }}</p>\n<br>\n\n<form #form=\"ngForm\" (ngSubmit)=\"signup(form.value)\">\n\n<ion-item lines=\"none\" mode=\"md\">\n  <ion-label position=\"floating\">{{ text.signup_name }}</ion-label>\n  <ion-input type=\"text\" ngModel name=\"name\" required></ion-input>\n</ion-item>\n\n<ion-row class=\"brdr\" style=\"background: white;\">\n<ion-col size=\"6\" *ngIf=\"countrys\">\n<ion-select placeholder=\"{{ text.country }}\" [(ngModel)]=\"country\" name=\"country\" required interface=\"action-sheet\" mode=\"md\">\n<ion-select-option value=\"{{ c.code }}\" *ngFor=\"let c of countrys\">{{ c.name }} (+{{ c.code }})</ion-select-option>\n</ion-select>\n</ion-col>\n<ion-col size=\"6\"><ion-input type=\"tel\" [(ngModel)]=\"phone\" maxlength=\"12\" minlength=\"9\" name=\"phone\" required placeholder=\"{{ text.signup_phone }}\"></ion-input></ion-col>\n</ion-row>\n\n<ion-item lines=\"none\" mode=\"md\">\n  <ion-label position=\"floating\">{{ text.signup_email }}</ion-label>\n  <ion-input type=\"email\" ngModel name=\"email\" required></ion-input>\n</ion-item>\n\n<ion-item lines=\"none\" mode=\"md\">\n  <ion-label position=\"floating\">{{ text.rcode }}</ion-label>\n  <ion-input type=\"text\" ngModel name=\"rcode\"></ion-input>\n</ion-item>\n\n<ion-item lines=\"none\" mode=\"md\">\n  <ion-label position=\"floating\">{{ text.signup_password }}</ion-label>\n  <ion-input type=\"password\" ngModel name=\"password\" required></ion-input>\n</ion-item>\n\n<ion-item class=\"ion-text-wrap\" class=\"noBorder\" lines=\"none\" mode=\"md\">\n    <ion-label>{{ text.i_agree }} <a href=\"{{ setting.term }}\" target=\"_blank\">{{ text.terms }}</a></ion-label>\n    <ion-checkbox slot=\"start\" (ionChange)=\"term()\"></ion-checkbox>\n  </ion-item>\n\n<ion-button expand=\"block\" mode=\"ios\" type=\"submit\" [disabled]=\"!form.valid || !hasTerm\">{{ text.signup_btn }}</ion-button>\n\n</form>\n</span>\n\n<span *ngIf=\"otp\">\n<h1 align=\"center\" *ngIf=\"setting.verify_type == 3\">{{ text.verify_your_email }}</h1>\n<h1 align=\"center\" *ngIf=\"setting.verify_type != 3\">{{ text.verify_your_phone }}</h1>\n<p align=\"center\">{{ text.verify_code_sent }} {{ codeSent }}</p>\n<br>\n\n<form #form=\"ngForm\" (ngSubmit)=\"verify(form.value)\">\n\n<ion-item lines=\"none\" mode=\"md\">\n  <ion-label position=\"floating\">{{ text.enter_otp }}</ion-label>\n  <ion-input type=\"tel\" ngModel name=\"vcode\" required></ion-input>\n</ion-item>\n\n<ion-button expand=\"block\" mode=\"ios\" type=\"submit\" style=\"margin-top: 20px;\">{{ text.verify }}</ion-button>\n\n\n</form>\n</span>\n\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_signup_signup_module_ts.js.map