import { AccountPage } from './../account/account.page';
import { Component, NgZone, OnInit,ViewChild } from '@angular/core';
import { ServerService } from '../service/server.service';
import { NavController, Platform, LoadingController,AlertController, ModalController,ActionSheetController, ToastController } from '@ionic/angular';
import { MenuPage } from '../menu/menu.page';
import { NativeGeocoder, NativeGeocoderResult } from '@awesome-cordova-plugins/native-geocoder/ngx';
import { LangPage } from '../lang/lang.page';
import { SettingPage } from '../setting/setting.page';
import { CityPage } from '../city/city.page';
declare var google;
@Component({
  selector: 'app-header',
  templateUrl: './header.component.html',
  styleUrls: ['./header.component.scss'],
})


export class HeaderComponent implements OnInit {
  @ViewChild('content',{static : false}) private content: any;

  map: any;
  type:any;
  landmark:any;
  
  autocomplete: { input: string; };
  autocompleteItems: any[];
  GoogleAutocomplete: any;
  placeid: any;


  header_data:any;
  text:any;
  address:any;
  storeData:any = [];
  allData:any;
  stores:any;
  store_type = 0;
  logged_in = false;


  constructor(
    public modalController: ModalController,
    public server : ServerService,
    public loadingController: LoadingController,
    public nativeGeocoder: NativeGeocoder,
    public platform : Platform,
    public nav : NavController,
    public zone: NgZone,
    public toastController: ToastController,

    ) {

   this.text = JSON.parse(localStorage.getItem('app_text'));
   this.address = localStorage.getItem('current_add');

   this.GoogleAutocomplete = new google.maps.places.AutocompleteService();
   this.autocomplete = { input: '' };
   this.autocompleteItems = [];
  }

  ngOnInit()
  {
    if(localStorage.getItem('user_id') == 'null' || !localStorage.getItem('user_id') || localStorage.getItem('user_id') == undefined)
    {
    this.logged_in = false;
    }
    else
    {
      this.logged_in = true;
      let user_data  = JSON.parse(localStorage.getItem('user_data'));
      this.logged_in = user_data.name;
    }

  	this.loadData();
  }

  async loadData(id = 0,load = false)
  {
    this.server.homepage(id,this.store_type).subscribe((response:any) => {
  
    this.header_data       = response.data;

    console.log(this.header_data);


    localStorage.setItem('app_text', JSON.stringify(response.data.text));

    localStorage.setItem('setting', JSON.stringify(response.data.setting));

    localStorage.setItem('country', JSON.stringify(response.data.country));

    });
  }

  
  //wE CALL THIS FROM EACH ITEM.
  SelectSearchResult(item) {
    ///WE CAN CONFIGURE MORE COMPLEX FUNCTIONS SUCH AS UPLOAD DATA TO FIRESTORE OR LINK IT TO SOMETHING
    console.log(item);
    const geocoder = new google.maps.Geocoder();
    const infowindow = new google.maps.InfoWindow();


    this.placeid = item.place_id;

    // this.geocodePlaceId(geocoder,this.map,infowindow);

    this.nativeGeocoder.forwardGeocode(item.description)
  .then((result: NativeGeocoderResult[]) => 
  this.saveAddress(result[0].latitude,result[0].longitude,item.description)
  ).
  catch((error: any) => console.log(error));

    this.ClearAutocomplete();
  }

  saveAddress(lat,lng,address)
  {
  localStorage.setItem('current_lat',lat);
  localStorage.setItem('current_lng',lng);
  localStorage.setItem('current_add',address);
  }

  //lET'S BE CLEAN! THIS WILL JUST CLEAN THE LIST WHEN WE CLOSE THE SEARCH BAR.
  ClearAutocomplete(){
    this.autocompleteItems = []
    this.autocomplete.input = ''
  }

  //AUTOCOMPLETE, SIMPLY LOAD THE PLACE USING GOOGLE PREDICTIONS AND RETURNING THE ARRAY.
  UpdateSearchResults(){
    if (this.autocomplete.input == '') {
      this.autocompleteItems = [];
      return;
    }
    this.GoogleAutocomplete.getPlacePredictions({ input: this.autocomplete.input },
    (predictions, status) => {
      this.autocompleteItems = [];
      this.zone.run(() => {
        predictions.forEach((prediction) => {
          this.autocompleteItems.push(prediction);
        });
      });
    });
  }
  


  search()
  {
    localStorage.setItem('trend_data', JSON.stringify(this.header_data.trend));
    localStorage.setItem('all_data', JSON.stringify(this.header_data.search_data));

    this.nav.navigateForward('/search');
  }

  
async goTo(page)
{
 if(page == 'home')
 {
  this.nav.navigateRoot('home')
 }
 if(page == 'login')
 {
  this.nav.navigateForward('login')
 }
 if(page == 'cart')
 {
  this.nav.navigateForward('cart')
 }
 if(page == 'setting')
 {
  this.createModal(SettingPage,'setting_modal')
 }
 if( page == 'my')
 {
  this.modalController.dismiss();
  this.nav.navigateForward('my');
 }
 if( page == 'lang')
 {
  this.createModal(LangPage,'lang_modal')
 }
 if( page == 'city')
 {
  this.createModal(CityPage,'city_modal')
 }

 if( page == 'about')
 {
  this.nav.navigateForward('about')
 }

 if( page == 'contact')
 {
  this.nav.navigateForward('contact')
 }



}


async close()
{
  this.modalController.dismiss();
}

async createModal(component,cssClass)
{
  const modal = await this.modalController.create({
    component: component,
    cssClass: cssClass,
  });
  return await modal.present();
}

  
  async openAccount()
  {

    if(localStorage.getItem('user_id') && localStorage.getItem('user_id') != "null")
    {

      
      const modal = await this.modalController.create({
        component: AccountPage,
        cssClass: 'account_modal',
      });
      return await modal.present();
    }
    else{
      this.nav.navigateForward('login');
      this.presentToast(this.text.access_page);
    }
  }


  trimText(str,n = 25)
  {
      return (str.length > n) ? str.substr(0, n-1) + '...' : str;
  }


  async presentToast(txt) {
    const toast = await this.toastController.create({
      message: txt,
      duration: 3000,
      position : 'top',
      mode:'ios',
      color:'dark'
    });
    toast.present();
  }

  logout()
  {
  localStorage.setItem('user_id',null);
  localStorage.setItem('user_data',null);

  this.nav.navigateRoot('/home');
  }

}
