import { NativeGeocoder, NativeGeocoderResult } from '@awesome-cordova-plugins/native-geocoder/ngx';
import { Component, HostListener, NgZone, OnInit,ViewChild } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { ServerService } from '../service/server.service';
import { NavController,LoadingController,IonSlides,ToastController,ModalController,Platform,IonRouterOutlet } from '@ionic/angular';
import { OptionPage } from '../option/option.page';
import { Geolocation } from '@awesome-cordova-plugins/geolocation/ngx';
import { PhotoViewer } from '@awesome-cordova-plugins/photo-viewer/ngx';
import { LangPage } from '../lang/lang.page';

declare var google;

@Component({
  selector: 'app-item',
  templateUrl: './item.page.html',
  styleUrls: ['./item.page.scss'],
})
export class ItemPage implements OnInit {
@ViewChild('content',{static : false}) private content: any;

data:any;
fakeData = [1,2,3,4,5,6,7];
text:any;
store_id:any;
cate_id:any;
cart_no:any;
setting:any;
cart:any = [];
count:any;
hasSearch = false;
q:any;
type:any = 0;
subscription:any;
veg:any = 0;
nonveg:any = 0;
items:any = [];
landmark:any;
autocomplete: { input: string; };
autocompleteItems: any[];
GoogleAutocomplete: any;
placeid: any;
address:any;
is_mobile: boolean = false;
  constructor(private routerOutlet: IonRouterOutlet,
    public platform : Platform,
    private photoViewer: PhotoViewer,
    private activatedRoute: ActivatedRoute,
    public server : ServerService,
    public loadingController: LoadingController,
    public nav : NavController,
    public modalController: ModalController, public toastController: ToastController,
    public geolocation: Geolocation,
    public zone: NgZone,
    public nativeGeocoder: NativeGeocoder,
    ) {

   this.store_id  = this.activatedRoute.snapshot.paramMap.get('id');
   this.type      = this.activatedRoute.snapshot.paramMap.get('type');
   this.cate_id   = 0;
    
   if(!localStorage.getItem('current_lat') || localStorage.getItem('current_lat') == undefined)
   {
      this.geolocation.getCurrentPosition().then((resp:any) => {
   
          localStorage.setItem("current_lat",resp.coords.latitude);
          localStorage.setItem("current_lng",resp.coords.longitude);

      }).catch((error) => {
        console.log('Error getting location', error);
      });
   }

  }

  ionViewDidEnter()
  {

    if (localStorage.getItem('lid') == null || localStorage.getItem('lid') == 'null' || localStorage.getItem('lid') == undefined)
    {
     localStorage.setItem('lid','9');
    }

    this.subscription = this.platform.backButton.subscribe(()=>{
          
    this.modalController.dismiss({data:true});
    
    });
  }

  ionViewWillLeave(){
      
      this.subscription.unsubscribe();
  }


  filterData()
  {    
    this.items = [];

    for(var i = 0;i<this.data.item.length;i++)
    {
      if(this.nonveg)
      {
        if(this.data.item[i].food_type == 2)
        {
          this.items.push(this.data.item[i]);
        }
      }

      if(this.veg)
      {
        if(this.data.item[i].food_type == 1)
        {
          this.items.push(this.data.item[i]);
        }
      }

      if(!this.veg && !this.nonveg)
      {
        this.items.push(this.data.item[i]);
      }
    }

    console.log('items_now',this.items);
  }

  ngOnInit()
  {
    const width = this.platform.width();
    this.chk_device_width(width);

    this.loadData();

    if (localStorage.getItem('cart_no') == 'null' || localStorage.getItem('cart_no') == undefined) {
      
      this.cart_no = Math.floor(Math.random() * 2000000000) + 1;
      localStorage.setItem('cart_no', this.cart_no);
    }
    else {
      this.cart_no = localStorage.getItem('cart_no');
    }

    this.server.cartCount(this.cart_no).subscribe((response: any) => {

      this.count = response.data;
      this.cart = response.cart;


    });
  }

  // for background image on mobile device for the top black portion
  @HostListener('window:resize',['$event'])
  private onResize(event)
  {
    const newWidth = event.target.innerWidth;
    this.chk_device_width(newWidth);
  }

  chk_device_width(newWidth)
  {
    if(newWidth <= 568)
    {
      this.is_mobile = true;
    }
    else
    {
      this.is_mobile = false;
    }
  }

  viewImg(img,type = 0)
  {
    if(type == 1)
    {
      this.photoViewer.show(img[0]);
    }
    else
    {
      this.photoViewer.show(img);
    }
  }

  showSearch()
  {
    this.hasSearch = this.hasSearch == true ? false : true;
    this.cate_id = 0;
  }

  async loadData()
  {
    this.server.item(this.store_id).subscribe((response:any) => {
  
    this.data    = response.data;
    this.text    = response.text;
    this.setting = response.setting;
    this.items   = this.data.item;
    
    localStorage.setItem('app_text', JSON.stringify(response.text));
    localStorage.setItem('setting', JSON.stringify(response.setting));

    console.table(response.data);
    console.table(response.text);
    });
  }

  async showOption(item) {
    const modal = await this.modalController.create({
      component: OptionPage,
      animated: true,
      mode: 'ios',
      cssClass: 'my-custom-modal-css',
      backdropDismiss: true,
      swipeToClose: true,
      presentingElement: this.routerOutlet.nativeEl,
      componentProps: {
        'item': item,
        'currency': this.setting.currency
      }

    });

    modal.onDidDismiss().then(data => {

      if (data.data.id) {
        this.addToCart(data.data.id, data.data.price, data.data.type, data.data.addonData);
      }

    })

    return await modal.present();
  }

  addToCart(id, price, type = 0, addon = []) {
    this.presentToast(this.text.add_cart_msg);

    var allData = { cart_no: this.cart_no, id: id, price: price, qtype: type, type: 0, addon: addon };

    this.server.addToCart(allData).subscribe((response: any) => {

      console.log(response);

      if(response.data.error == true)
      {
        this.presentToast(this.text.out_stock_msg);
      }
      else
      {
        this.count = response.data.count;
        this.cart = response.data.cart;
      }

    });
  }

  async presentToast(txt) {
    const toast = await this.toastController.create({
      message: txt,
      duration: 2000
    });
    toast.present();
  }

  hasCart(id) {
    
    for (var i = 0; i < this.cart.length; i++) {
      if (this.cart[i].item_id == id) {
        return this.cart[i].qty;
      }
    }

    return false;
  }

  async updateCart(id, type = 0) {
    this.presentToast(this.text.remove_cart_msg);

    this.server.updateCart(id, type + "?cart_no=" + this.cart_no + "&lid=" + localStorage.getItem('lid')).subscribe((response: any) => {

      this.cart = response.data;
      this.count = response.count;

    });
  }

  info()
  {
    localStorage.setItem('store_data', JSON.stringify(this.data.store));

    this.nav.navigateForward('/info');
  }



  //wE CALL THIS FROM EACH ITEM.
  SelectSearchResult(item) {
    ///WE CAN CONFIGURE MORE COMPLEX FUNCTIONS SUCH AS UPLOAD DATA TO FIRESTORE OR LINK IT TO SOMETHING
    console.log(item);
    const geocoder = new google.maps.Geocoder();
    const infowindow = new google.maps.InfoWindow();


    this.placeid = item.place_id;

    // this.geocodePlaceId(geocoder,this.map,infowindow);

    this.nativeGeocoder.forwardGeocode(item.description)
  .then((result: NativeGeocoderResult[]) => 
  this.saveAddress(result[0].latitude,result[0].longitude,item.description)
  ).
  catch((error: any) => console.log(error));

    this.ClearAutocomplete();
  }

  saveAddress(lat,lng,address)
  {
  localStorage.setItem('current_lat',lat);
  localStorage.setItem('current_lng',lng);
  localStorage.setItem('current_add','Kartarpur Punjab');
  }
  
  // geocodePlaceId(geocoder, map, infowindow) {
  //       geocoder.geocode(
  //         {
  //           placeId: this.placeid
  //         },
  //         (results, status) => {
  //           if (status === "OK") {
  //             if (results[0]) {
              
  //             this.map.setZoom(16);
  //             this.map.setCenter(results[0].geometry.location);

  //             } else {
  //               window.alert("No results found");
  //             }
  //           } else {
  //             window.alert("Geocoder failed due to: " + status);
  //           }
  //         }
  //       );
  //     }
  
  //lET'S BE CLEAN! THIS WILL JUST CLEAN THE LIST WHEN WE CLOSE THE SEARCH BAR.
  ClearAutocomplete(){
    this.autocompleteItems = []
    this.autocomplete.input = ''
  }

  //AUTOCOMPLETE, SIMPLY LOAD THE PLACE USING GOOGLE PREDICTIONS AND RETURNING THE ARRAY.
  UpdateSearchResults(){
    if (this.autocomplete.input == '') {
      this.autocompleteItems = [];
      return;
    }
    this.GoogleAutocomplete.getPlacePredictions({ input: this.autocomplete.input },
    (predictions, status) => {
      this.autocompleteItems = [];
      this.zone.run(() => {
        predictions.forEach((prediction) => {
          this.autocompleteItems.push(prediction);
        });
      });
    });
  }
  
  search()
  {
    localStorage.setItem('trend_data', JSON.stringify(this.data.trend));
    localStorage.setItem('all_data', JSON.stringify(this.data.search_data));

    this.nav.navigateForward('/search');
  }

  async createModal()
{
  const modal = await this.modalController.create({
    component: LangPage,
    cssClass: 'lang_modal',
  });
  return await modal.present();
}

}
