import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { ServerService } from '../service/server.service';
import { ToastController, NavController, Platform, LoadingController, AlertController, ModalController } from '@ionic/angular';

@Component({
  selector: 'app-my',
  templateUrl: './my.page.html',
  styleUrls: ['./my.page.scss'],
})

export class MyPage implements OnInit {
  
  data:any;
  udata:any;
  text:any;
  oid:any;
  orders:any;
  type:any = 'all';

  constructor(private route: ActivatedRoute,public server : ServerService,public toastController: ToastController,private nav: NavController,public loadingController: LoadingController,public alertController: AlertController,private modalController: ModalController){

  this.text = JSON.parse(localStorage.getItem('app_text'));

   if(localStorage.getItem('user_data') && localStorage.getItem('user_data') != undefined)
   {
     this.udata = JSON.parse(localStorage.getItem('user_data'));
   }

  }

  ngOnInit()
  {
    if(this.udata && this.udata.phone)
    {
      this.loadData();
    }
  }

  show(id)
  {
    this.oid = this.oid == id ? null : id;
  }
 
  ionViewWillEnter()
  {
  	
  }

  async loadData()
  {	
  	console.log("loading");

    const loading = await this.loadingController.create({
      message: '',
      spinner : 'bubbles'
      
    });
    await loading.present();

    this.server.my(localStorage.getItem('user_id')).subscribe((response:any) => {
  
    this.data = response.data;
    this.orders  = response.data;

    console.log('order_page_data',response)

    loading.dismiss();

    });
  }

  async cancelOrder(id)
  { 
    console.log("loading");

    const loading = await this.loadingController.create({
      message: '',
      spinner : 'bubbles'
      
    });
    await loading.present();

    this.server.cancelOrder(id).subscribe((response:any) => {
  
    this.data = response.data;

    console.log(response.data);

    loading.dismiss();

    });
  }

  async presentAlertConfirm(id) {
    const alert = await this.alertController.create({
      cssClass: 'my-custom-class',
      header: 'Are you sure?',
      message: 'Want to cancel this order?',
      mode:'ios',
      buttons: [
        {
          text: 'Cancel',
          role: 'cancel',
          cssClass: 'secondary',
          handler: (blah) => {
            console.log('Confirm Cancel: blah');
          }
        }, {
          text: 'Yes',
          handler: () => {
          
          this.cancelOrder(id);

          }
        }
      ]
    });

    await alert.present();
  }

  filterData(type = 'all')
  {    
    this.type = type;
    this.orders = [];

    for(var i = 0;i<this.data.length;i++)
    {
      if(type == 'all')
      {
        this.orders = this.data;
      }
      
      if(type == '0')
      {
        if(this.data[i].st != '0' &&  this.data[i].st != '2' && this.data[i].st != '5')
        {
          this.orders.push(this.data[i]);
        }
      }
  
        if(type == '2')
        {
          if(this.data[i].st == 2)
          {
            this.orders.push(this.data[i]);
          }
        }
  
        if(type == '5')
        {
          if(this.data[i].st == 5)
          {
            this.orders.push(this.data[i]);
          }
        }

      // if(!this.veg && !this.nonveg)
      // {
      //   this.orders.push(this.data.item[i]);
      // }
    }

    console.log('orders now '+type,this.orders);
  }

  async close()
  {
    this.modalController.dismiss();
  }

  statusColor(status)
  {
    if(status == 0)
    {
      return 'info';
    }
    else if(status == 2)
    {
      return 'danger';
    }
    else if(status == 1 || status == 3 || status == 4)
    {
      return 'warning'
    }
    else if(status == 5)
    {
      return 'success'
    }
    else
    {
      return 'dark'
    }
  }

  async presentToast(txt) {
    const toast = await this.toastController.create({
      message: txt,
      duration: 3000,
      position : 'top',
      mode:'ios',
      color:'dark'
    });
    toast.present();
  }
}
