"use strict";
(self["webpackChunkapp"] = self["webpackChunkapp"] || []).push([["src_app_item_item_module_ts"],{

/***/ 69459:
/*!*********************************************!*\
  !*** ./src/app/item/item-routing.module.ts ***!
  \*********************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ItemPageRoutingModule": () => (/* binding */ ItemPageRoutingModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _item_page__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./item.page */ 30171);




const routes = [
    {
        path: '',
        component: _item_page__WEBPACK_IMPORTED_MODULE_0__.ItemPage
    }
];
let ItemPageRoutingModule = class ItemPageRoutingModule {
};
ItemPageRoutingModule = (0,tslib__WEBPACK_IMPORTED_MODULE_1__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_2__.NgModule)({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule.forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_3__.RouterModule],
    })
], ItemPageRoutingModule);



/***/ }),

/***/ 4672:
/*!*************************************!*\
  !*** ./src/app/item/item.module.ts ***!
  \*************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ItemPageModule": () => (/* binding */ ItemPageModule)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @angular/common */ 36362);
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @angular/forms */ 90587);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _item_routing_module__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./item-routing.module */ 69459);
/* harmony import */ var _item_page__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./item.page */ 30171);
/* harmony import */ var ng2_search_filter__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ng2-search-filter */ 9991);








let ItemPageModule = class ItemPageModule {
};
ItemPageModule = (0,tslib__WEBPACK_IMPORTED_MODULE_3__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_4__.NgModule)({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_5__.CommonModule,
            _angular_forms__WEBPACK_IMPORTED_MODULE_6__.FormsModule,
            _ionic_angular__WEBPACK_IMPORTED_MODULE_7__.IonicModule,
            _item_routing_module__WEBPACK_IMPORTED_MODULE_0__.ItemPageRoutingModule,
            ng2_search_filter__WEBPACK_IMPORTED_MODULE_2__.Ng2SearchPipeModule
        ],
        declarations: [_item_page__WEBPACK_IMPORTED_MODULE_1__.ItemPage]
    })
], ItemPageModule);



/***/ }),

/***/ 30171:
/*!***********************************!*\
  !*** ./src/app/item/item.page.ts ***!
  \***********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "ItemPage": () => (/* binding */ ItemPage)
/* harmony export */ });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! tslib */ 42321);
/* harmony import */ var _item_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./item.page.html?ngResource */ 74534);
/* harmony import */ var _item_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./item.page.scss?ngResource */ 67981);
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! @angular/core */ 3184);
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/router */ 52816);
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../service/server.service */ 76419);
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! @ionic/angular */ 93819);
/* harmony import */ var _option_option_page__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../option/option.page */ 31355);
/* harmony import */ var _awesome_cordova_plugins_geolocation_ngx__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @awesome-cordova-plugins/geolocation/ngx */ 36457);









let ItemPage = class ItemPage {
    constructor(routerOutlet, platform, activatedRoute, server, loadingController, nav, modalController, toastController, geolocation) {
        this.routerOutlet = routerOutlet;
        this.platform = platform;
        this.activatedRoute = activatedRoute;
        this.server = server;
        this.loadingController = loadingController;
        this.nav = nav;
        this.modalController = modalController;
        this.toastController = toastController;
        this.geolocation = geolocation;
        this.fakeData = [1, 2, 3, 4, 5, 6, 7];
        this.cart = [];
        this.hasSearch = false;
        this.type = 0;
        this.veg = 0;
        this.nonveg = 0;
        this.items = [];
        this.store_id = this.activatedRoute.snapshot.paramMap.get('id');
        this.type = this.activatedRoute.snapshot.paramMap.get('type');
        this.cate_id = 0;
        if (!localStorage.getItem('current_lat') || localStorage.getItem('current_lat') == undefined) {
            this.geolocation.getCurrentPosition().then((resp) => {
                localStorage.setItem("current_lat", resp.coords.latitude);
                localStorage.setItem("current_lng", resp.coords.longitude);
            }).catch((error) => {
                console.log('Error getting location', error);
            });
        }
    }
    ionViewDidEnter() {
        this.subscription = this.platform.backButton.subscribe(() => {
            this.modalController.dismiss({ data: true });
        });
    }
    ionViewWillLeave() {
        this.subscription.unsubscribe();
    }
    filterData() {
        this.items = [];
        for (var i = 0; i < this.data.item.length; i++) {
            if (this.nonveg) {
                if (this.data.item[i].food_type == 2) {
                    this.items.push(this.data.item[i]);
                }
            }
            if (this.veg) {
                if (this.data.item[i].food_type == 1) {
                    this.items.push(this.data.item[i]);
                }
            }
            if (!this.veg && !this.nonveg) {
                this.items.push(this.data.item[i]);
            }
        }
    }
    ngOnInit() {
        this.loadData();
        if (localStorage.getItem('cart_no') == 'null' || localStorage.getItem('cart_no') == undefined) {
            this.cart_no = Math.floor(Math.random() * 2000000000) + 1;
            localStorage.setItem('cart_no', this.cart_no);
        }
        else {
            this.cart_no = localStorage.getItem('cart_no');
        }
        this.server.cartCount(this.cart_no).subscribe((response) => {
            this.count = response.data;
            this.cart = response.cart;
        });
    }
    viewImg(img, type = 0) {
    }
    showSearch() {
        this.hasSearch = this.hasSearch == true ? false : true;
        this.cate_id = 0;
    }
    loadData() {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            this.server.item(this.store_id).subscribe((response) => {
                this.data = response.data;
                this.text = response.text;
                this.setting = response.setting;
                this.items = this.data.item;
                localStorage.setItem('app_text', JSON.stringify(response.text));
                localStorage.setItem('setting', JSON.stringify(response.setting));
            });
        });
    }
    showOption(item) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            const modal = yield this.modalController.create({
                component: _option_option_page__WEBPACK_IMPORTED_MODULE_3__.OptionPage,
                animated: true,
                mode: 'ios',
                cssClass: 'my-custom-modal-css',
                backdropDismiss: true,
                swipeToClose: true,
                componentProps: {
                    'item': item,
                    'currency': this.setting.currency
                }
            });
            modal.onDidDismiss().then(data => {
                if (data.data.id) {
                    this.addToCart(data.data.id, data.data.price, data.data.type, data.data.addonData);
                }
            });
            return yield modal.present();
        });
    }
    addToCart(id, price, type = 0, addon = []) {
        this.presentToast(this.text.add_cart_msg);
        var allData = { cart_no: this.cart_no, id: id, price: price, qtype: type, type: 0, addon: addon };
        this.server.addToCart(allData).subscribe((response) => {
            console.log(response);
            if (response.data.error == true) {
                this.presentToast(this.text.out_stock_msg);
            }
            else {
                this.count = response.data.count;
                this.cart = response.data.cart;
            }
        });
    }
    presentToast(txt) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            const toast = yield this.toastController.create({
                message: txt,
                duration: 2000
            });
            toast.present();
        });
    }
    hasCart(id) {
        for (var i = 0; i < this.cart.length; i++) {
            if (this.cart[i].item_id == id) {
                return this.cart[i].qty;
            }
        }
        return false;
    }
    updateCart(id, type = 0) {
        return (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__awaiter)(this, void 0, void 0, function* () {
            this.presentToast(this.text.remove_cart_msg);
            this.server.updateCart(id, type + "?cart_no=" + this.cart_no + "&lid=" + localStorage.getItem('lid')).subscribe((response) => {
                this.cart = response.data;
                this.count = response.count;
            });
        });
    }
    info() {
        localStorage.setItem('store_data', JSON.stringify(this.data.store));
        this.nav.navigateForward('/info');
    }
};
ItemPage.ctorParameters = () => [
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.IonRouterOutlet },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.Platform },
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_7__.ActivatedRoute },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_2__.ServerService },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.LoadingController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.NavController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.ModalController },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_6__.ToastController },
    { type: _awesome_cordova_plugins_geolocation_ngx__WEBPACK_IMPORTED_MODULE_4__.Geolocation }
];
ItemPage.propDecorators = {
    content: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_8__.ViewChild, args: ['content', { static: false },] }]
};
ItemPage = (0,tslib__WEBPACK_IMPORTED_MODULE_5__.__decorate)([
    (0,_angular_core__WEBPACK_IMPORTED_MODULE_8__.Component)({
        selector: 'app-item',
        template: _item_page_html_ngResource__WEBPACK_IMPORTED_MODULE_0__,
        styles: [_item_page_scss_ngResource__WEBPACK_IMPORTED_MODULE_1__]
    })
], ItemPage);



/***/ }),

/***/ 67981:
/*!************************************************!*\
  !*** ./src/app/item/item.page.scss?ngResource ***!
  \************************************************/
/***/ ((module) => {

module.exports = ".quantityinput {\n  padding: 2px 2px;\n  text-align: center;\n  border: 0px solid #ccc;\n  background: #fff;\n  width: 28px;\n  font-size: 14px;\n}\n\n.quantitybtn .sign {\n  padding: 7px 2px;\n  width: 20px;\n  text-align: center;\n  cursor: pointer;\n  font-weight: bold;\n  outline: none;\n}\n\n.quantitybtn .plus {\n  background: #f44336;\n  border: 1px solid #f44336;\n  color: #fff;\n  border-radius: 5px 0px 0px 5px;\n}\n\n.quantitybtn .minus {\n  background: #009688;\n  border: 1px solid #009688;\n  color: #fff;\n  border-radius: 0px 5px 5px 0px;\n}\n\nb {\n  color: black;\n}\n\n.topHeader {\n  margin-top: -20%;\n  background-color: white;\n  border-top-left-radius: 20px;\n  border-top-right-radius: 20px;\n  position: relative;\n}\n\n.add {\n  font-size: 12px !important;\n  border: 1px solid #bdbdbd;\n  padding: 6px 15px;\n  border-radius: 10px;\n}\n\nion-content {\n  --background:#efeff4 ;\n}\n\nion-item {\n  border-radius: 10px;\n  margin-top: 10px;\n}\n\nh1 {\n  font-family: \"Poppins\", sans-serif !important;\n  margin-top: 0%;\n}\n\np {\n  font-family: \"Poppins\", sans-serif !important;\n  line-height: 0.2;\n  font-size: 14px;\n  color: gray;\n}\n\n.sname {\n  font-family: \"Poppins\", sans-serif !important;\n}\n/*# sourceMappingURL=data:application/json;base64,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 */";

/***/ }),

/***/ 74534:
/*!************************************************!*\
  !*** ./src/app/item/item.page.html?ngResource ***!
  \************************************************/
/***/ ((module) => {

module.exports = "<ion-header class=\"ion-no-border\">\n<ion-toolbar color=\"primary\">\n<ion-buttons slot=\"start\">\n<ion-back-button></ion-back-button>\n</ion-buttons>\n\n<ion-buttons slot=\"end\" *ngIf=\"text\">\n<ion-button mode=\"ios\" (click)=\"info()\"><ion-icon name=\"arrow-redo-outline\"></ion-icon> &nbsp;{{ text.view_info }}</ion-button>\n</ion-buttons>\n\n</ion-toolbar>\n</ion-header>\n\n<ion-content>\n<!--Display loading-->\n<ion-list id=\"skeleton\" *ngIf=\"!data\">\n<ion-list-header>\n<ion-skeleton-text animated style=\"width: 40%\"></ion-skeleton-text>\n</ion-list-header>\n\n<ion-item *ngFor=\"let fake of fakeData\">\n<ion-thumbnail slot=\"start\">\n<ion-skeleton-text></ion-skeleton-text>\n</ion-thumbnail>\n<ion-label>\n<h3>\n<ion-skeleton-text animated style=\"width: 80%\"></ion-skeleton-text>\n</h3>\n<p>\n<ion-skeleton-text animated style=\"width: 60%\"></ion-skeleton-text>\n</p>\n<p>\n<ion-skeleton-text animated style=\"width: 30%\"></ion-skeleton-text>\n</p>\n</ion-label>\n</ion-item>\n\n</ion-list>\n\n <ion-fab horizontal=\"center\" vertical=\"bottom\" slot=\"fixed\" *ngIf=\"count > 0\" routerLink=\"/cart\"\n        routerDirection=\"forward\">\n        <ion-fab-button color=\"primary\" edge=\"true\">\n            <ion-icon name=\"cart\"></ion-icon> {{ count }}\n        </ion-fab-button>\n    </ion-fab>\n\n<!--Main content start here-->\n<div *ngIf=\"data && text\" style=\"margin-top:0%\">\n<img src=\"{{ data.store.img }}\">\n\n<div class=\"topHeader\">\n\n<div class=\"ion-padding\">\n<h1>{{ data.store.name }} <ion-badge *ngIf=\"data.store.rating > 0\" style=\"float: right;\">{{ data.store.rating }} <ion-icon name=\"star\"></ion-icon></ion-badge></h1>\n\n<p><ion-icon name=\"pricetag-outline\" color=\"primary\"></ion-icon> {{ data.store.cates }}</p>\n\n<p><ion-icon name=\"location-outline\" color=\"primary\"></ion-icon> {{ data.store.address }}</p>\n\n<p><ion-icon name=\"wallet-outline\" color=\"primary\"></ion-icon> {{ text.avg_per }} {{ setting.currency }}{{ data.store.per_person }}</p>\n</div>\n\n<ion-searchbar mode=\"ios\" [(ngModel)]=\"q\" *ngIf=\"type == 0\" style=\"margin-top: -5%;\"></ion-searchbar>\n\n<ion-row *ngIf=\"type == 0 && data.store.veg_nonveg == 0\" style=\"margin-top: -5%;\"> \n<ion-col size=\"6\">\n<ion-item lines=\"none\">\n<ion-label style=\"font-size: 12px;\">{{ text.veg }}</ion-label>\n<ion-toggle [(ngModel)]=\"veg\" color=\"success\" slot=\"start\" (ionChange)=\"filterData()\"></ion-toggle>\n</ion-item>\n</ion-col>\n\n<ion-col size=\"6\">\n<ion-item lines=\"none\" mode=\"md\">\n<ion-label style=\"font-size: 12px;\" class=\"item-text-wrap\">{{ text.nonveg }}</ion-label>\n<ion-toggle [(ngModel)]=\"nonveg\" color=\"success\" slot=\"start\" (ionChange)=\"filterData()\"></ion-toggle>\n</ion-item>\n</ion-col>\n</ion-row>\n\n\n\n</div>\n\n<ion-row style=\"padding: 0px 10px;\">\n\n<ion-col size=\"12\" *ngIf=\"type == 1\">\n<br>\n<ion-row style=\"background: #fbfbfb;padding:10px 10px\">\n<ion-col size=\"12\"><b><ion-icon name=\"location-outline\"></ion-icon> {{ text.location_title }} <span style=\"float:right\"><a style=\"font-size:12px\" href=\"http://maps.google.com/?q={{ data.store.lat }},{{ data.store.lng }}\" target=\"_blank\">{{ text.direction }}</a></span></b><br>\n\n<span style=\"font-size:12px;margin-left: 20px;margin-top: 8px\">{{ data.store.address }}</span>\n\n</ion-col>\n</ion-row>\n\n<ion-row style=\"background: #fbfbfb;padding:10px 10px;margin-top:10px\">\n<ion-col size=\"12\"><b><ion-icon name=\"call-outline\"></ion-icon> {{ text.contact_no }} <span style=\"float:right\"><a style=\"font-size:12px\" href=\"tel:{{ data.store.phone }}\" target=\"_blank\">{{ text.call_now }}</a></span></b><br>\n\n<span style=\"font-size:12px;margin-left: 20px;margin-top: 8px\">{{ data.store.phone }}</span>\n\n</ion-col>\n</ion-row>\n\n<ion-row style=\"background: #fbfbfb;padding:10px 10px;margin-top:10px\">\n<ion-col size=\"12\"><b><ion-icon name=\"time-outline\"></ion-icon> {{ text.timing }}</b>\n<br>\n<span style=\"font-size:12px;margin-left: 20px;margin-top: 8px\">{{ data.store.today_open }} - {{ data.store.today_close }}</span>\n\n</ion-col>\n</ion-row>\n\n<ion-row style=\"background: #fbfbfb;padding:10px 10px;margin-top:10px\">\n<ion-col size=\"12\"><b><ion-icon name=\"cash-outline\"></ion-icon> {{ text.avg_per }}</b>\n<br>\n<span style=\"font-size:12px;margin-left: 20px;margin-top: 8px\">{{ setting.currency }}{{ data.store.per_person }} </span>\n</ion-col>\n</ion-row>\n\n<ion-row style=\"background: #fbfbfb;padding:10px 10px;margin-top:10px\">\n<ion-col size=\"12\"><b><ion-icon name=\"document-outline\"></ion-icon> {{ text.view_menu }}</b></ion-col>\n\n<ion-col size=\"6\" *ngFor=\"let m of data.store.menu\"><img src=\"{{ m }}\" (click)=\"viewImg(m,1)\"></ion-col>\n\n\n</ion-row>\n\n\n</ion-col>\n\n</ion-row>\n\n\n<!--if store type is delivery-->\n<span *ngIf=\"type == 0\">\n<!--Category display-->\n<ion-segment [(ngModel)]=\"cate_id\" scrollable style=\"background-color: #efeff4\" mode=\"md\">\n<ion-segment-button value=\"0\" mode=\"md\">\n{{ text.all }}\n</ion-segment-button>\n\n<ion-segment-button value=\"{{ cate.id }}\" *ngFor=\"let cate of data.cate\" mode=\"md\">\n{{ cate.name }}\n</ion-segment-button>\n\n</ion-segment>\n\n<div [ngSwitch]=\"cate_id\">\n\n<!--All items-->\n<div *ngSwitchCase=\"0\">\n\n<ion-row *ngFor=\"let item of items | filter:q\" style=\"padding: 5px 10px;background-color: white;margin-bottom: 10px;\">\n<ion-col size=\"5\"><img src=\"{{ item.img }}\" style=\"border-radius: 5px;height: 90%;\" *ngIf=\"item.img\" (click)=\"viewImg(item.img)\"> \n\n<ion-badge style=\"position: absolute;z-index: 99;top:0px;left:0px\" *ngIf=\"!item.stock\" color=\"danger\">{{ text.out_stock }}</ion-badge>\n\n</ion-col>\n<ion-col size=\"7\">\n\n<ion-row>\n<ion-col size=\"12\"><span class=\"sname\">{{ item.name }}</span><br><small style=\"color:gray;font-size: 14px;\">{{ item.desc }}</small></ion-col>\n<ion-col size=\"6\">\n<span style=\"color:#228b88;font-weight: bold\">\n\n<s *ngIf=\"item.mrp > 0\" style=\"color:#ff9800\">{{ setting.currency }}{{ item.mrp }}</s>\n\n{{ setting.currency }}{{ item.price }}</span>\n</ion-col>\n<ion-col size=\"6\" style=\"text-align: right;font-size: 25px\" *ngIf=\"item.stock\">\n\n<span *ngIf=\"!hasCart(item.id)\">\n<small class=\"add\" *ngIf=\"item.count == 1 && item.addon.length == 0\" (click)=\"addToCart(item.id,item.price,0)\">+ Add</small>\n<small class=\"add\" *ngIf=\"item.count > 1 || item.addon.length > 0\" (click)=\"showOption(item)\">+ Add</small>\n</span>\n\n<div class=\"quantitybtn\" *ngIf=\"hasCart(item.id)\">\n\n<button type=\"button\" class=\"sign plus\" data-quantity=\"plus\" data-field=\"quantity\" (click)=\"updateCart(item.id)\"> - </button>\n<input class=\"quantityinput\" type=\"text\" name=\"qty\" value=\"{{ hasCart(item.id) }}\" readonly=\"readonly\">\n\n<button type=\"button\" class=\"sign minus\" data-quantity=\"minus\" data-field=\"quantity\" *ngIf=\"item.count == 1\"\n(click)=\"addToCart(item.id,item.price,0)\">+</button>\n\n<button type=\"button\" class=\"sign minus\" data-quantity=\"minus\"\ndata-field=\"quantity\" *ngIf=\"item.count > 1\"\n(click)=\"showOption(item)\">+</button>\n\n</div>\n\n</ion-col>\n</ion-row>\n\n</ion-col>\n</ion-row>\n</div>\n\n<!--Cate items-->\n<span *ngFor=\"let c of data.cate\">\n<div *ngSwitchCase=\"c.id\" style=\"width:94%;margin:auto;\">\n<span *ngFor=\"let item of items\">\n\n<ion-row style=\"padding: 5px 10px;margin-bottom: 2%;background-color: white;border-radius:5px\" *ngIf=\"item.cate_id == c.id\">\n<ion-col size=\"5\"><img src=\"{{ item.img }}\" style=\"border-radius: 5px\" *ngIf=\"item.img\" (click)=\"viewImg(item.img)\">\n\n<ion-badge style=\"position: absolute;z-index: 99;top:0px;left:0px\" *ngIf=\"!item.stock\" color=\"danger\">{{ text.out_stock }}</ion-badge>\n\n</ion-col>\n<ion-col size=\"7\">\n\n<ion-row>\n<ion-col size=\"12\">{{ item.name }}<br><small style=\"color:gray\">{{ item.desc }}</small></ion-col>\n<ion-col size=\"6\"><span style=\"color:#228b88;font-weight: bold\">\n<s *ngIf=\"item.mrp > 0\" style=\"color:#ff9800\">{{ setting.currency }}{{ item.mrp }}</s>\n{{ setting.currency }}{{ item.price }}</span></ion-col>\n<ion-col size=\"6\" style=\"text-align: right;font-size: 25px\" *ngIf=\"item.stock\">\n\n<span *ngIf=\"!hasCart(item.id)\">\n<small class=\"add\" *ngIf=\"item.count == 1 && item.addon.length == 0\" (click)=\"addToCart(item.id,item.price,0)\">+ {{ text.add }}</small>\n<small class=\"add\" *ngIf=\"item.count > 1 || item.addon.length > 0\" (click)=\"showOption(item)\">+ {{ text.add }}</small>\n</span>\n\n<div class=\"quantitybtn\" *ngIf=\"hasCart(item.id)\">\n\n<button type=\"button\" class=\"sign plus\" data-quantity=\"plus\" data-field=\"quantity\" (click)=\"updateCart(item.id)\"> - </button>\n<input class=\"quantityinput\" type=\"text\" name=\"qty\" value=\"{{ hasCart(item.id) }}\" readonly=\"readonly\">\n\n<button type=\"button\" class=\"sign minus\" data-quantity=\"minus\" data-field=\"quantity\" *ngIf=\"item.count == 1\"\n(click)=\"addToCart(item.id,item.price,0)\">+</button>\n\n<button type=\"button\" class=\"sign minus\" data-quantity=\"minus\"\ndata-field=\"quantity\" *ngIf=\"item.count > 1\"\n(click)=\"showOption(item)\">+</button>\n\n</div>\n\n</ion-col>\n</ion-row>\n\n</ion-col>\n</ion-row>\n\n</span>\n</div>\n</span>\n</div>\n</span>\n\n\n<!--if Store type is dining-->\n\n</div>\n</ion-content>\n";

/***/ })

}]);
//# sourceMappingURL=src_app_item_item_module_ts.js.map