import { Component, OnInit } from '@angular/core';
import { ActivatedRoute } from '@angular/router';
import { ServerService } from '../service/server.service';
import { ToastController,NavController,Platform,LoadingController,ActionSheetController } from '@ionic/angular';
import { FilePath } from '@awesome-cordova-plugins/file-path/ngx';
import { FileTransfer, FileUploadOptions, FileTransferObject } from '@awesome-cordova-plugins/file-transfer/ngx';
import { File } from '@awesome-cordova-plugins/file/ngx';
import { Camera, CameraOptions,PictureSourceType } from '@awesome-cordova-plugins/camera/ngx';
declare var cordova: any;

@Component({
  selector: 'app-product',
  templateUrl: './product.page.html',
  styleUrls: ['./product.page.scss'],
})

export class ProductPage implements OnInit {
  
  text:any;
  cate:any;  
  unit:any;
  data:any;
  category_id:any;
  food_type:any;
  name:any;
  description:any;
  sort_no:any;
  unit1:any;  
  unit2:any;  
  unit3:any;
  small_price:any;  
  medium_price:any;  
  large_price:any;
  cate_name:any;
  type:any;
  new_cate:any; 

  lastImage:any;
  showImage:any;
  apiUrl:any;


  constructor(private platform : Platform, private camera: Camera,public actionSheetController: ActionSheetController,private transfer: FileTransfer,private filePath: FilePath,private file: File,private route: ActivatedRoute,public server : ServerService,public toastController: ToastController,private nav: NavController,public loadingController: LoadingController){

  this.text = JSON.parse(localStorage.getItem('app_text'));
  this.cate = JSON.parse(localStorage.getItem('cate'));
  this.unit = JSON.parse(localStorage.getItem('unit'));
  this.type = this.route.snapshot.paramMap.get('type');
  this.data = JSON.parse(localStorage.getItem('idata'));
  this.cate_name = this.text.select;
  this.apiUrl = this.server.getApi();


  if(this.type > 0)
  {
    this.category_id  = this.data.cate_id;
    this.food_type    = this.data.food_type;
    this.name         = this.data.name;
    this.description  = this.data.desc;
    this.sort_no      = this.data.sort_no;
    this.unit1        = this.data.unit1;
    this.unit2        = this.data.unit2;
    this.unit3        = this.data.unit3;
    this.small_price  = this.data.s_price;
    this.medium_price = this.data.m_price;
    this.large_price  = this.data.l_price;
    this.cate_name    = this.data.cate_name;

  }

  }

  ngOnInit()
  {

  }

  async addProduct(data)
  {
    if(!this.category_id || !this.name)
    {
      return this.presentToast("Please enter valid details");
    }

    const loading = await this.loadingController.create({
      message: '',
      spinner : 'bubbles',
      duration:3000
      
    });
    await loading.present();

    var ptype:any = this.type > 0 ? this.type : "add";

    this.server.addProduct(data,ptype).subscribe((response:any) => {
  
    if(this.lastImage)
    {
      this.uploadImage(response.id);
    }
    else
    {
      this.presentToast("Product Added Successfully");

      this.nav.navigateBack('/item');
    }

    loading.dismiss();

    });
  }

  async presentToast(txt) {
    const toast = await this.toastController.create({
      message: txt,
      duration: 3000,
      position : 'top',
      mode:'ios',
      color:'dark'
    });
    toast.present();
  }

  async showOption()
  {
    const actionSheet = await this.actionSheetController.create({
      header: 'Select Option',
      cssClass: 'my-custom-class',
      buttons: [{
        text: 'From Camera',
        icon: 'camera',
        
        handler: () => {
          
        this.selectImage(this.camera.PictureSourceType.CAMERA);

        }
      }, {
        text: 'From Photo Gallery',
        icon: 'image',
        handler: () => {
          this.selectImage(this.camera.PictureSourceType.PHOTOLIBRARY);
        }
      }]
    });
    await actionSheet.present();

    const { role, data } = await actionSheet.onDidDismiss();
    console.log('onDidDismiss resolved with role and data', role, data);
  }

  selectImage(src)
  {
    this.takePicture(src);
  }

  takePicture(sourceType: PictureSourceType) {
    
    var options: CameraOptions = {
        quality: 100,
        sourceType: sourceType,
        saveToPhotoAlbum: false,
        correctOrientation: false,
        allowEdit: false,
    };
 
    this.camera.getPicture(options).then(imagePath => {
        if (this.platform.is('android') && sourceType === this.camera.PictureSourceType.PHOTOLIBRARY) {
            this.filePath.resolveNativePath(imagePath)
                .then(filePath => {
                    let correctPath = filePath.substr(0, filePath.lastIndexOf('/') + 1);
                    let currentName = imagePath.substring(imagePath.lastIndexOf('/') + 1, imagePath.lastIndexOf('?'));
                    this.file.readAsDataURL(correctPath, currentName).then(res=> this.showImage = res  );
                    
                    this.copyFileToLocalDir(correctPath, currentName, this.createFileName());
                });
        } else {
            var currentName = imagePath.substr(imagePath.lastIndexOf('/') + 1);
            var correctPath = imagePath.substr(0, imagePath.lastIndexOf('/') + 1);
            this.file.readAsDataURL(correctPath, currentName).then(res=> this.showImage = res  );

            this.copyFileToLocalDir(correctPath, currentName, this.createFileName());
        }
    });
 
}

createFileName() {
    var d = new Date(),
        n = d.getTime(),
        newFileName = n + ".jpg";
    return newFileName;
}
 
copyFileToLocalDir(namePath, currentName, newFileName) {
    this.file.copyFile(namePath, currentName, cordova.file.dataDirectory, newFileName).then(success => {
    
    this.lastImage = newFileName;

    }, error => {
        this.presentToast('Error while storing file.');
    });
}
 
pathForImage(img) {
    if (img === null) {
      return '';
    } else {
      return cordova.file.dataDirectory + img;
    }
  }

removeImage()
{
  this.lastImage = null;
}

async uploadImage(id)
{

    var url         = this.apiUrl+"uploadImage?item_id="+id;

    console.log(url);

    var targetPath  = this.pathForImage(this.lastImage);
    var filename    = this.lastImage;

  
    var options = {
      fileKey: "file",
      fileName: filename,
      chunkedMode: false,
      mimeType: "multipart/form-data",
      params : {'file': filename}
    };
   
    const fileTransfer: FileTransferObject = this.transfer.create();
   
    const loading = await this.loadingController.create({
        message: 'Uploading image...',
      });
  
    await loading.present();

    // Use the FileTransfer to upload the image
    fileTransfer.upload(targetPath, url, options).then((data:any) => {

    this.nav.navigateRoot('/item');

      loading.dismiss();

    }, err => {
      
      this.presentToast('Error while uploading file.');
      loading.dismiss();
    });
 }
}
