(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["signup-signup-module"],{

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/signup/signup.page.html":
/*!*******************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/signup/signup.page.html ***!
  \*******************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<ion-content class=\"ion-padding\" *ngIf=\"text && data && setting\" #content>\n\n<ion-icon name=\"arrow-back-outline\" style=\"font-size: 26px\" routerLink=\"/login\" routerDirection=\"backword\"></ion-icon>\n\n<br><br><br>\n\n<h1 align=\"center\">{{ text.s_signup_title }}</h1>\n<p align=\"center\">{{ text.s_signup_desc }}</p>\n<br>\n\n<form #form=\"ngForm\" (ngSubmit)=\"makeOrder(form.value)\">\n\n<ion-item mode=\"md\" lines=\"none\">\n  <ion-label position=\"floating\">{{ text.s_signup_name }}</ion-label>\n  <ion-input type=\"text\" ngModel name=\"name\" required></ion-input>\n</ion-item>\n\n<ion-item mode=\"md\" lines=\"none\">\n  <ion-label position=\"floating\">{{ text.s_signup_phone }}</ion-label>\n  <ion-input type=\"tel\" ngModel name=\"phone\" required></ion-input>\n</ion-item>\n\n<ion-item mode=\"md\" lines=\"none\">\n  <ion-label position=\"floating\">{{ text.s_signup_address }}</ion-label>\n  <ion-input type=\"text\" ngModel name=\"address\" required></ion-input>\n</ion-item>\n\n<ion-item mode=\"md\" lines=\"none\">\n  <ion-label position=\"floating\">{{ text.s_signup_pass }}</ion-label>\n  <ion-input type=\"password\" ngModel name=\"password\" required></ion-input>\n</ion-item>\n\n\n<br><br>\n<ion-row *ngFor=\"let plan of data.plan\" class=\"plan\" (click)=\"selectPlan(plan)\" [class]=\"plan.id == plan_id ? 'activeCard' : 'non'\">\n\n<ion-col size=\"12\"><b>{{ plan.name }} <ion-chip style=\"float: right\" color=\"primary\">{{ plan.currency }}{{ plan.price }}</ion-chip></b></ion-col>\n\n<ion-col size=\"12\" style=\"font-size: 12px\">{{ plan.desc }}</ion-col>\n\n<ion-col size=\"12\" style=\"font-size: 12px\">\n<p><ion-icon name=\"checkmark-outline\"></ion-icon> {{ text.time_period }} : {{ plan.time }}</p>\n\n<p *ngFor=\"let fet of plan.feat\"><ion-icon name=\"checkmark-outline\"></ion-icon> {{ fet }}</p>\n\n</ion-col>\n\n</ion-row>\n\n<span *ngIf=\"amount > 0\">\n<h3>{{ text.payment_method }}</h3>\n\n<ion-card mode=\"ios\" (click)=\"setPayment(0)\" [class]=\"payment == 0 ? 'activeCard' : 'non'\">\n\n<ion-card-header>\n<ion-card-subtitle [class]=\"payment == 0 ? 'activeHeader' : 'non'\">{{ text.pay_with_cash }} <ion-icon [name]=\"payment == 0 ? 'cash' : 'cash-outline'\" class=\"paymentIcon\"></ion-icon></ion-card-subtitle>\n</ion-card-header>\n</ion-card>\n\n<ion-card mode=\"ios\" (click)=\"setPayment(3)\" [class]=\"payment == 3 ? 'activeCard' : 'non'\">\n\n<ion-card-header>\n<ion-card-subtitle [class]=\"payment == 3 ? 'activeHeader' : 'non'\">{{ text.bank_transfer }} <ion-icon [name]=\"payment == 3 ? 'cash' : 'cash-outline'\" class=\"paymentIcon\"></ion-icon></ion-card-subtitle>\n</ion-card-header>\n\n<ion-card-content style=\"font-size: 12px\">\n<span [innerHTML]=\"data.setting.bank_transfer\"></span>\n</ion-card-content>\n\n</ion-card>\n\n<ion-card mode=\"ios\" (click)=\"setPayment(2)\" [class]=\"payment == 2 ? 'activeCard' : 'non'\" *ngIf=\"data.setting.stripe_key\">\n\n<ion-card-header>\n<ion-card-subtitle [class]=\"payment == 2 ? 'activeHeader' : 'non'\">{{ text.stripe }} <ion-icon [name]=\"payment == 2 ? 'card' : 'card-outline'\" class=\"paymentIcon\"></ion-icon></ion-card-subtitle>\n</ion-card-header>\n\n</ion-card>\n\n\n<ion-card mode=\"ios\" (click)=\"setPayment(4)\" [class]=\"payment == 4 ? 'activeCard' : 'non'\" *ngIf=\"data.setting.razor_key\">\n\n<ion-card-header>\n<ion-card-subtitle [class]=\"payment == 4 ? 'activeHeader' : 'non'\">{{ text.razor }} <ion-icon [name]=\"payment == 4 ? 'wallet' : 'wallet-outline'\" class=\"paymentIcon\"></ion-icon></ion-card-subtitle>\n</ion-card-header>\n\n</ion-card>\n\n<div *ngIf=\"stripeView\">\n\n<p style=\"margin-top: 15%\">{{ text.stripe_title }}</p>\n<ion-row>\n\n<ion-col size=\"12\">\n<ion-item mode=\"md\" lines=\"none\">\n  <ion-label position=\"floating\">{{ text.card_no }}</ion-label>\n  <ion-input type=\"tel\" [(ngModel)]=\"card_no\" name=\"card_no\"></ion-input>\n</ion-item>\n</ion-col>\n\n<ion-col size=\"6\">\n<ion-item mode=\"md\" lines=\"none\">\n  <ion-label position=\"floating\">{{ text.exp_month }}</ion-label>\n  <ion-input type=\"tel\" [(ngModel)]=\"exp_month\" name=\"exp_month\"></ion-input>\n</ion-item>\n</ion-col>\n\n<ion-col size=\"6\">\n<ion-item mode=\"md\" lines=\"none\">\n  <ion-label position=\"floating\">{{ text.exp_year }}</ion-label>\n  <ion-input type=\"tel\" [(ngModel)]=\"exp_year\" name=\"exp_year\"></ion-input>\n</ion-item>\n</ion-col>\n\n<ion-col size=\"6\">\n<ion-item mode=\"md\" lines=\"none\">\n  <ion-label position=\"floating\">{{ text.cvv }}</ion-label>\n  <ion-input type=\"tel\" [(ngModel)]=\"cvv\" name=\"cvv\"></ion-input>\n</ion-item>\n</ion-col>\n</ion-row>\n</div>\n\n<ion-item *ngIf=\"payment == 3\" mode=\"md\" lines=\"none\">\n  <ion-label position=\"floating\">{{ text.notes_bank }}</ion-label>\n  <ion-input type=\"text\" ngModel name=\"notes\"></ion-input>\n</ion-item>\n</span>\n\n<ion-item class=\"ion-text-wrap\">\n    <ion-label class=\"ion-text-wrap\" style=\"font-size: 12px\">{{ text.term_text }} <a href=\"{{ setting.term }}\" target=\"_blank\">{{ text.term }}</a></ion-label>\n    <ion-checkbox slot=\"start\" (ionChange)=\"term()\"></ion-checkbox>\n  </ion-item>\n\n<br><br>\n<ion-button expand=\"block\" mode=\"ios\" type=\"submit\" [disabled]=\"!form.valid || !hasTerm\">{{ text.submit_btn }}</ion-button>\n\n</form>\n\n</ion-content>\n");

/***/ }),

/***/ "./src/app/signup/signup-routing.module.ts":
/*!*************************************************!*\
  !*** ./src/app/signup/signup-routing.module.ts ***!
  \*************************************************/
/*! exports provided: SignupPageRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SignupPageRoutingModule", function() { return SignupPageRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/__ivy_ngcc__/fesm2015/router.js");
/* harmony import */ var _signup_page__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./signup.page */ "./src/app/signup/signup.page.ts");




const routes = [
    {
        path: '',
        component: _signup_page__WEBPACK_IMPORTED_MODULE_3__["SignupPage"]
    }
];
let SignupPageRoutingModule = class SignupPageRoutingModule {
};
SignupPageRoutingModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]],
    })
], SignupPageRoutingModule);



/***/ }),

/***/ "./src/app/signup/signup.module.ts":
/*!*****************************************!*\
  !*** ./src/app/signup/signup.module.ts ***!
  \*****************************************/
/*! exports provided: SignupPageModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SignupPageModule", function() { return SignupPageModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/__ivy_ngcc__/fesm2015/common.js");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/__ivy_ngcc__/fesm2015/forms.js");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ "./node_modules/@ionic/angular/__ivy_ngcc__/fesm2015/ionic-angular.js");
/* harmony import */ var _signup_routing_module__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./signup-routing.module */ "./src/app/signup/signup-routing.module.ts");
/* harmony import */ var _signup_page__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./signup.page */ "./src/app/signup/signup.page.ts");







let SignupPageModule = class SignupPageModule {
};
SignupPageModule = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_2__["CommonModule"],
            _angular_forms__WEBPACK_IMPORTED_MODULE_3__["FormsModule"],
            _ionic_angular__WEBPACK_IMPORTED_MODULE_4__["IonicModule"],
            _signup_routing_module__WEBPACK_IMPORTED_MODULE_5__["SignupPageRoutingModule"]
        ],
        declarations: [_signup_page__WEBPACK_IMPORTED_MODULE_6__["SignupPage"]]
    })
], SignupPageModule);



/***/ }),

/***/ "./src/app/signup/signup.page.scss":
/*!*****************************************!*\
  !*** ./src/app/signup/signup.page.scss ***!
  \*****************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = (".paymentIcon {\n  float: right;\n  font-size: 28px;\n  margin-top: -3%;\n}\n\n.activeCard {\n  background-color: var(--ion-color-primary);\n  color: white;\n}\n\n.activeHeader {\n  color: white;\n}\n\n.plan {\n  border: 1px solid #e3e3e3;\n  padding: 10px 10px;\n  margin-bottom: 5%;\n  border-radius: 10px;\n}\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInNyYy9hcHAvc2lnbnVwL3NpZ251cC5wYWdlLnNjc3MiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUE7RUFFQyxZQUFBO0VBQWEsZUFBQTtFQUFnQixlQUFBO0FBRTlCOztBQUNBO0VBRUMsMENBQUE7RUFDQSxZQUFBO0FBQ0Q7O0FBT0E7RUFFQyxZQUFBO0FBTEQ7O0FBUUE7RUFFQyx5QkFBQTtFQUNBLGtCQUFBO0VBQ0EsaUJBQUE7RUFDQSxtQkFBQTtBQU5EIiwiZmlsZSI6InNyYy9hcHAvc2lnbnVwL3NpZ251cC5wYWdlLnNjc3MiLCJzb3VyY2VzQ29udGVudCI6WyIucGF5bWVudEljb25cbntcblx0ZmxvYXQ6IHJpZ2h0O2ZvbnQtc2l6ZTogMjhweDttYXJnaW4tdG9wOiAtMyU7XG59XG5cbi5hY3RpdmVDYXJkXG57XG5cdGJhY2tncm91bmQtY29sb3I6IHZhcigtLWlvbi1jb2xvci1wcmltYXJ5KTtcblx0Y29sb3I6d2hpdGU7XG59XG5cbi5ub25cbntcblx0XG59XG5cbi5hY3RpdmVIZWFkZXJcbntcblx0Y29sb3I6d2hpdGU7XG59XG5cbi5wbGFuXG57XG5cdGJvcmRlcjoxcHggc29saWQgI2UzZTNlMztcblx0cGFkZGluZzoxMHB4IDEwcHg7XG5cdG1hcmdpbi1ib3R0b206NSU7XG5cdGJvcmRlci1yYWRpdXM6IDEwcHg7XG59Il19 */");

/***/ }),

/***/ "./src/app/signup/signup.page.ts":
/*!***************************************!*\
  !*** ./src/app/signup/signup.page.ts ***!
  \***************************************/
/*! exports provided: SignupPage */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SignupPage", function() { return SignupPage; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/__ivy_ngcc__/fesm2015/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/__ivy_ngcc__/fesm2015/router.js");
/* harmony import */ var _service_server_service__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../service/server.service */ "./src/app/service/server.service.ts");
/* harmony import */ var _ionic_angular__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @ionic/angular */ "./node_modules/@ionic/angular/__ivy_ngcc__/fesm2015/ionic-angular.js");
/* harmony import */ var _ionic_native_stripe_ngx__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! @ionic-native/stripe/ngx */ "./node_modules/@ionic-native/stripe/__ivy_ngcc__/ngx/index.js");






let SignupPage = class SignupPage {
    constructor(route, server, toastController, nav, loadingController, stripe) {
        this.route = route;
        this.server = server;
        this.toastController = toastController;
        this.nav = nav;
        this.loadingController = loadingController;
        this.stripe = stripe;
        this.stripeView = false;
        this.hasTerm = false;
        this.text = JSON.parse(localStorage.getItem('app_text'));
        this.setting = JSON.parse(localStorage.getItem('setting'));
    }
    ngOnInit() {
        this.loadData();
    }
    term() {
        this.hasTerm = this.hasTerm == true ? false : true;
    }
    selectPlan(plan) {
        this.plan_id = plan.id;
        this.amount = plan.price;
        if (plan.price == 0) {
            this.payment_id = "Trial_Pack";
        }
    }
    setPayment(id) {
        this.payment = id;
        setTimeout(() => {
            this.content.scrollToBottom(300);
        }, 100);
        if (id == 2) {
            this.stripeView = true;
        }
        else {
            this.stripeView = false;
        }
    }
    loadData() {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                message: '',
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.plan().subscribe((response) => {
                this.data = response.data;
                loading.dismiss();
            });
        });
    }
    signup(data) {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                message: '',
                spinner: 'bubbles',
                duration: 3000
            });
            yield loading.present();
            var allData = {
                data: data,
                payment_id: this.payment_id,
                payment_method: this.amount == 0 ? 2 : this.payment,
                plan_id: this.plan_id
            };
            console.log(allData);
            this.server.signup(allData).subscribe((response) => {
                if (response.data != "done") {
                    this.presentToast(this.text.s_email_error);
                }
                else {
                    this.presentToast(this.text.s_signup_msg);
                    this.nav.navigateBack('/login');
                }
                loading.dismiss();
            });
        });
    }
    presentToast(txt) {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            const toast = yield this.toastController.create({
                message: txt,
                duration: 3000,
                position: 'top',
                mode: 'ios',
                color: 'dark'
            });
            toast.present();
        });
    }
    makeOrder(formData) {
        if (this.payment == 2) {
            this.payWithStripe(formData);
        }
        else if (this.payment == 4) {
            this.payWithRazor(formData);
        }
        else {
            this.signup(formData);
        }
    }
    payWithStripe(formData) {
        var cNo = this.card_no;
        if (cNo && cNo.length == 16 && this.exp_month.length == 2 && this.exp_year.length == 4 && this.cvv.length == 3) {
            this.stripe.setPublishableKey(this.data.setting.stripe_key);
            let card = {
                number: cNo,
                expMonth: this.exp_month,
                expYear: this.exp_year,
                cvc: this.cvv
            };
            var cardNo = false;
            var cvvCorrect = false;
            //validate card no
            this.stripe.validateCardNumber(cNo)
                .then(res => {
                this.stripe.createCardToken(card)
                    .then(token => {
                    if (token.id) {
                        this.makePayment(token.id, cNo, formData);
                    }
                    else {
                        this.presentToast(this.text.card_no_validation);
                    }
                })
                    .catch(error => {
                    this.presentToast(this.text.stripe_config);
                });
            })
                .catch(error => {
                this.presentToast(this.text.card_no_validation);
            });
        }
        else {
            this.presentToast(this.text.stripe_validation);
        }
    }
    makePayment(token, cNo, formData) {
        return Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__awaiter"])(this, void 0, void 0, function* () {
            const loading = yield this.loadingController.create({
                spinner: 'bubbles'
            });
            yield loading.present();
            this.server.makeStripePayment("?token=" + token + "&amount=" + this.amount).subscribe((response) => {
                if (response.data == "done") {
                    this.payment_id = response.id;
                    if (this.payment_id) {
                        this.signup(formData);
                    }
                }
                else {
                    this.presentToast(response.error);
                }
                loading.dismiss();
            });
        });
    }
    payWithRazor(formData) {
        var options = {
            description: 'Pay Now',
            image: 'https://cdn.iconscout.com/icon/free/png-512/bhim-3-69845.png',
            currency: this.data.setting.currency_code,
            key: this.data.setting.razor_key,
            amount: this.amount * 100,
            name: 'Signup Your Store',
            prefill: {
                email: "signup@google.com",
                contact: formData.phone,
                name: formData.name
            },
            theme: {
                color: '#2196f3'
            },
            modal: {
                ondismiss: function () {
                    alert('dismissed');
                }
            }
        };
        var successCallback = (success) => {
            this.payment_id = success;
            if (this.payment_id) {
                this.signup(formData);
            }
        };
        var cancelCallback = function (error) {
            alert(error.description + ' (Error ' + error.code + ')');
        };
        RazorpayCheckout.open(options, successCallback, cancelCallback);
    }
};
SignupPage.ctorParameters = () => [
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_2__["ActivatedRoute"] },
    { type: _service_server_service__WEBPACK_IMPORTED_MODULE_3__["ServerService"] },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__["ToastController"] },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__["NavController"] },
    { type: _ionic_angular__WEBPACK_IMPORTED_MODULE_4__["LoadingController"] },
    { type: _ionic_native_stripe_ngx__WEBPACK_IMPORTED_MODULE_5__["Stripe"] }
];
SignupPage.propDecorators = {
    content: [{ type: _angular_core__WEBPACK_IMPORTED_MODULE_1__["ViewChild"], args: ['content', { static: false },] }]
};
SignupPage = Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"])([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
        selector: 'app-signup',
        template: Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! raw-loader!./signup.page.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/signup/signup.page.html")).default,
        styles: [Object(tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"])(__webpack_require__(/*! ./signup.page.scss */ "./src/app/signup/signup.page.scss")).default]
    })
], SignupPage);



/***/ })

}]);
//# sourceMappingURL=signup-signup-module-es2015.js.map